/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.RateLimitedFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.IndexStoreModule;

public class FsDirectoryService
extends DirectoryService
implements StoreRateLimiting.Listener,
StoreRateLimiting.Provider {
    protected final IndexStore indexStore;
    private final CounterMetric rateLimitingTimeInNanos = new CounterMetric();
    private final ShardPath path;
    private static final Set<String> PRIMARY_EXTENSIONS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"nvd", "dvd", "tim"}));

    @Inject
    public FsDirectoryService(IndexSettingsService indexSettingsService, IndexStore indexStore, ShardPath path) {
        this(indexSettingsService.getSettings(), indexStore, path);
    }

    public FsDirectoryService(Settings indexSettings, IndexStore indexStore, ShardPath path) {
        super(path.getShardId(), indexSettings);
        this.path = path;
        this.indexStore = indexStore;
    }

    @Override
    public long throttleTimeInNanos() {
        return this.rateLimitingTimeInNanos.count();
    }

    @Override
    public StoreRateLimiting rateLimiting() {
        return this.indexStore.rateLimiting();
    }

    public static LockFactory buildLockFactory(Settings indexSettings) {
        NativeFSLockFactory lockFactory;
        String fsLock = indexSettings.get("index.store.fs.lock", indexSettings.get("index.store.fs.fs_lock", "native"));
        if (fsLock.equals("native")) {
            lockFactory = NativeFSLockFactory.INSTANCE;
        } else if (fsLock.equals("simple")) {
            lockFactory = SimpleFSLockFactory.INSTANCE;
        } else {
            throw new IllegalArgumentException("unrecognized fs_lock \"" + fsLock + "\": must be native or simple");
        }
        return lockFactory;
    }

    protected final LockFactory buildLockFactory() throws IOException {
        return FsDirectoryService.buildLockFactory(this.indexSettings);
    }

    @Override
    public Directory newDirectory() throws IOException {
        Path location = this.path.resolveIndex();
        Files.createDirectories(location, new FileAttribute[0]);
        Directory wrapped = this.newFSDirectory(location, this.buildLockFactory());
        return new RateLimitedFSDirectory(wrapped, this, this);
    }

    @Override
    public void onPause(long nanos) {
        this.rateLimitingTimeInNanos.inc(nanos);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory) throws IOException {
        String storeType = this.indexSettings.get("index.store.type", IndexStoreModule.Type.DEFAULT.getSettingsKey());
        if (IndexStoreModule.Type.FS.match(storeType) || IndexStoreModule.Type.DEFAULT.match(storeType)) {
            FSDirectory open = FSDirectory.open((Path)location, (LockFactory)lockFactory);
            if (open instanceof MMapDirectory && !Constants.WINDOWS) {
                return this.newDefaultDir(location, (MMapDirectory)open, lockFactory);
            }
            return open;
        }
        if (IndexStoreModule.Type.SIMPLEFS.match(storeType)) {
            return new SimpleFSDirectory(location, lockFactory);
        }
        if (IndexStoreModule.Type.NIOFS.match(storeType)) {
            return new NIOFSDirectory(location, lockFactory);
        }
        if (IndexStoreModule.Type.MMAPFS.match(storeType)) {
            return new MMapDirectory(location, lockFactory);
        }
        throw new IllegalArgumentException("No directory found for type [" + storeType + "]");
    }

    private Directory newDefaultDir(Path location, final MMapDirectory mmapDir, LockFactory lockFactory) throws IOException {
        return new FileSwitchDirectory(PRIMARY_EXTENSIONS, (Directory)mmapDir, (Directory)new NIOFSDirectory(location, lockFactory), true){

            public String[] listAll() throws IOException {
                return mmapDir.listAll();
            }
        };
    }
}

