/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.jobhistory.AMStarted;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMStartedEvent
implements HistoryEvent {
    private AMStarted datum = new AMStarted();
    private String forcedJobStateOnShutDown;

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort) {
        this(appAttemptId, startTime, containerId, nodeManagerHost, nodeManagerPort, nodeManagerHttpPort, null);
    }

    public AMStartedEvent(ApplicationAttemptId appAttemptId, long startTime, ContainerId containerId, String nodeManagerHost, int nodeManagerPort, int nodeManagerHttpPort, String forcedJobStateOnShutDown) {
        this.datum.setApplicationAttemptId((CharSequence)new Utf8(appAttemptId.toString()));
        this.datum.setStartTime(startTime);
        this.datum.setContainerId((CharSequence)new Utf8(containerId.toString()));
        this.datum.setNodeManagerHost((CharSequence)new Utf8(nodeManagerHost));
        this.datum.setNodeManagerPort(nodeManagerPort);
        this.datum.setNodeManagerHttpPort(nodeManagerHttpPort);
        this.forcedJobStateOnShutDown = forcedJobStateOnShutDown;
    }

    AMStartedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (AMStarted)((Object)datum);
    }

    public ApplicationAttemptId getAppAttemptId() {
        return ConverterUtils.toApplicationAttemptId((String)this.datum.getApplicationAttemptId().toString());
    }

    public long getStartTime() {
        return this.datum.getStartTime();
    }

    public ContainerId getContainerId() {
        return ConverterUtils.toContainerId((String)this.datum.getContainerId().toString());
    }

    public String getNodeManagerHost() {
        return this.datum.getNodeManagerHost().toString();
    }

    public int getNodeManagerPort() {
        return this.datum.getNodeManagerPort();
    }

    public int getNodeManagerHttpPort() {
        return this.datum.getNodeManagerHttpPort();
    }

    public String getForcedJobStateOnShutDown() {
        return this.forcedJobStateOnShutDown;
    }

    @Override
    public EventType getEventType() {
        return EventType.AM_STARTED;
    }
}

