/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.pentaho.osgi.i18n.resource.OSGIResourceBundle;

public class OSGIResourceBundleFactory {
    private final int priority;
    private final String defaultName;
    private final String relativeName;
    private final URL propertyFileUrl;
    private ResourceBundle previousParent = null;
    private OSGIResourceBundle previousResult = null;

    public OSGIResourceBundleFactory(String defaultName, String relativeName, URL propertyFileUrl, int priority) {
        this.defaultName = defaultName;
        this.priority = priority;
        this.relativeName = relativeName;
        this.propertyFileUrl = propertyFileUrl;
    }

    public synchronized OSGIResourceBundle getBundle(ResourceBundle parent) throws IOException {
        if (this.previousResult == null || this.previousParent != parent) {
            this.previousParent = parent;
            this.previousResult = new OSGIResourceBundle(this.defaultName, parent, this.propertyFileUrl);
        }
        return this.previousResult;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getPropertyFilePath() {
        return this.relativeName;
    }
}

