/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig
implements ISystemConfig {
    private final Map<String, IConfiguration> configs = new ConcurrentHashMap<String, IConfiguration>();
    private static final Pattern pattern = Pattern.compile("([^\\.]+)\\.(.+)");
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SystemConfig() {
    }

    public SystemConfig(List<IConfiguration> startingConfigs) throws IOException {
        for (IConfiguration startingConfig : startingConfigs) {
            this.registerConfiguration(startingConfig);
        }
    }

    public String getProperty(String placeholder) {
        if (!pattern.matcher(placeholder).matches()) {
            throw new IllegalArgumentException("property does not follow the pattern ID.PROP");
        }
        return this.resolveValue(placeholder);
    }

    private String resolveValue(String placeholder) {
        Matcher matcher = pattern.matcher(placeholder);
        matcher.find();
        String pid = matcher.group(1);
        String key = matcher.group(2);
        IConfiguration con = this.getConfiguration(pid);
        if (con == null) {
            this.logger.info("Error resolving key replacement: " + placeholder);
            return null;
        }
        try {
            return con.getProperties().getProperty(key);
        }
        catch (IOException e) {
            this.logger.error("Error getting properties for configuration: " + key);
            return null;
        }
    }

    public IConfiguration getConfiguration(String configId) {
        return this.configs.get(configId);
    }

    public void registerConfiguration(IConfiguration configuration) throws IOException {
        String configId = configuration.getId();
        if (configId == null) {
            throw new IllegalStateException("Config id is null");
        }
        if (this.configs.containsKey(configId)) {
            try {
                this.configs.get(configId).update(configuration.getProperties());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        } else {
            this.configs.put(configId, configuration);
        }
    }

    public IConfiguration[] listConfigurations() {
        Collection<IConfiguration> entries = this.configs.values();
        return entries.toArray(new IConfiguration[entries.size()]);
    }
}

