/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.IPluginProvider;
import org.pentaho.platform.api.engine.PlatformPluginRegistrationException;
import org.pentaho.platform.api.engine.PluginBeanDefinition;
import org.pentaho.platform.api.engine.PluginServiceDefinition;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.platform.engine.core.solution.ContentGeneratorInfo;
import org.pentaho.platform.engine.core.solution.ContentInfo;
import org.pentaho.platform.engine.core.solution.PluginOperation;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.PerspectiveUtil;
import org.pentaho.platform.plugin.services.pluginmgr.PlatformPlugin;
import org.pentaho.platform.plugin.services.pluginmgr.PluginMessageLogger;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.impl.DefaultXulOverlay;
import org.xml.sax.EntityResolver;

public class SystemPathXmlPluginProvider
implements IPluginProvider {
    public List<IPlatformPlugin> getPlugins(IPentahoSession session) throws PlatformPluginRegistrationException {
        File[] kids;
        ArrayList<IPlatformPlugin> plugins = new ArrayList<IPlatformPlugin>();
        String systemPath = PentahoSystem.getApplicationContext().getSolutionPath("system");
        File systemDir = new File(systemPath);
        if (!systemDir.exists() || !systemDir.isDirectory()) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0004_CANNOT_FIND_SYSTEM_FOLDER"));
        }
        for (File kid : kids = systemDir.listFiles()) {
            if (!kid.isDirectory()) continue;
            try {
                this.processDirectory(plugins, kid, session);
            }
            catch (Throwable t) {
                String msg = Messages.getInstance().getErrorString("SystemPathXmlPluginProvider.ERROR_0001_FAILED_TO_PROCESS_PLUGIN", new Object[]{kid.getAbsolutePath()});
                Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                PluginMessageLogger.add(msg);
            }
        }
        return Collections.unmodifiableList(plugins);
    }

    protected void processDirectory(List<IPlatformPlugin> plugins, File folder, IPentahoSession session) throws PlatformPluginRegistrationException {
        NameFileFilter filter = new NameFileFilter("plugin.xml", IOCase.SENSITIVE);
        File[] kids = folder.listFiles((FilenameFilter)filter);
        if (kids == null || kids.length == 0) {
            return;
        }
        boolean hasLib = false;
        filter = new NameFileFilter("lib", IOCase.SENSITIVE);
        kids = folder.listFiles((FilenameFilter)filter);
        if (kids != null && kids.length > 0) {
            hasLib = kids[0].exists() && kids[0].isDirectory();
        }
        String path = "system/" + folder.getName() + "/" + "plugin.xml";
        Document doc = null;
        try {
            try {
                SAXReader reader = new SAXReader();
                reader.setEntityResolver((EntityResolver)new SolutionURIResolver());
                doc = reader.read(ActionSequenceResource.getInputStream((String)path, (Locale)LocaleHelper.getLocale()));
            }
            catch (Throwable reader) {
                // empty catch block
            }
            if (doc != null) {
                plugins.add(this.createPlugin(doc, session, folder.getName(), hasLib));
            }
        }
        catch (Exception e) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0005_CANNOT_PROCESS_PLUGIN_XML", new Object[]{path}), (Throwable)e);
        }
        if (doc == null) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0005_CANNOT_PROCESS_PLUGIN_XML", new Object[]{path}));
        }
    }

    protected PlatformPlugin createPlugin(Document doc, IPentahoSession session, String folder, boolean hasLib) {
        PlatformPlugin plugin = new PlatformPlugin();
        this.processStaticResourcePaths(plugin, doc, session);
        this.processPluginInfo(plugin, doc, folder, session);
        this.processContentTypes(plugin, doc, session);
        this.processContentGenerators(plugin, doc, session, folder, hasLib);
        this.processOverlays(plugin, doc, session);
        this.processLifecycleListeners(plugin, doc);
        this.processBeans(plugin, doc);
        this.processWebservices(plugin, doc);
        this.processExternalResources(plugin, doc);
        this.processPerspectives(plugin, doc);
        String listenerCount = StringUtils.isEmpty((String)plugin.getLifecycleListenerClassname()) ? "0" : "1";
        String msg = Messages.getInstance().getString("SystemPathXmlPluginProvider.PLUGIN_PROVIDES", new Object[]{Integer.toString(plugin.getContentInfos().size()), Integer.toString(plugin.getContentGenerators().size()), Integer.toString(plugin.getOverlays().size()), listenerCount});
        PluginMessageLogger.add(msg);
        plugin.setSourceDescription(folder);
        return plugin;
    }

    protected void processPerspectives(PlatformPlugin plugin, Document doc) {
        List nodes = doc.selectNodes("/*/perspective");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            if (node == null) continue;
            IPluginPerspective perspective = PerspectiveUtil.createPerspective(node);
            plugin.addPluginPerspective(perspective);
        }
    }

    protected void processStaticResourcePaths(PlatformPlugin plugin, Document doc, IPentahoSession session) {
        List nodes = doc.selectNodes("//static-path");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            if (node == null) continue;
            String url = node.attributeValue("url");
            String localFolder = node.attributeValue("localFolder");
            plugin.addStaticResourcePath(url, localFolder);
        }
    }

    protected void processExternalResources(PlatformPlugin plugin, Document doc) {
        Node parentNode = doc.selectSingleNode("//external-resources");
        if (parentNode == null) {
            return;
        }
        for (Object obj : parentNode.selectNodes("file")) {
            Element node = (Element)obj;
            if (node == null) continue;
            String context = node.attributeValue("context");
            String resource = node.getStringValue();
            plugin.addExternalResource(context, resource);
        }
    }

    protected void processLifecycleListeners(PlatformPlugin plugin, Document doc) {
        Element node = (Element)doc.selectSingleNode("//lifecycle-listener");
        if (node != null) {
            String classname = node.attributeValue("class");
            plugin.setLifecycleListenerClassname(classname);
        }
    }

    protected void processBeans(PlatformPlugin plugin, Document doc) {
        List nodes = doc.selectNodes("//bean");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            if (node == null) continue;
            plugin.addBean(new PluginBeanDefinition(node.attributeValue("id"), node.attributeValue("class")));
        }
    }

    protected void processWebservices(PlatformPlugin plugin, Document doc) {
        List nodes = doc.selectNodes("//webservice");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            PluginServiceDefinition pws = new PluginServiceDefinition();
            pws.setId(SystemPathXmlPluginProvider.getProperty(node, "id"));
            String type = SystemPathXmlPluginProvider.getProperty(node, "type");
            if (!StringUtils.isEmpty((String)type)) {
                pws.setTypes(type.split(","));
            }
            pws.setTitle(SystemPathXmlPluginProvider.getProperty(node, "title"));
            pws.setDescription(SystemPathXmlPluginProvider.getProperty(node, "description"));
            pws.setServiceBeanId(SystemPathXmlPluginProvider.getProperty(node, "ref"));
            pws.setServiceClass(SystemPathXmlPluginProvider.getProperty(node, "class"));
            ArrayList<String> extraClasses = new ArrayList<String>();
            List extraNodes = node.selectNodes("extra");
            for (Object extra : extraNodes) {
                Element extraElement = (Element)extra;
                String extraClass = SystemPathXmlPluginProvider.getProperty(extraElement, "class");
                if (extraClasses == null) continue;
                extraClasses.add(extraClass);
            }
            pws.setExtraClasses(extraClasses);
            if (pws.getServiceBeanId() == null && pws.getServiceClass() == null) {
                PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.NO_SERVICE_CLASS_FOUND"));
                continue;
            }
            plugin.addWebservice(pws);
        }
    }

    protected void processPluginInfo(PlatformPlugin plugin, Document doc, String folder, IPentahoSession session) {
        Element node = (Element)doc.selectSingleNode("/plugin");
        if (node != null) {
            String name;
            String string = name = node.attributeValue("name") != null ? node.attributeValue("name") : node.attributeValue("title");
            if (StringUtils.isEmpty((String)name)) {
                String msg = Messages.getInstance().getErrorString("SystemPathXmlPluginProvider.ERROR_0002_PLUGIN_INVALID", new Object[]{folder});
                PluginMessageLogger.add(msg);
                Logger.error((String)this.getClass().toString(), (String)msg);
            }
            plugin.setId(name);
            PluginMessageLogger.add(Messages.getInstance().getString("SystemPathXmlPluginProvider.DISCOVERED_PLUGIN", new Object[]{name, folder}));
            IPlatformPlugin.ClassLoaderType loaderType = IPlatformPlugin.ClassLoaderType.DEFAULT;
            String loader = node.attributeValue("loader");
            if (!StringUtils.isEmpty((String)loader)) {
                loaderType = IPlatformPlugin.ClassLoaderType.valueOf((String)loader.toUpperCase());
            }
            plugin.setLoadertype(loaderType);
        }
    }

    protected void processOverlays(PlatformPlugin plugin, Document doc, IPentahoSession session) {
        List nodes = doc.selectNodes("//overlays/overlay");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            DefaultXulOverlay overlay = SystemPathXmlPluginProvider.processOverlay(node);
            if (overlay == null) continue;
            plugin.addOverlay((XulOverlay)overlay);
        }
    }

    public static DefaultXulOverlay processOverlay(Element node) {
        DefaultXulOverlay overlay = null;
        String id = node.attributeValue("id");
        String resourceBundleUri = node.attributeValue("resourcebundle");
        String priority = node.attributeValue("priority");
        String xml = node.asXML();
        if (StringUtils.isNotEmpty((String)id) && StringUtils.isNotEmpty((String)xml)) {
            if (StringUtils.isNotEmpty((String)priority)) {
                try {
                    overlay = new DefaultXulOverlay(id, null, xml, resourceBundleUri, Integer.parseInt(priority));
                }
                catch (NumberFormatException e) {
                    overlay = new DefaultXulOverlay(id, null, xml, resourceBundleUri);
                }
            } else {
                overlay = new DefaultXulOverlay(id, null, xml, resourceBundleUri);
            }
        }
        return overlay;
    }

    protected void processContentTypes(PlatformPlugin plugin, Document doc, IPentahoSession session) {
        List nodes = doc.selectNodes("//content-type");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            String title = XmlDom4JHelper.getNodeText((String)"title", (Node)node);
            String extension = node.attributeValue("type");
            if (title != null && extension != null) {
                String description = XmlDom4JHelper.getNodeText((String)"description", (Node)node, (String)"");
                String mimeType = node.attributeValue("mime-type", "");
                String iconUrl = XmlDom4JHelper.getNodeText((String)"icon-url", (Node)node, (String)"");
                String metaProviderClass = XmlDom4JHelper.getNodeText((String)"meta-provider", (Node)node, (String)"");
                ContentInfo contentInfo = new ContentInfo();
                contentInfo.setDescription(description);
                contentInfo.setTitle(title);
                contentInfo.setExtension(extension);
                contentInfo.setMimeType(mimeType);
                contentInfo.setIconUrl(iconUrl);
                List operationNodes = node.selectNodes("operations/operation");
                for (Object operationObj : operationNodes) {
                    Element operationNode = (Element)operationObj;
                    String id = XmlDom4JHelper.getNodeText((String)"id", (Node)operationNode, (String)"");
                    String perspective = XmlDom4JHelper.getNodeText((String)"perspective", (Node)operationNode, (String)"");
                    if (!StringUtils.isNotEmpty((String)id)) continue;
                    PluginOperation operation = new PluginOperation(id);
                    if (StringUtils.isNotEmpty((String)perspective)) {
                        operation.setPerspective(perspective);
                    }
                    contentInfo.addOperation((IPluginOperation)operation);
                }
                plugin.addContentInfo((IContentInfo)contentInfo);
                if (!StringUtils.isEmpty((String)metaProviderClass)) {
                    plugin.getMetaProviderMap().put(contentInfo.getExtension(), metaProviderClass);
                }
                PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_TYPE_REGISTERED", new Object[]{extension, title}));
                continue;
            }
            PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_TYPE_NOT_REGISTERED", new Object[]{extension, title}));
        }
    }

    private static String getProperty(Element node, String propName) {
        String propValue = null;
        propValue = node.attributeValue(propName);
        if (propValue == null) {
            propValue = XmlDom4JHelper.getNodeText((String)propName, (Node)node, null);
        }
        return propValue;
    }

    protected void processContentGenerators(PlatformPlugin plugin, Document doc, IPentahoSession session, String folder, boolean hasLib) {
        List nodes = doc.selectNodes("//content-generator");
        for (Object obj : nodes) {
            Element node = (Element)obj;
            String className = SystemPathXmlPluginProvider.getProperty(node, "class");
            if (className == null) {
                className = XmlDom4JHelper.getNodeText((String)"classname", (Node)node, null);
            }
            String fileInfoClassName = XmlDom4JHelper.getNodeText((String)"fileinfo-classname", (Node)node, null);
            String id = node.attributeValue("id");
            String type = node.attributeValue("type");
            String url = node.attributeValue("url");
            String title = SystemPathXmlPluginProvider.getProperty(node, "title");
            String description = SystemPathXmlPluginProvider.getProperty(node, "description");
            try {
                if (id != null && type != null && className != null && title != null) {
                    try {
                        IContentGeneratorInfo info = SystemPathXmlPluginProvider.createContentGenerator(plugin, id, title, description, type, url, className, session, folder);
                        plugin.addContentGenerator(info);
                    }
                    catch (Exception e) {
                        PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_GENERATOR_NOT_REGISTERED", new Object[]{id, folder}));
                    }
                    if (StringUtils.isEmpty((String)fileInfoClassName)) continue;
                    plugin.getMetaProviderMap().put(type, fileInfoClassName);
                    continue;
                }
                PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_GENERATOR_NOT_REGISTERED", new Object[]{id, folder}));
            }
            catch (Exception e) {
                PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_GENERATOR_NOT_REGISTERED", new Object[]{id, folder}));
                Logger.error((String)this.getClass().toString(), (String)Messages.getInstance().getErrorString("PluginManager.ERROR_0006_CANNOT_CREATE_CONTENT_GENERATOR_FACTORY", new Object[]{folder}), (Throwable)e);
            }
        }
    }

    private static IContentGeneratorInfo createContentGenerator(PlatformPlugin plugin, String id, String title, String description, String type, String url, String className, IPentahoSession session, String location) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ContentGeneratorInfo info = new ContentGeneratorInfo();
        info.setId(id);
        info.setTitle(title);
        info.setDescription(description);
        info.setUrl(url != null ? url : "");
        info.setType(type);
        info.setClassname(className);
        return info;
    }
}

