/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hive;

import org.pentaho.big.data.api.jdbc.DriverLocator;
import org.pentaho.big.data.kettle.plugins.hive.DatabaseMetaWithVersion;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;

@DatabaseMetaPlugin(type="HIVE2", typeDescription="Hadoop Hive 2")
public class Hive2DatabaseMeta
extends DatabaseMetaWithVersion {
    public static final String URL_PREFIX = "jdbc:hive2://";
    public static final String SELECT_COUNT_1_FROM = "select count(1) from ";
    public static final String ALIAS_SUFFIX = "_col";
    public static final String VIEW = "VIEW";
    public static final String VIRTUAL_VIEW = "VIRTUAL_VIEW";
    public static final String TRUNCATE_TABLE = "TRUNCATE TABLE ";
    public static final int[] ACCESS_TYPE_LIST = new int[]{0};
    protected static final String JAR_FILE = "hive-jdbc-0.10.0-pentaho.jar";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.HiveDriver";

    public Hive2DatabaseMeta(DriverLocator driverLocator) {
        super(driverLocator);
    }

    public int[] getAccessTypeList() {
        return ACCESS_TYPE_LIST;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDriverClass() {
        return DRIVER_CLASS_NAME;
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval = retval + "BOOLEAN";
                break;
            }
            case 3: {
                if (this.isDriverVersion(0, 12)) {
                    retval = retval + "DATE";
                    break;
                }
                throw new IllegalArgumentException("Date types not supported in this version of Hive");
            }
            case 9: {
                if (this.isDriverVersion(0, 8)) {
                    retval = retval + "TIMESTAMP";
                    break;
                }
                throw new IllegalArgumentException("Timestamp types not supported in this version of Hive");
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "FLOAT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                retval = length > 15 ? retval + "FLOAT" : retval + "DOUBLE";
            }
        }
        return retval;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        return URL_PREFIX + hostname + ":" + port + "/" + databaseName;
    }

    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    public String getSelectCountStatement(String tableName) {
        return SELECT_COUNT_1_FROM + tableName;
    }

    public String generateColumnAlias(int columnIndex, String suggestedName) {
        if (this.isDriverVersion(0, 6)) {
            return suggestedName;
        }
        return ALIAS_SUFFIX + String.valueOf(columnIndex);
    }

    public String getStartQuote() {
        return "";
    }

    public String getEndQuote() {
        return "";
    }

    public String[] getTableTypes() {
        return null;
    }

    public String[] getViewTypes() {
        return new String[]{VIEW, VIRTUAL_VIEW};
    }

    public String getTruncateTableStatement(String tableName) {
        if (this.isDriverVersion(0, 11)) {
            return TRUNCATE_TABLE + tableName;
        }
        return null;
    }

    public boolean supportsSetCharacterStream() {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public boolean supportsTimeStampToDateConversion() {
        return false;
    }
}

