/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class SecureWALCellCodec
extends WALCellCodec {
    private Encryptor encryptor;
    private Decryptor decryptor;

    public SecureWALCellCodec(Configuration conf, CompressionContext compression) {
        super(conf, compression);
    }

    public SecureWALCellCodec(Configuration conf, Encryptor encryptor) {
        super(conf, null);
        this.encryptor = encryptor;
    }

    public SecureWALCellCodec(Configuration conf, Decryptor decryptor) {
        super(conf, null);
        this.decryptor = decryptor;
    }

    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new EncryptedKvDecoder(is, this.decryptor);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new EncryptedKvEncoder(os, this.encryptor);
    }

    public static WALCellCodec getCodec(Configuration conf, Encryptor encryptor) {
        return new SecureWALCellCodec(conf, encryptor);
    }

    public static WALCellCodec getCodec(Configuration conf, Decryptor decryptor) {
        return new SecureWALCellCodec(conf, decryptor);
    }

    static class EncryptedKvEncoder
    extends KeyValueCodec.KeyValueEncoder {
        private Encryptor encryptor;
        private final ThreadLocal<byte[]> iv = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                byte[] iv = new byte[EncryptedKvEncoder.this.encryptor.getIvLength()];
                new SecureRandom().nextBytes(iv);
                return iv;
            }
        };

        protected byte[] nextIv() {
            byte[] b = this.iv.get();
            byte[] ret = new byte[b.length];
            System.arraycopy(b, 0, ret, 0, b.length);
            return ret;
        }

        protected void incrementIv(int v) {
            Encryption.incrementIv((byte[])this.iv.get(), (int)(1 + v / this.encryptor.getBlockSize()));
        }

        public EncryptedKvEncoder(OutputStream os) {
            super(os);
        }

        public EncryptedKvEncoder(OutputStream os, Encryptor encryptor) {
            super(os);
            this.encryptor = encryptor;
        }

        public void write(Cell cell) throws IOException {
            if (this.encryptor == null) {
                super.write(cell);
                return;
            }
            byte[] iv = this.nextIv();
            this.encryptor.setIv(iv);
            this.encryptor.reset();
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)iv.length);
            this.out.write(iv);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream cout = this.encryptor.createEncryptionStream((OutputStream)baos);
            int tlen = cell.getTagsLength();
            StreamUtils.writeRawVInt32((OutputStream)cout, (int)KeyValueUtil.keyLength((Cell)cell));
            StreamUtils.writeRawVInt32((OutputStream)cout, (int)cell.getValueLength());
            StreamUtils.writeRawVInt32((OutputStream)cout, (int)tlen);
            StreamUtils.writeRawVInt32((OutputStream)cout, (int)cell.getRowLength());
            cout.write(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
            StreamUtils.writeRawVInt32((OutputStream)cout, (int)cell.getFamilyLength());
            cout.write(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
            StreamUtils.writeRawVInt32((OutputStream)cout, (int)cell.getQualifierLength());
            cout.write(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            StreamUtils.writeLong((OutputStream)cout, (long)cell.getTimestamp());
            cout.write(cell.getTypeByte());
            cout.write(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            if (tlen > 0) {
                cout.write(cell.getTagsArray(), cell.getTagsOffset(), tlen);
            }
            cout.close();
            StreamUtils.writeRawVInt32((OutputStream)this.out, (int)baos.size());
            baos.writeTo(this.out);
            this.incrementIv(baos.size());
        }
    }

    static class EncryptedKvDecoder
    extends KeyValueCodec.KeyValueDecoder {
        private Decryptor decryptor;
        private byte[] iv;

        public EncryptedKvDecoder(InputStream in) {
            super(in);
        }

        public EncryptedKvDecoder(InputStream in, Decryptor decryptor) {
            super(in);
            this.decryptor = decryptor;
            if (decryptor != null) {
                this.iv = new byte[decryptor.getIvLength()];
            }
        }

        protected Cell parseCell() throws IOException {
            if (this.decryptor == null) {
                return super.parseCell();
            }
            int ivLength = 0;
            ivLength = StreamUtils.readRawVarint32((InputStream)this.in);
            if (ivLength != this.iv.length) {
                throw new IOException("Incorrect IV length: expected=" + this.iv.length + " have=" + ivLength);
            }
            IOUtils.readFully((InputStream)this.in, (byte[])this.iv);
            int codedLength = StreamUtils.readRawVarint32((InputStream)this.in);
            byte[] codedBytes = new byte[codedLength];
            IOUtils.readFully((InputStream)this.in, (byte[])codedBytes);
            this.decryptor.setIv(this.iv);
            this.decryptor.reset();
            InputStream cin = this.decryptor.createDecryptionStream((InputStream)new ByteArrayInputStream(codedBytes));
            int keylength = StreamUtils.readRawVarint32((InputStream)cin);
            int vlength = StreamUtils.readRawVarint32((InputStream)cin);
            int tagsLength = StreamUtils.readRawVarint32((InputStream)cin);
            int length = 0;
            length = tagsLength == 0 ? 8 + keylength + vlength : 10 + keylength + vlength + tagsLength;
            byte[] backingArray = new byte[length];
            int pos = 0;
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)keylength);
            pos = Bytes.putInt((byte[])backingArray, (int)pos, (int)vlength);
            int elemLen = StreamUtils.readRawVarint32((InputStream)cin);
            pos = Bytes.putShort((byte[])backingArray, (int)pos, (short)((short)elemLen));
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)pos, (int)elemLen);
            pos += elemLen;
            elemLen = StreamUtils.readRawVarint32((InputStream)cin);
            pos = Bytes.putByte((byte[])backingArray, (int)pos, (byte)((byte)elemLen));
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)pos, (int)elemLen);
            pos += elemLen;
            elemLen = StreamUtils.readRawVarint32((InputStream)cin);
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)pos, (int)elemLen);
            IOUtils.readFully((InputStream)cin, (byte[])backingArray, (int)(pos += elemLen), (int)(length - pos));
            return new KeyValue(backingArray, 0, length);
        }
    }
}

