/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class BlockCacheTmplImpl
extends AbstractTemplateImpl
implements BlockCacheTmpl.Intf {
    private final CacheConfig cacheConfig;
    private final Configuration config;

    protected static BlockCacheTmpl.ImplData __jamon_setOptionalArguments(BlockCacheTmpl.ImplData p_implData) {
        return p_implData;
    }

    public BlockCacheTmplImpl(TemplateManager p_templateManager, BlockCacheTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)BlockCacheTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.cacheConfig = p_implData.getCacheConfig();
        this.config = p_implData.getConfig();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        BlockCache bc = this.cacheConfig == null ? null : this.cacheConfig.getBlockCache();
        String bcUrl = null;
        String bcName = null;
        if (bc != null) {
            bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
            bcName = bc.getClass().getSimpleName();
        }
        BlockCache[] bcs = this.cacheConfig == null ? null : (this.cacheConfig.getBlockCache() == null ? null : this.cacheConfig.getBlockCache().getBlockCaches());
        boolean evictions = bcs != null && bcs.length > 1;
        jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_bc_baseInfo\" data-toggle=\"tab\">Base Info</a></li>\n        <li class=\"\"><a href=\"#tab_bc_config\" data-toggle=\"tab\">Config</a></li>\n        <li class=\"\"><a href=\"#tab_bc_stats\" data-toggle=\"tab\">Stats</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l1\" data-toggle=\"tab\">L1</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l2\" data-toggle=\"tab\">L2</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_bc_baseInfo\">\n            ");
        this.__jamon_innerUnit__bc_baseInfo(jamonWriter, this.cacheConfig, bcUrl, bcName);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_config\">\n            ");
        this.__jamon_innerUnit__bc_config(jamonWriter, this.cacheConfig);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_stats\">\n            ");
        this.__jamon_innerUnit__bc_stats(jamonWriter, this.cacheConfig);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l1\">\n            ");
        this.__jamon_innerUnit__bc_l(jamonWriter, bcs == null ? bc : bcs[0], "L1", evictions);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l2\">\n            ");
        this.__jamon_innerUnit__bc_l(jamonWriter, bcs == null ? null : (bcs.length <= 1 ? null : bcs[1]), "L2", evictions);
        jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }

    private void __jamon_innerUnit__bc_stats(Writer jamonWriter, CacheConfig cacheConfig) throws IOException {
        if (cacheConfig == null || cacheConfig.getBlockCache() == null) {
            jamonWriter.write("\n<p>CacheConfig is null</p>\n");
        } else {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Size</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cacheConfig.getBlockCache().getCurrentSize())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Current size of block cache in use (bytes)</td>\n    </tr>\n    <tr>\n        <td>Free</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cacheConfig.getBlockCache().getFreeSize())), jamonWriter);
            jamonWriter.write("</td>\n        <td>The total free memory currently available to store more cache entries (bytes)</td>\n    </tr>\n    <tr>\n        <td>Count</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getBlockCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Number of blocks in block cache</td>\n    </tr>\n    ");
            this.__jamon_innerUnit__evictions_tmpl(jamonWriter, cacheConfig.getBlockCache());
            jamonWriter.write("\n    ");
            this.__jamon_innerUnit__hits_tmpl(jamonWriter, cacheConfig.getBlockCache());
            jamonWriter.write("\n</table>\n<p>If block cache is made up of more than one cache -- i.e. a L1 and a L2 -- then the above\nare combined counts. Request count is sum of hits and misses.</p>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__hits_tmpl(Writer jamonWriter, BlockCache bc) throws IOException {
        jamonWriter.write("<tr>\n        <td>Hits</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getHitCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Number requests that were cache hits</td>\n    </tr>\n    <tr>\n        <td>Hits Caching</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getHitCachingCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Cache hit block requests but only requests set to cache block if a miss</td>\n    </tr>\n    <tr>\n        <td>Misses</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getMissCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Block requests that were cache misses but set to cache missed blocks</td>\n    </tr>\n    <tr>\n        <td>Misses Caching</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getMissCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Block requests that were cache misses but only requests set to use block cache</td>\n    </tr>\n    <tr>\n        <td>Hit Ratio</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,.2f", bc.getStats().getHitRatio() * 100.0)), jamonWriter);
        Escaping.HTML.write(StandardEmitter.valueOf((String)"%"), jamonWriter);
        jamonWriter.write("</td>\n        <td>Hit Count divided by total requests count</td>\n    </tr>\n\n");
    }

    private void __jamon_innerUnit__bc_config(Writer jamonWriter, CacheConfig cacheConfig) throws IOException {
        if (cacheConfig == null) {
            jamonWriter.write("\n<p>CacheConfig is null</p>\n");
        } else {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Cache DATA on Read</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheDataOnRead()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on read\n        (INDEX & BLOOM blocks are always cached)</td>\n    </tr>\n    <tr>\n        <td>Cache DATA on Write</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheDataOnWrite()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on write.</td>\n    </tr>\n    <tr>\n        <td>Cache INDEX on Write</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheIndexesOnWrite()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if INDEX blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Cache BLOOM on Write</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheBloomsOnWrite()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if BLOOM blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Evict blocks on Close</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldEvictOnClose()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if blocks are evicted from cache when an HFile\n        reader is closed</td>\n    </tr>\n    <tr>\n        <td>Cache DATA in compressed format</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheDataCompressed()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if DATA blocks are cached in their compressed form</td>\n    </tr>\n    <tr>\n        <td>Prefetch on Open</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldPrefetchOnOpen()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if blocks are prefetched into cache on open</td>\n    </tr>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__bc_baseInfo(Writer jamonWriter, CacheConfig cacheConfig, String bcUrl, String bcName) throws IOException {
        BlockCache bc = cacheConfig == null ? null : cacheConfig.getBlockCache();
        BlockCache[] bcs = bc == null ? null : bc.getBlockCaches();
        String bcl1Url = null;
        String bcl1Name = null;
        String bcl2Url = null;
        String bcl2Name = null;
        if (bcs != null) {
            BlockCache bcl1 = bcs[0];
            if (bcl1 != null) {
                bcl1Url = "http://hbase.apache.org/devapidocs/" + bcl1.getClass().getName().replaceAll("\\.", "/") + ".html";
                bcl1Name = bcl1.getClass().getSimpleName();
            }
            if (bcs.length == 2) {
                BlockCache bcl2 = bcs[1];
                bcl2Url = "http://hbase.apache.org/devapidocs/" + bcl2.getClass().getName().replaceAll("\\.", "/") + ".html";
                bcl2Name = bcl2.getClass().getSimpleName();
            }
        }
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bcUrl), jamonWriter);
        jamonWriter.write("\">");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bcName), jamonWriter);
        jamonWriter.write("</a></td>\n        <td>Block cache implementing class</td>\n    </tr>\n</table>\n<p>See <a href=\"http://hbase.apache.org/book.html#block.cache\">block cache</a> in the HBase Reference Guide for help.</p>\n");
    }

    private void __jamon_innerUnit__block_cache(Writer jamonWriter, BlockCache bc, String name, boolean evictions) throws IOException {
        long nanosPerSecond = 1000000000L;
        String bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
        String bcName = bc.getClass().getSimpleName();
        BlockCacheUtil.CachedBlocksByFile cbsbf = BlockCacheUtil.getLoadedCachedBlocksByFile(this.config, bc);
        AgeSnapshot cbsbfSnapshot = cbsbf.getAgeInCacheSnapshot();
        boolean bucketCache = bc.getClass().getSimpleName().equals("BucketCache");
        BucketCacheStats bucketCacheStats = null;
        BucketAllocator bucketAllocator = null;
        BucketAllocator.Bucket[] buckets = null;
        if (bucketCache) {
            bucketCacheStats = (BucketCacheStats)bc.getStats();
            bucketAllocator = ((BucketCache)bc).getAllocator();
            buckets = bucketAllocator.getBuckets();
        }
        if (cbsbf.isFull()) {
            jamonWriter.write("\n<p><b>Statistics below is based on sampling first ");
            Escaping.HTML.write(StandardEmitter.valueOf((double)cbsbfSnapshot.getMax()), jamonWriter);
            jamonWriter.write(" blocks only</b> (hbase.ui.blockcache.by.file.max)</p> \n");
        }
        jamonWriter.write("\n<table id=\"blocks_summary\" class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bcUrl), jamonWriter);
        jamonWriter.write("\">");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bc.getClass().getSimpleName()), jamonWriter);
        jamonWriter.write("</a></td>\n        <td>Class implementing this block cache Level</td>\n    </tr>\n");
        if (bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Implementation</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)((BucketCache)bc).getIoEngine()), jamonWriter);
            jamonWriter.write("</a></td>\n        <td>IOEngine</td>\n    </tr>\n");
        }
        jamonWriter.write("\n    <tr>\n        <td>Count</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cbsbf.getCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Count of Blocks</td>\n    </tr>\n");
        if (!bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Count</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cbsbf.getDataCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Count of DATA Blocks</td>\n    </tr>\n");
        }
        jamonWriter.write("\n    <tr>\n        <td>Size</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cbsbf.getSize())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Size of Blocks</td>\n    </tr>\n");
        if (!bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Size</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cbsbf.getDataSize())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Size of DATA Blocks</td>\n    </tr>\n");
        }
        jamonWriter.write(" \n");
        this.__jamon_innerUnit__evictions_tmpl(jamonWriter, bc);
        jamonWriter.write("\n");
        this.__jamon_innerUnit__hits_tmpl(jamonWriter, bc);
        jamonWriter.write("\n\n");
        if (bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Hits per Second</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)bucketCacheStats.getIOHitsPerSecond()), jamonWriter);
            jamonWriter.write("</td>\n        <td>Block gets against this cache per second</td>\n    </tr>\n    <tr>\n        <td>Time per Hit</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((double)bucketCacheStats.getIOTimePerHit()), jamonWriter);
            jamonWriter.write("</td>\n        <td>Time per cache hit</td>\n    </tr>\n");
        }
        jamonWriter.write("\n</table>\n<p>View block cache <a href=\"?format=json&bcn=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)name), jamonWriter);
        jamonWriter.write("\">as JSON</a> | Block cache <a href=\"?format=json&bcn=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)name), jamonWriter);
        jamonWriter.write("&bcv=file\">as JSON by file</a></p>\n");
        if (bucketCache) {
            jamonWriter.write("\n<p>BucketCache does not discern between DATA and META blocks so we do not show DATA counts (If deploy is using CombinedBlockCache, BucketCache is only DATA blocks</p>\n<h3>BucketCache Buckets</h3>\n<table class=\"table table-striped\">\n    <tr>\n        <th>Bucket Offset</th>\n        <th>Allocation Size</th>\n        <th>Free Bytes</th>\n        <th>Used Bytes</th>\n    </tr>\n");
            for (BucketAllocator.Bucket bucket : buckets) {
                jamonWriter.write("\n    <tr>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)bucket.getBaseOffset()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)bucket.getItemAllocationSize()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)bucket.getFreeBytes()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)bucket.getUsedBytes()), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n");
            }
            jamonWriter.write("\n</table>\n");
        }
        jamonWriter.write("\n");
        cbsbf = null;
    }

    private void __jamon_innerUnit__bc_l(Writer jamonWriter, BlockCache bc, String name, boolean evictions) throws IOException {
        if (bc == null) {
            jamonWriter.write("\n<p>No ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)name), jamonWriter);
            jamonWriter.write(" deployed</p>\n");
        } else {
            jamonWriter.write("\n");
            this.__jamon_innerUnit__block_cache(jamonWriter, bc, name, evictions);
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__evictions_tmpl(Writer jamonWriter, BlockCache bc) throws IOException {
        AgeSnapshot ageAtEvictionSnapshot = bc.getStats().getAgeAtEvictionSnapshot();
        double mean = ageAtEvictionSnapshot.getMean();
        double stddev = ageAtEvictionSnapshot.getStdDev();
        jamonWriter.write("<tr>\n        <td>Evicted</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getEvictedCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>The total number of blocks evicted</td>\n    </tr>\n    <tr>\n        <td>Evictions</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getEvictionCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>The total number of times an eviction has occurred</td>\n    </tr>\n");
        if (mean > 0.0) {
            jamonWriter.write("\n    <tr>\n        <td>Mean</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(ageAtEvictionSnapshot.getMean() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>Mean age of Blocks at eviction time (seconds)</td>\n    </tr>\n");
        }
        jamonWriter.write("\n");
        if (stddev > 0.0) {
            jamonWriter.write("\n    <tr>\n        <td>StdDev</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(ageAtEvictionSnapshot.getStdDev() / 1000000.0))), jamonWriter);
            jamonWriter.write("</td>\n        <td>Standard Deviation for age of Blocks at eviction time</td>\n    </tr>\n");
        }
        jamonWriter.write("\n");
    }
}

