/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.model.factories;

import java.util.Hashtable;
import java.util.Map;
import org.pentaho.marketplace.domain.model.entities.Category;
import org.pentaho.marketplace.domain.model.entities.interfaces.ICategory;
import org.pentaho.marketplace.domain.model.factories.interfaces.ICategoryFactory;

public class CategoryFactory
implements ICategoryFactory {
    private static Map<String, ICategory> categories = new Hashtable<String, ICategory>();

    @Override
    public ICategory get(String name) {
        return categories.get(name);
    }

    @Override
    public ICategory create(String name, ICategory parent) {
        ICategory category;
        ICategory iCategory = category = parent != null ? parent.getChildren().get(name) : this.get(name);
        if (category != null) {
            return category;
        }
        category = new Category(name, parent);
        if (parent == null) {
            categories.put(name, category);
        } else {
            parent.getChildren().put(name, category);
        }
        return category;
    }

    @Override
    public ICategory create(String name) {
        return this.create(name, null);
    }
}

