/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public abstract class ActionExecutor {
    public static final String CONF_PREFIX = "oozie.action.";
    public static final String MAX_RETRIES = "oozie.action.retries.max";
    public static final String ERROR_OTHER = "OTHER";
    public boolean requiresNNJT = false;
    private static boolean initMode = false;
    private static Map<String, Map<String, ErrorInfo>> ERROR_INFOS = new HashMap<String, Map<String, ErrorInfo>>();
    public static final long RETRY_INTERVAL = 60L;
    private String type;
    private int maxRetries;
    private long retryInterval;

    protected ActionExecutor(String type) {
        this(type, 60L);
    }

    protected ActionExecutor(String type, long retryInterval) {
        this.type = ParamChecker.notEmpty(type, "type");
        this.maxRetries = this.getOozieConf().getInt(MAX_RETRIES, 3);
        this.retryInterval = retryInterval;
    }

    public static void resetInitInfo() {
        if (!initMode) {
            throw new IllegalStateException("Error, action type info locked");
        }
        ERROR_INFOS.clear();
    }

    public static void enableInit() {
        initMode = true;
    }

    public static void disableInit() {
        initMode = false;
    }

    public void initActionType() {
        XLog.getLog(this.getClass()).trace(" Init Action Type : [{0}]", this.getType());
        ERROR_INFOS.put(this.getType(), new LinkedHashMap());
    }

    public String getOozieSystemId() {
        return Services.get().getSystemId();
    }

    public String getOozieRuntimeDir() {
        return Services.get().getRuntimeDir();
    }

    public Configuration getOozieConf() {
        return Services.get().getConf();
    }

    protected void registerError(String exClass, ActionExecutorException.ErrorType errorType, String errorCode) {
        if (!initMode) {
            throw new IllegalStateException("Error, action type info locked");
        }
        try {
            Class<?> errorClass = Thread.currentThread().getContextClassLoader().loadClass(exClass);
            Map<String, ErrorInfo> executorErrorInfo = ERROR_INFOS.get(this.getType());
            executorErrorInfo.put(exClass, new ErrorInfo(errorType, errorCode, errorClass));
        }
        catch (ClassNotFoundException cnfe) {
            XLog.getLog(this.getClass()).warn("Exception [{0}] not in classpath, ActionExecutor [{1}] will handle it as ERROR", exClass, this.getType());
        }
        catch (NoClassDefFoundError err) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(baos));
            XLog.getLog(this.getClass()).warn(baos.toString());
        }
    }

    public String getType() {
        return this.type;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    protected ActionExecutorException convertException(Exception ex) {
        if (ex instanceof ActionExecutorException) {
            return (ActionExecutorException)ex;
        }
        ActionExecutorException aee = null;
        if (ex.getCause() != null) {
            aee = this.convertExceptionHelper(ex.getCause());
        }
        if (aee == null && (aee = this.convertExceptionHelper(ex)) == null) {
            String exClass = ex.getClass().getName();
            String errorCode = exClass.substring(exClass.lastIndexOf(".") + 1);
            aee = new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, errorCode, "{0}", ex.getMessage(), ex);
        }
        return aee;
    }

    private ActionExecutorException convertExceptionHelper(Throwable ex) {
        Map<String, ErrorInfo> executorErrorInfo = ERROR_INFOS.get(this.getType());
        ErrorInfo classErrorInfo = executorErrorInfo.get(ex.getClass().getName());
        if (classErrorInfo != null) {
            return new ActionExecutorException(classErrorInfo.errorType, classErrorInfo.errorCode, "{0}", ex.getMessage(), ex);
        }
        for (ErrorInfo errorInfo : executorErrorInfo.values()) {
            if (!errorInfo.errorClass.isInstance(ex)) continue;
            return new ActionExecutorException(errorInfo.errorType, errorInfo.errorCode, "{0}", ex.getMessage(), ex);
        }
        return null;
    }

    protected String getActionSignal(WorkflowAction.Status status) {
        switch (status) {
            case OK: {
                return "OK";
            }
            case ERROR: 
            case KILLED: {
                return "ERROR";
            }
        }
        throw new IllegalArgumentException("Action status for signal can only be OK or ERROR");
    }

    protected String getActionDirPath(String jobId, WorkflowAction action, String key, boolean temp) {
        String name = jobId + "/" + action.getName() + "--" + key;
        if (temp) {
            name = name + ".temp";
        }
        return this.getOozieSystemId() + "/" + name;
    }

    public Path getActionDir(String jobId, WorkflowAction action, String key, boolean temp) {
        return new Path(this.getActionDirPath(jobId, action, key, temp));
    }

    public abstract void start(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract void end(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract void check(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract void kill(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract boolean isCompleted(String var1);

    public static interface Context {
        public String getCallbackUrl(String var1);

        public Configuration getProtoActionConf();

        public WorkflowJob getWorkflow();

        public ELEvaluator getELEvaluator();

        public void setVar(String var1, String var2);

        public String getVar(String var1);

        public void setStartData(String var1, String var2, String var3);

        public void setExecutionData(String var1, Properties var2);

        public void setExecutionStats(String var1);

        public void setExternalChildIDs(String var1);

        public void setEndData(WorkflowAction.Status var1, String var2);

        public boolean isRetry();

        public void setExternalStatus(String var1);

        public String getRecoveryId();

        public Path getActionDir() throws HadoopAccessorException, IOException, URISyntaxException;

        public FileSystem getAppFileSystem() throws HadoopAccessorException, IOException, URISyntaxException;

        public void setErrorInfo(String var1, String var2);
    }

    private static class ErrorInfo {
        ActionExecutorException.ErrorType errorType;
        String errorCode;
        Class<?> errorClass;

        private ErrorInfo(ActionExecutorException.ErrorType errorType, String errorCode, Class<?> errorClass) {
            this.errorType = errorType;
            this.errorCode = errorCode;
            this.errorClass = errorClass;
        }
    }
}

