/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.StringBlob;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;

public class BundleJobQueryExecutor
extends QueryExecutor<BundleJobBean, BundleJobQuery> {
    private static BundleJobQueryExecutor instance = new BundleJobQueryExecutor();

    private BundleJobQueryExecutor() {
    }

    public static QueryExecutor<BundleJobBean, BundleJobQuery> getInstance() {
        return instance;
    }

    @Override
    public Query getUpdateQuery(BundleJobQuery namedQuery, BundleJobBean bjBean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_BUNDLE_JOB: {
                query.setParameter("appName", (Object)bjBean.getAppName());
                query.setParameter("appPath", (Object)bjBean.getAppPath());
                query.setParameter("conf", (Object)bjBean.getConfBlob());
                query.setParameter("timeOut", (Object)bjBean.getTimeout());
                query.setParameter("createdTime", (Object)bjBean.getCreatedTimestamp());
                query.setParameter("endTime", (Object)bjBean.getEndTimestamp());
                query.setParameter("jobXml", (Object)bjBean.getJobXmlBlob());
                query.setParameter("lastModifiedTime", (Object)bjBean.getLastModifiedTimestamp());
                query.setParameter("origJobXml", (Object)bjBean.getOrigJobXmlBlob());
                query.setParameter("startTime", (Object)bjBean.getstartTimestamp());
                query.setParameter("status", (Object)bjBean.getStatus().toString());
                query.setParameter("timeUnit", (Object)bjBean.getTimeUnit());
                query.setParameter("pending", (Object)(bjBean.isPending() ? 1 : 0));
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            case UPDATE_BUNDLE_JOB_STATUS: {
                query.setParameter("status", (Object)bjBean.getStatus().toString());
                query.setParameter("lastModifiedTime", (Object)bjBean.getLastModifiedTimestamp());
                query.setParameter("pending", (Object)bjBean.getPending());
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            case UPDATE_BUNDLE_JOB_STATUS_PENDING: {
                query.setParameter("status", (Object)bjBean.getStatus().toString());
                query.setParameter("pending", (Object)bjBean.getPending());
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            case UPDATE_BUNDLE_JOB_STATUS_PENDING_SUSP_MOD_TIME: {
                query.setParameter("status", (Object)bjBean.getStatus().toString());
                query.setParameter("lastModifiedTime", (Object)bjBean.getLastModifiedTimestamp());
                query.setParameter("pending", (Object)bjBean.getPending());
                query.setParameter("suspendedTime", (Object)bjBean.getSuspendedTimestamp());
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            case UPDATE_BUNDLE_JOB_STATUS_PENDING_MODTIME: {
                query.setParameter("status", (Object)bjBean.getStatus().toString());
                query.setParameter("lastModifiedTime", (Object)bjBean.getLastModifiedTimestamp());
                query.setParameter("pending", (Object)bjBean.getPending());
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            case UPDATE_BUNDLE_JOB_STATUS_PAUSE_ENDTIME: {
                query.setParameter("status", (Object)bjBean.getStatus().toString());
                query.setParameter("pauseTime", (Object)bjBean.getPauseTimestamp());
                query.setParameter("endTime", (Object)bjBean.getEndTimestamp());
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            case UPDATE_BUNDLE_JOB_PAUSE_KICKOFF: {
                query.setParameter("pauseTime", (Object)bjBean.getPauseTimestamp());
                query.setParameter("kickoffTime", (Object)bjBean.getKickoffTimestamp());
                query.setParameter("id", (Object)bjBean.getId());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(BundleJobQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case GET_BUNDLE_JOB: 
            case GET_BUNDLE_JOB_ID_STATUS_PENDING_MODTIME: 
            case GET_BUNDLE_JOB_ID_JOBXML_CONF: 
            case GET_BUNDLE_JOB_STATUS: {
                query.setParameter("id", parameters[0]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(BundleJobQuery namedQuery, BundleJobBean jobBean) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public BundleJobBean get(BundleJobQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null) {
            throw new JPAExecutorException(ErrorCode.E0604, query.toString());
        }
        BundleJobBean bean = this.constructBean(namedQuery, ret, parameters);
        return bean;
    }

    @Override
    public List<BundleJobBean> getList(BundleJobQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<?> retList = jpaService.executeGetList(namedQuery.name(), query, em);
        ArrayList<BundleJobBean> beanList = new ArrayList<BundleJobBean>();
        if (retList != null) {
            for (Object ret : retList) {
                beanList.add(this.constructBean(namedQuery, ret, new Object[0]));
            }
        }
        return beanList;
    }

    private BundleJobBean constructBean(BundleJobQuery namedQuery, Object ret, Object ... parameters) throws JPAExecutorException {
        BundleJobBean bean;
        switch (namedQuery) {
            case GET_BUNDLE_JOB: {
                bean = (BundleJobBean)ret;
                break;
            }
            case GET_BUNDLE_JOB_STATUS: {
                bean = new BundleJobBean();
                bean.setId((String)parameters[0]);
                bean.setStatus((String)ret);
                break;
            }
            case GET_BUNDLE_JOB_ID_STATUS_PENDING_MODTIME: {
                bean = new BundleJobBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setStatus((String)arr[1]);
                bean.setPending((Integer)arr[2]);
                bean.setLastModifiedTime(DateUtils.toDate((Timestamp)arr[3]));
                break;
            }
            case GET_BUNDLE_JOB_ID_JOBXML_CONF: {
                bean = new BundleJobBean();
                Object[] arr = (Object[])ret;
                bean.setId((String)arr[0]);
                bean.setJobXmlBlob((StringBlob)arr[1]);
                bean.setConfBlob((StringBlob)arr[2]);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot construct job bean for " + namedQuery.name());
            }
        }
        return bean;
    }

    @Override
    public Object getSingleValue(BundleJobQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        throw new UnsupportedOperationException();
    }

    public static enum BundleJobQuery {
        UPDATE_BUNDLE_JOB,
        UPDATE_BUNDLE_JOB_STATUS,
        UPDATE_BUNDLE_JOB_STATUS_PENDING,
        UPDATE_BUNDLE_JOB_STATUS_PENDING_MODTIME,
        UPDATE_BUNDLE_JOB_STATUS_PENDING_SUSP_MOD_TIME,
        UPDATE_BUNDLE_JOB_STATUS_PAUSE_ENDTIME,
        UPDATE_BUNDLE_JOB_PAUSE_KICKOFF,
        GET_BUNDLE_JOB,
        GET_BUNDLE_JOB_STATUS,
        GET_BUNDLE_JOB_ID_STATUS_PENDING_MODTIME,
        GET_BUNDLE_JOB_ID_JOBXML_CONF;

    }
}

