/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseConnectionPoolParameter;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.util.Launch;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class DataHandler
extends AbstractXulEventHandler {
    public static final SortedMap<String, DatabaseInterface> connectionMap = new TreeMap<String, DatabaseInterface>();
    public static final Map<String, String> connectionNametoID = new HashMap<String, String>();
    private static final String WEB_APPLICATION_NAME = "WEB_APPLICATION_NAME";
    private static final String EXTRA_OPTION_WEB_APPLICATION_NAME = "EXTRA_OPTION_KettleThin.webappname";
    protected DatabaseMeta databaseMeta = null;
    private DatabaseMeta cache = new DatabaseMeta();
    private XulDeck dialogDeck;
    private XulListbox deckOptionsBox;
    private XulListbox connectionBox;
    private XulListbox accessBox;
    private XulTextbox connectionNameBox;
    protected XulTextbox hostNameBox;
    protected XulTextbox databaseNameBox;
    protected XulTextbox portNumberBox;
    protected XulTextbox userNameBox;
    protected XulTextbox passwordBox;
    protected XulTextbox customDriverClassBox;
    protected XulTextbox customUrlBox;
    protected XulTextbox dataTablespaceBox;
    protected XulTextbox indexTablespaceBox;
    private XulTextbox serverInstanceBox;
    private XulTextbox serverNameBox;
    protected XulTextbox languageBox;
    protected XulTextbox systemNumberBox;
    protected XulTextbox clientBox;
    private XulCheckbox doubleDecimalSeparatorCheck;
    private XulCheckbox resultStreamingCursorCheck;
    private XulTextbox webAppName;
    protected XulTree optionsParameterTree;
    private XulCheckbox clusteringCheck;
    protected XulTree clusterParameterTree;
    private XulLabel clusterParameterDescriptionLabel;
    XulCheckbox supportBooleanDataType;
    XulCheckbox supportTimestampDataType;
    XulCheckbox quoteIdentifiersCheck;
    XulCheckbox lowerCaseIdentifiersCheck;
    XulCheckbox upperCaseIdentifiersCheck;
    XulCheckbox preserveReservedCaseCheck;
    XulCheckbox useIntegratedSecurityCheck;
    XulTextbox preferredSchemaName;
    XulTextbox sqlBox;
    private XulLabel poolSizeLabel;
    private XulLabel maxPoolSizeLabel;
    private XulCheckbox poolingCheck;
    protected XulTextbox poolSizeBox;
    protected XulTextbox maxPoolSizeBox;
    private XulTextbox poolingDescription;
    private XulLabel poolingParameterDescriptionLabel;
    private XulLabel poolingDescriptionLabel;
    protected XulTree poolParameterTree;
    protected XulButton acceptButton;
    private XulButton cancelButton;
    private XulButton testButton;
    private XulLabel noticeLabel;

    public void loadConnectionData() {
        if (this.connectionBox != null) {
            return;
        }
        this.getControls();
        final TreeSet<String> keys = new TreeSet<String>(connectionMap.keySet());
        for (String string : keys) {
            this.connectionBox.addItem((Object)string);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        registry.addPluginListener(DatabasePluginType.class, (PluginTypeListener)new DatabaseTypeListener(registry){

            @Override
            public void databaseTypeAdded(String pluginName, DatabaseInterface databaseInterface) {
                if (keys.add(pluginName)) {
                    this.update();
                }
            }

            @Override
            public void databaseTypeRemoved(String pluginName) {
                if (keys.remove(pluginName)) {
                    this.update();
                }
            }

            private void update() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataHandler.this.connectionBox.removeItems();
                        for (String key : keys) {
                            DataHandler.this.connectionBox.addItem((Object)key);
                        }
                    }
                });
            }
        });
        this.connectionBox.setRows(this.connectionBox.getRows());
        Object object = this.connectionBox.getSelectedItem();
        if (object == null) {
            String string = connectionMap.firstKey();
            this.connectionBox.setSelectedItem((Object)string);
        }
        if (this.dialogDeck != null) {
            this.setDeckChildIndex();
        }
        this.setDefaultPoolParameters();
        if (this.poolParameterTree != null) {
            this.poolParameterTree.setRows(this.poolParameterTree.getRows());
        }
    }

    public void loadAccessData() {
        this.getControls();
        this.pushCache();
        Object key = this.connectionBox.getSelectedItem();
        if (key == null) {
            key = connectionMap.firstKey();
            this.connectionBox.setSelectedItem(key);
            return;
        }
        DatabaseInterface database = (DatabaseInterface)connectionMap.get(key);
        int[] acc = database.getAccessTypeList();
        Object accessKey = this.accessBox.getSelectedItem();
        this.accessBox.removeItems();
        for (int value : acc) {
            this.accessBox.addItem((Object)DatabaseMeta.getAccessTypeDescLong((int)value));
        }
        this.accessBox.setRows(this.accessBox.getRows());
        if (accessKey != null) {
            this.accessBox.setSelectedItem(accessKey);
        }
        if (this.accessBox.getSelectedItem() == null) {
            this.accessBox.setSelectedItem((Object)DatabaseMeta.getAccessTypeDescLong((int)acc[0]));
        }
        Map options = null;
        if (this.databaseMeta != null) {
            this.databaseMeta.applyDefaultOptions(database);
            options = this.databaseMeta.getExtraOptions();
        } else {
            this.clearOptionsData();
            options = database.getDefaultOptions();
        }
        this.setOptionsData(options);
        PartitionDatabaseMeta[] clusterInfo = null;
        if (this.databaseMeta != null) {
            clusterInfo = this.databaseMeta.getPartitioningInformation();
        }
        this.setClusterData(clusterInfo);
        this.popCache();
    }

    public void editOptions(int index) {
        Object[][] values;
        Object[] row;
        if (!(index + 1 != this.optionsParameterTree.getRows() || (row = (values = this.optionsParameterTree.getValues())[values.length - 1]) == null || StringUtils.isEmpty((String)((String)row[0])) && StringUtils.isEmpty((String)((String)row[1])))) {
            XulTreeRow newRow = this.optionsParameterTree.getRootChildren().addNewRow();
            newRow.addCellText(0, "");
            newRow.addCellText(1, "");
        }
    }

    public void clearOptionsData() {
        this.getControls();
        if (this.optionsParameterTree != null) {
            this.optionsParameterTree.getRootChildren().removeAll();
        }
    }

    public void getOptionHelp() {
        String message = null;
        DatabaseMeta database = new DatabaseMeta();
        this.getInfo(database);
        String url = database.getExtraOptionsHelpText();
        if (url == null || url.trim().length() == 0) {
            message = Messages.getString("DataHandler.USER_NO_HELP_AVAILABLE");
            this.showMessage(message, false);
            return;
        }
        Launch.Status status = Launch.openURL(url);
        if (status.equals((Object)Launch.Status.Failed)) {
            message = Messages.getString("DataHandler.USER_UNABLE_TO_LAUNCH_BROWSER", url);
            this.showMessage(message, false);
        }
    }

    public void setDeckChildIndex() {
        this.getControls();
        int originalSelection = this.dialogDeck == null ? -1 : this.dialogDeck.getSelectedIndex();
        boolean passed = true;
        if (originalSelection == 3) {
            passed = this.checkPoolingParameters();
        }
        if (passed) {
            int selected = this.deckOptionsBox.getSelectedIndex();
            if (selected < 0) {
                selected = 0;
                this.deckOptionsBox.setSelectedIndex(0);
            }
            this.dialogDeck.setSelectedIndex(selected);
        } else {
            this.dialogDeck.setSelectedIndex(originalSelection);
            this.deckOptionsBox.setSelectedIndex(originalSelection);
        }
    }

    public void onPoolingCheck() {
        if (this.poolingCheck != null) {
            boolean dis;
            boolean bl = dis = !this.poolingCheck.isChecked();
            if (this.poolSizeBox != null) {
                this.poolSizeBox.setDisabled(dis);
            }
            if (this.maxPoolSizeBox != null) {
                this.maxPoolSizeBox.setDisabled(dis);
            }
            if (this.poolSizeLabel != null) {
                this.poolSizeLabel.setDisabled(dis);
            }
            if (this.maxPoolSizeLabel != null) {
                this.maxPoolSizeLabel.setDisabled(dis);
            }
            if (this.poolParameterTree != null) {
                this.poolParameterTree.setDisabled(dis);
            }
            if (this.poolingParameterDescriptionLabel != null) {
                this.poolingParameterDescriptionLabel.setDisabled(dis);
            }
            if (this.poolingDescriptionLabel != null) {
                this.poolingDescriptionLabel.setDisabled(dis);
            }
            if (this.poolingDescription != null) {
                this.poolingDescription.setDisabled(dis);
            }
        }
    }

    public void onClusterCheck() {
        if (this.clusteringCheck != null) {
            boolean dis;
            boolean bl = dis = !this.clusteringCheck.isChecked();
            if (this.clusterParameterTree != null) {
                this.clusterParameterTree.setDisabled(dis);
            }
            if (this.clusterParameterDescriptionLabel != null) {
                this.clusterParameterDescriptionLabel.setDisabled(dis);
            }
        }
    }

    public Object getData() {
        if (this.databaseMeta == null) {
            this.databaseMeta = new DatabaseMeta();
        }
        if (!this.windowClosed()) {
            this.getInfo(this.databaseMeta);
        }
        return this.databaseMeta;
    }

    public void setData(Object data) {
        if (data instanceof DatabaseMeta) {
            this.databaseMeta = (DatabaseMeta)data;
        }
        this.setInfo(this.databaseMeta);
    }

    public void pushCache() {
        this.getConnectionSpecificInfo(this.cache);
    }

    public void popCache() {
        this.setConnectionSpecificInfo(this.cache);
    }

    public void onCancel() {
        this.close();
    }

    private void close() {
        XulComponent window = this.document.getElementById("general-datasource-window");
        if (window == null) {
            window = this.document.getRootElement();
        }
        if (window instanceof XulDialog) {
            ((XulDialog)window).hide();
        } else if (window instanceof XulWindow) {
            ((XulWindow)window).close();
        }
    }

    private boolean windowClosed() {
        boolean closedWindow = true;
        XulComponent window = this.document.getElementById("general-datasource-window");
        if (window == null) {
            window = this.document.getRootElement();
        }
        if (window instanceof XulWindow) {
            closedWindow = ((XulWindow)window).isClosed();
        }
        return closedWindow;
    }

    public void onOK() {
        DatabaseMeta database = new DatabaseMeta();
        this.getInfo(database);
        boolean passed = this.checkPoolingParameters();
        if (!passed) {
            return;
        }
        String[] remarks = database.checkParameters();
        String message = "";
        if (remarks.length != 0) {
            for (int i = 0; i < remarks.length; ++i) {
                message = message.concat("* ").concat(remarks[i]).concat(System.getProperty("line.separator"));
            }
            this.showMessage(message, false);
        } else {
            if (this.databaseMeta == null) {
                this.databaseMeta = new DatabaseMeta();
            }
            this.getInfo(this.databaseMeta);
            this.databaseMeta.setChanged();
            this.close();
        }
    }

    public void testDatabaseConnection() {
        DatabaseMeta database = new DatabaseMeta();
        this.getInfo(database);
        String[] remarks = database.checkParameters();
        String message = "";
        if (remarks.length != 0) {
            for (int i = 0; i < remarks.length; ++i) {
                message = message.concat("* ").concat(remarks[i]).concat(System.getProperty("line.separator"));
            }
        } else {
            message = database.testConnection();
        }
        this.showMessage(message, message.length() > 300);
    }

    protected void getInfo(DatabaseMeta meta) {
        Object[][] values;
        Object access;
        this.getControls();
        if (this.databaseMeta != null && this.databaseMeta != meta) {
            meta.initializeVariablesFrom((VariableSpace)this.databaseMeta);
        }
        meta.setName(this.connectionNameBox.getValue());
        meta.setDisplayName(this.connectionNameBox.getValue());
        Object connection = this.connectionBox.getSelectedItem();
        if (connection != null) {
            meta.setDatabaseType((String)connection);
        }
        if ((access = this.accessBox.getSelectedItem()) != null) {
            meta.setAccessType(DatabaseMeta.getAccessType((String)((String)access)));
        }
        this.getConnectionSpecificInfo(meta);
        if (this.portNumberBox != null) {
            meta.setDBPort(this.portNumberBox.getValue());
        }
        if (this.optionsParameterTree != null) {
            values = this.optionsParameterTree.getValues();
            for (int i = 0; i < values.length; ++i) {
                String parameter = (String)values[i][0];
                String value = (String)values[i][1];
                if (value == null) {
                    value = "";
                }
                String dbType = meta.getPluginId();
                if (parameter == null || parameter.trim().length() <= 0) continue;
                if (value.trim().length() <= 0) {
                    value = "><EMPTY><";
                }
                meta.addExtraOption(dbType, parameter, value);
            }
        }
        if (this.supportBooleanDataType != null) {
            meta.setSupportsBooleanDataType(this.supportBooleanDataType.isChecked());
        }
        if (this.supportTimestampDataType != null) {
            meta.setSupportsTimestampDataType(this.supportTimestampDataType.isChecked());
        }
        if (this.quoteIdentifiersCheck != null) {
            meta.setQuoteAllFields(this.quoteIdentifiersCheck.isChecked());
        }
        if (this.lowerCaseIdentifiersCheck != null) {
            meta.setForcingIdentifiersToLowerCase(this.lowerCaseIdentifiersCheck.isChecked());
        }
        if (this.upperCaseIdentifiersCheck != null) {
            meta.setForcingIdentifiersToUpperCase(this.upperCaseIdentifiersCheck.isChecked());
        }
        if (this.preserveReservedCaseCheck != null) {
            meta.setPreserveReservedCase(this.preserveReservedCaseCheck.isChecked());
        }
        if (this.preferredSchemaName != null) {
            meta.setPreferredSchemaName(this.preferredSchemaName.getValue());
        }
        if (this.sqlBox != null) {
            meta.setConnectSQL(this.sqlBox.getValue());
        }
        if (this.clusteringCheck != null) {
            meta.setPartitioned(this.clusteringCheck.isChecked());
        }
        if (this.clusterParameterTree != null && meta.isPartitioned()) {
            values = this.clusterParameterTree.getValues();
            ArrayList<PartitionDatabaseMeta> pdms = new ArrayList<PartitionDatabaseMeta>();
            for (int i = 0; i < values.length; ++i) {
                String partitionId = (String)values[i][0];
                if (partitionId == null || partitionId.trim().length() <= 0) continue;
                String hostname = (String)values[i][1];
                String port = (String)values[i][2];
                String dbName = (String)values[i][3];
                String username = (String)values[i][4];
                String password = (String)values[i][5];
                PartitionDatabaseMeta pdm = new PartitionDatabaseMeta(partitionId, hostname, port, dbName);
                pdm.setUsername(username);
                pdm.setPassword(password);
                pdms.add(pdm);
            }
            PartitionDatabaseMeta[] pdmArray = new PartitionDatabaseMeta[pdms.size()];
            meta.setPartitioningInformation(pdms.toArray(pdmArray));
        }
        if (this.poolingCheck != null) {
            meta.setUsingConnectionPool(this.poolingCheck.isChecked());
        }
        if (meta.isUsingConnectionPool()) {
            if (this.poolSizeBox != null) {
                try {
                    int initialPoolSize = Integer.parseInt(this.poolSizeBox.getValue());
                    meta.setInitialPoolSize(initialPoolSize);
                }
                catch (NumberFormatException initialPoolSize) {
                    // empty catch block
                }
            }
            if (this.maxPoolSizeBox != null) {
                try {
                    int maxPoolSize = Integer.parseInt(this.maxPoolSizeBox.getValue());
                    meta.setMaximumPoolSize(maxPoolSize);
                }
                catch (NumberFormatException maxPoolSize) {
                    // empty catch block
                }
            }
            if (this.poolParameterTree != null) {
                Object[][] values2 = this.poolParameterTree.getValues();
                Properties properties = new Properties();
                for (int i = 0; i < values2.length; ++i) {
                    boolean isChecked = false;
                    isChecked = values2[i][0] instanceof Boolean ? ((Boolean)values2[i][0]).booleanValue() : Boolean.valueOf((String)values2[i][0]).booleanValue();
                    if (!isChecked) continue;
                    String parameter = (String)values2[i][1];
                    String value = (String)values2[i][2];
                    if (parameter == null || parameter.trim().length() <= 0 || value == null || value.trim().length() <= 0) continue;
                    properties.setProperty(parameter, value);
                }
                meta.setConnectionPoolingProperties(properties);
            }
        }
    }

    private void setInfo(DatabaseMeta meta) {
        PluginRegistry registry;
        PluginInterface dInterface;
        int index;
        if (meta == null) {
            return;
        }
        if (meta.getAttributes().containsKey(EXTRA_OPTION_WEB_APPLICATION_NAME)) {
            meta.setDBName((String)meta.getAttributes().get(EXTRA_OPTION_WEB_APPLICATION_NAME));
            meta.getAttributes().remove(EXTRA_OPTION_WEB_APPLICATION_NAME);
            meta.setChanged();
        }
        this.getControls();
        if (this.connectionNameBox != null) {
            this.connectionNameBox.setValue(meta.getDisplayName());
        }
        int n = index = (dInterface = (registry = PluginRegistry.getInstance()).getPlugin(DatabasePluginType.class, meta.getPluginId())) == null ? -1 : new ArrayList<String>(connectionMap.keySet()).indexOf(dInterface.getName());
        if (index >= 0) {
            this.connectionBox.setSelectedIndex(index);
        } else {
            LogChannel.GENERAL.logError("Unable to find database type " + (dInterface == null ? "null" : dInterface.getName()) + " in our connection map");
        }
        this.accessBox.setSelectedItem((Object)DatabaseMeta.getAccessTypeDescLong((int)meta.getAccessType()));
        this.setConnectionSpecificInfo(meta);
        this.loadAccessData();
        if (this.portNumberBox != null) {
            this.portNumberBox.setValue(meta.getDatabasePortNumberString());
        }
        this.setOptionsData(meta.getExtraOptions());
        if (this.supportBooleanDataType != null) {
            this.supportBooleanDataType.setChecked(meta.supportsBooleanDataType());
        }
        if (this.supportTimestampDataType != null) {
            this.supportTimestampDataType.setChecked(meta.supportsTimestampDataType());
        }
        if (this.quoteIdentifiersCheck != null) {
            this.quoteIdentifiersCheck.setChecked(meta.isQuoteAllFields());
        }
        if (this.lowerCaseIdentifiersCheck != null) {
            this.lowerCaseIdentifiersCheck.setChecked(meta.isForcingIdentifiersToLowerCase());
        }
        if (this.upperCaseIdentifiersCheck != null) {
            this.upperCaseIdentifiersCheck.setChecked(meta.isForcingIdentifiersToUpperCase());
        }
        if (this.preserveReservedCaseCheck != null) {
            this.preserveReservedCaseCheck.setChecked(meta.preserveReservedCase());
        }
        if (this.preferredSchemaName != null) {
            this.preferredSchemaName.setValue(Const.NVL((String)meta.getPreferredSchemaName(), (String)""));
        }
        if (this.sqlBox != null) {
            this.sqlBox.setValue(meta.getConnectSQL() == null ? "" : meta.getConnectSQL());
        }
        if (this.clusteringCheck != null) {
            this.clusteringCheck.setChecked(meta.isPartitioned());
        }
        this.setClusterData(meta.getPartitioningInformation());
        if (this.poolingCheck != null) {
            this.poolingCheck.setChecked(meta.isUsingConnectionPool());
        }
        if (meta.isUsingConnectionPool()) {
            if (this.poolSizeBox != null) {
                this.poolSizeBox.setValue(Integer.toString(meta.getInitialPoolSize()));
            }
            if (this.maxPoolSizeBox != null) {
                this.maxPoolSizeBox.setValue(Integer.toString(meta.getMaximumPoolSize()));
            }
            this.setPoolProperties(meta.getConnectionPoolingProperties());
        }
        this.setReadOnly(meta.isReadOnly());
        this.setDeckChildIndex();
        this.onPoolingCheck();
        this.onClusterCheck();
    }

    private void traverseDomSetReadOnly(XulComponent component, boolean readonly) {
        component.setDisabled(readonly);
        List children = component.getChildNodes();
        if (children != null && children.size() > 0) {
            for (XulComponent child : children) {
                child.setDisabled(readonly);
                this.traverseDomSetReadOnly(child, readonly);
            }
        }
    }

    private void setReadOnly(boolean readonly) {
        this.traverseDomSetReadOnly(this.document.getRootElement(), readonly);
        if (this.noticeLabel != null) {
            this.noticeLabel.setVisible(readonly);
        }
        if (readonly) {
            if (this.cancelButton != null) {
                this.cancelButton.setDisabled(false);
            }
            if (this.testButton != null) {
                this.testButton.setDisabled(false);
            }
            this.noticeLabel.setValue(Messages.getString("DatabaseDialog.label.ConnectionIsReadOnly"));
        }
    }

    private boolean checkPoolingParameters() {
        ArrayList<String> returnList = new ArrayList<String>();
        if (this.poolParameterTree != null) {
            Object[][] values = this.poolParameterTree.getValues();
            for (int i = 0; i < values.length; ++i) {
                boolean isChecked = false;
                isChecked = values[i][0] instanceof Boolean ? ((Boolean)values[i][0]).booleanValue() : Boolean.valueOf((String)values[i][0]).booleanValue();
                if (!isChecked) continue;
                String parameter = (String)values[i][1];
                String value = (String)values[i][2];
                if (value != null && value.trim().length() > 0) continue;
                returnList.add(parameter);
            }
            if (returnList.size() > 0) {
                String parameters = System.getProperty("line.separator");
                for (String parameter : returnList) {
                    parameters = parameters.concat(parameter).concat(System.getProperty("line.separator"));
                }
                String message = Messages.getString("DataHandler.USER_INVALID_PARAMETERS").concat(parameters);
                this.showMessage(message, false);
            }
        }
        return returnList.size() <= 0;
    }

    private void setPoolProperties(Properties properties) {
        if (this.poolParameterTree != null) {
            Object[][] values = this.poolParameterTree.getValues();
            for (int i = 0; i < values.length; ++i) {
                String parameter = (String)values[i][1];
                boolean isChecked = properties.containsKey(parameter);
                if (!isChecked) continue;
                XulTreeItem item = this.poolParameterTree.getRootChildren().getItem(i);
                item.getRow().addCellText(0, "true");
                String value = properties.getProperty(parameter);
                item.getRow().addCellText(2, value);
            }
        }
    }

    public void restoreDefaults() {
        if (this.poolParameterTree != null) {
            for (int i = 0; i < this.poolParameterTree.getRootChildren().getItemCount(); ++i) {
                XulTreeItem item = this.poolParameterTree.getRootChildren().getItem(i);
                String parameterName = item.getRow().getCell(1).getLabel();
                String defaultValue = DatabaseConnectionPoolParameter.findParameter((String)parameterName, (DatabaseConnectionPoolParameter[])BaseDatabaseMeta.poolingParameters).getDefaultValue();
                if (defaultValue == null || defaultValue.trim().length() <= 0) continue;
                item.getRow().addCellText(2, defaultValue);
            }
        }
    }

    private void setDefaultPoolParameters() {
        if (this.poolParameterTree != null) {
            for (DatabaseConnectionPoolParameter parameter : BaseDatabaseMeta.poolingParameters) {
                XulTreeRow row = this.poolParameterTree.getRootChildren().addNewRow();
                row.addCellText(0, "false");
                row.addCellText(1, parameter.getParameter());
                row.addCellText(2, parameter.getDefaultValue());
            }
        }
    }

    private void removeTypedOptions(Map<String, String> extraOptions) {
        int i;
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        Object[][] values = this.optionsParameterTree.getValues();
        for (i = 0; i < values.length; ++i) {
            String parameter = (String)values[i][0];
            Iterator<String> keys = extraOptions.keySet().iterator();
            if (extraOptions.keySet().size() > 0) {
                while (keys.hasNext()) {
                    String param = keys.next();
                    String parameterKey = param.substring(param.indexOf(46) + 1);
                    if (!parameter.equals(parameterKey) && !"".equals(parameter) || removeList.contains(i)) continue;
                    removeList.add(i);
                }
                continue;
            }
            if (!"".equals(parameter) || removeList.contains(i)) continue;
            removeList.add(i);
        }
        for (i = removeList.size() - 1; i >= 0; --i) {
            this.optionsParameterTree.getRootChildren().removeItem(((Integer)removeList.get(i)).intValue());
        }
    }

    private void setOptionsData(Map<String, String> extraOptions) {
        if (this.optionsParameterTree == null) {
            return;
        }
        if (extraOptions != null) {
            this.removeTypedOptions(extraOptions);
            Iterator<String> keys = extraOptions.keySet().iterator();
            Object connection = this.connectionBox.getSelectedItem();
            String currentType = null;
            if (connection != null) {
                currentType = ((DatabaseInterface)connectionMap.get(connection.toString())).getPluginId();
            }
            while (keys.hasNext()) {
                String databaseTypeString;
                int dotIndex;
                String parameter = keys.next();
                String value = extraOptions.get(parameter);
                if (value == null || value.trim().length() <= 0 || value.equals("><EMPTY><")) {
                    value = "";
                }
                if ((dotIndex = parameter.indexOf(46)) < 0) continue;
                String parameterOption = parameter.substring(dotIndex + 1);
                String databaseType = databaseTypeString = parameter.substring(0, dotIndex);
                if (currentType == null || !currentType.equals(databaseType)) continue;
                XulTreeRow row = this.optionsParameterTree.getRootChildren().addNewRow();
                row.addCellText(0, parameterOption);
                row.addCellText(1, value);
            }
        }
        int numToAdd = 5;
        int numSet = this.optionsParameterTree.getRootChildren().getItemCount();
        numToAdd = numSet < numToAdd ? (numToAdd -= numSet) : 1;
        while (numToAdd-- > 0) {
            XulTreeRow row = this.optionsParameterTree.getRootChildren().addNewRow();
            row.addCellText(0, "");
            row.addCellText(1, "");
        }
    }

    private void setClusterData(PartitionDatabaseMeta[] clusterInformation) {
        if (this.clusterParameterTree == null) {
            return;
        }
        this.clusterParameterTree.getRootChildren().removeAll();
        if (clusterInformation != null && this.clusterParameterTree != null) {
            for (int i = 0; i < clusterInformation.length; ++i) {
                PartitionDatabaseMeta meta = clusterInformation[i];
                XulTreeRow row = this.clusterParameterTree.getRootChildren().addNewRow();
                row.addCellText(0, Const.NVL((String)meta.getPartitionId(), (String)""));
                row.addCellText(1, Const.NVL((String)meta.getHostname(), (String)""));
                row.addCellText(2, Const.NVL((String)meta.getPort(), (String)""));
                row.addCellText(3, Const.NVL((String)meta.getDatabaseName(), (String)""));
                row.addCellText(4, Const.NVL((String)meta.getUsername(), (String)""));
                row.addCellText(5, Const.NVL((String)meta.getPassword(), (String)""));
            }
        }
        int numToAdd = 5;
        while (numToAdd-- > 0) {
            XulTreeRow row = this.clusterParameterTree.getRootChildren().addNewRow();
            row.addCellText(0, "");
            row.addCellText(1, "");
            row.addCellText(2, "");
            row.addCellText(3, "");
            row.addCellText(4, "");
            row.addCellText(5, "");
        }
    }

    public void poolingRowChange(int idx) {
        if (idx != -1) {
            if (idx >= BaseDatabaseMeta.poolingParameters.length) {
                idx = BaseDatabaseMeta.poolingParameters.length - 1;
            }
            if (idx < 0) {
                idx = 0;
            }
            this.poolingDescription.setValue(BaseDatabaseMeta.poolingParameters[idx].getDescription());
            XulTreeRow row = this.poolParameterTree.getRootChildren().getItem(idx).getRow();
            if (row.getSelectedColumnIndex() == 2) {
                row.addCellText(0, "true");
            }
        }
    }

    private void getConnectionSpecificInfo(DatabaseMeta meta) {
        if (this.hostNameBox != null) {
            meta.setHostname(this.hostNameBox.getValue());
        }
        if (this.databaseNameBox != null) {
            meta.setDBName(this.databaseNameBox.getValue());
        }
        if (this.userNameBox != null) {
            meta.setUsername(this.userNameBox.getValue());
        }
        if (this.passwordBox != null) {
            meta.setPassword(this.passwordBox.getValue());
        }
        if (this.resultStreamingCursorCheck != null) {
            meta.setStreamingResults(this.resultStreamingCursorCheck.isChecked());
        }
        if (this.dataTablespaceBox != null) {
            meta.setDataTablespace(this.dataTablespaceBox.getValue());
        }
        if (this.indexTablespaceBox != null) {
            meta.setIndexTablespace(this.indexTablespaceBox.getValue());
        }
        if (this.serverInstanceBox != null) {
            meta.setSQLServerInstance(this.serverInstanceBox.getValue());
            if (this.optionsParameterTree != null && this.optionsParameterTree.getRootChildren() != null) {
                for (int i = 0; i < this.optionsParameterTree.getRootChildren().getItemCount(); ++i) {
                    XulTreeItem potRow = this.optionsParameterTree.getRootChildren().getItem(i);
                    if (potRow == null || potRow.getRow() == null) continue;
                    XulTreeCell cell = potRow.getRow().getCell(0);
                    XulTreeCell cell2 = potRow.getRow().getCell(1);
                    if (cell == null || cell.getLabel() == null || !cell.getLabel().equals("instance")) continue;
                    cell2.setLabel(this.serverInstanceBox.getValue());
                    if (this.serverInstanceBox.getValue().trim().length() != 0) continue;
                    cell.setLabel("");
                }
            }
        }
        if (this.doubleDecimalSeparatorCheck != null) {
            meta.setUsingDoubleDecimalAsSchemaTableSeparator(this.doubleDecimalSeparatorCheck.isChecked());
        }
        if (this.languageBox != null) {
            meta.getAttributes().put("SAPLanguage", this.languageBox.getValue());
        }
        if (this.systemNumberBox != null) {
            meta.getAttributes().put("SAPSystemNumber", this.systemNumberBox.getValue());
        }
        if (this.clientBox != null) {
            meta.getAttributes().put("SAPClient", this.clientBox.getValue());
        }
        if (this.customUrlBox != null) {
            meta.getAttributes().put("CUSTOM_URL", this.customUrlBox.getValue());
        }
        if (this.customDriverClassBox != null) {
            meta.getAttributes().put("CUSTOM_DRIVER_CLASS", this.customDriverClassBox.getValue());
        }
        if (this.serverNameBox != null) {
            meta.setServername(this.serverNameBox.getValue());
        }
        if (this.useIntegratedSecurityCheck != null) {
            Boolean useIntegratedSecurity = this.useIntegratedSecurityCheck.isChecked();
            meta.getAttributes().put("MSSQLUseIntegratedSecurity", useIntegratedSecurity != null ? useIntegratedSecurity.toString() : "false");
        }
        if (this.webAppName != null) {
            meta.setDBName(this.webAppName.getValue());
        }
    }

    private void setConnectionSpecificInfo(DatabaseMeta meta) {
        this.getControls();
        if (this.hostNameBox != null) {
            this.hostNameBox.setValue(meta.getHostname());
        }
        if (this.databaseNameBox != null) {
            this.databaseNameBox.setValue(meta.getDatabaseName());
        }
        if (this.userNameBox != null) {
            this.userNameBox.setValue(meta.getUsername());
        }
        if (this.passwordBox != null) {
            this.passwordBox.setValue(meta.getPassword());
        }
        if (this.resultStreamingCursorCheck != null) {
            this.resultStreamingCursorCheck.setChecked(meta.isStreamingResults());
        }
        if (this.dataTablespaceBox != null) {
            this.dataTablespaceBox.setValue(meta.getDataTablespace());
        }
        if (this.indexTablespaceBox != null) {
            this.indexTablespaceBox.setValue(meta.getIndexTablespace());
        }
        if (this.serverInstanceBox != null) {
            this.serverInstanceBox.setValue(meta.getSQLServerInstance());
        }
        if (this.doubleDecimalSeparatorCheck != null) {
            this.doubleDecimalSeparatorCheck.setChecked(meta.isUsingDoubleDecimalAsSchemaTableSeparator());
        }
        if (this.languageBox != null) {
            this.languageBox.setValue(meta.getAttributes().getProperty("SAPLanguage"));
        }
        if (this.systemNumberBox != null) {
            this.systemNumberBox.setValue(meta.getAttributes().getProperty("SAPSystemNumber"));
        }
        if (this.clientBox != null) {
            this.clientBox.setValue(meta.getAttributes().getProperty("SAPClient"));
        }
        if (this.customUrlBox != null) {
            this.customUrlBox.setValue(meta.getAttributes().getProperty("CUSTOM_URL"));
        }
        if (this.customDriverClassBox != null) {
            this.customDriverClassBox.setValue(meta.getAttributes().getProperty("CUSTOM_DRIVER_CLASS"));
        }
        if (this.serverNameBox != null) {
            this.serverNameBox.setValue(meta.getServername());
        }
        if (this.useIntegratedSecurityCheck != null) {
            Object value = meta.getAttributes().get("MSSQLUseIntegratedSecurity");
            if (value != null && value instanceof String) {
                String useIntegratedSecurity = (String)value;
                this.useIntegratedSecurityCheck.setChecked(Boolean.parseBoolean(useIntegratedSecurity));
            } else {
                this.useIntegratedSecurityCheck.setChecked(false);
            }
        }
        if (this.webAppName != null) {
            if (Utils.isEmpty((CharSequence)meta.getDatabaseName())) {
                this.webAppName.setValue("pentaho");
            } else {
                this.webAppName.setValue(meta.getDatabaseName());
            }
        }
    }

    protected void getControls() {
        this.dialogDeck = (XulDeck)this.document.getElementById("dialog-panel-deck");
        this.deckOptionsBox = (XulListbox)this.document.getElementById("deck-options-list");
        this.connectionBox = (XulListbox)this.document.getElementById("connection-type-list");
        this.accessBox = (XulListbox)this.document.getElementById("access-type-list");
        this.connectionNameBox = (XulTextbox)this.document.getElementById("connection-name-text");
        this.hostNameBox = (XulTextbox)this.document.getElementById("server-host-name-text");
        this.databaseNameBox = (XulTextbox)this.document.getElementById("database-name-text");
        this.portNumberBox = (XulTextbox)this.document.getElementById("port-number-text");
        this.userNameBox = (XulTextbox)this.document.getElementById("username-text");
        this.passwordBox = (XulTextbox)this.document.getElementById("password-text");
        this.dataTablespaceBox = (XulTextbox)this.document.getElementById("data-tablespace-text");
        this.indexTablespaceBox = (XulTextbox)this.document.getElementById("index-tablespace-text");
        this.serverInstanceBox = (XulTextbox)this.document.getElementById("instance-text");
        this.serverNameBox = (XulTextbox)this.document.getElementById("server-name-text");
        this.customUrlBox = (XulTextbox)this.document.getElementById("custom-url-text");
        this.customDriverClassBox = (XulTextbox)this.document.getElementById("custom-driver-class-text");
        this.languageBox = (XulTextbox)this.document.getElementById("language-text");
        this.systemNumberBox = (XulTextbox)this.document.getElementById("system-number-text");
        this.clientBox = (XulTextbox)this.document.getElementById("client-text");
        this.doubleDecimalSeparatorCheck = (XulCheckbox)this.document.getElementById("decimal-separator-check");
        this.resultStreamingCursorCheck = (XulCheckbox)this.document.getElementById("result-streaming-check");
        this.webAppName = (XulTextbox)this.document.getElementById("web-application-name-text");
        this.poolingCheck = (XulCheckbox)this.document.getElementById("use-pool-check");
        this.clusteringCheck = (XulCheckbox)this.document.getElementById("use-cluster-check");
        this.clusterParameterDescriptionLabel = (XulLabel)this.document.getElementById("cluster-parameter-description-label");
        this.poolSizeLabel = (XulLabel)this.document.getElementById("pool-size-label");
        this.poolSizeBox = (XulTextbox)this.document.getElementById("pool-size-text");
        this.maxPoolSizeLabel = (XulLabel)this.document.getElementById("max-pool-size-label");
        this.maxPoolSizeBox = (XulTextbox)this.document.getElementById("max-pool-size-text");
        this.poolParameterTree = (XulTree)this.document.getElementById("pool-parameter-tree");
        this.clusterParameterTree = (XulTree)this.document.getElementById("cluster-parameter-tree");
        this.optionsParameterTree = (XulTree)this.document.getElementById("options-parameter-tree");
        this.poolingDescription = (XulTextbox)this.document.getElementById("pooling-description");
        this.poolingParameterDescriptionLabel = (XulLabel)this.document.getElementById("pool-parameter-description-label");
        this.poolingDescriptionLabel = (XulLabel)this.document.getElementById("pooling-description-label");
        this.supportBooleanDataType = (XulCheckbox)this.document.getElementById("supports-boolean-data-type");
        this.supportTimestampDataType = (XulCheckbox)this.document.getElementById("supports-timestamp-data-type");
        this.quoteIdentifiersCheck = (XulCheckbox)this.document.getElementById("quote-identifiers-check");
        this.lowerCaseIdentifiersCheck = (XulCheckbox)this.document.getElementById("force-lower-case-check");
        this.upperCaseIdentifiersCheck = (XulCheckbox)this.document.getElementById("force-upper-case-check");
        this.preserveReservedCaseCheck = (XulCheckbox)this.document.getElementById("preserve-reserved-case");
        this.preferredSchemaName = (XulTextbox)this.document.getElementById("preferred-schema-name-text");
        this.sqlBox = (XulTextbox)this.document.getElementById("sql-text");
        this.useIntegratedSecurityCheck = (XulCheckbox)this.document.getElementById("use-integrated-security-check");
        this.acceptButton = (XulButton)this.document.getElementById("general-datasource-window_accept");
        this.cancelButton = (XulButton)this.document.getElementById("general-datasource-window_cancel");
        this.testButton = (XulButton)this.document.getElementById("test-button");
        this.noticeLabel = (XulLabel)this.document.getElementById("notice-label");
        if (this.portNumberBox != null && this.serverInstanceBox != null && Boolean.parseBoolean(this.serverInstanceBox.getAttributeValue("shouldDisablePortIfPopulated"))) {
            this.serverInstanceBox.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("value".equals(evt.getPropertyName())) {
                        DataHandler.this.disablePortIfInstancePopulated();
                    }
                }
            });
        }
    }

    public void disablePortIfInstancePopulated() {
        String serverInstance = this.serverInstanceBox.getValue();
        if (serverInstance != null && serverInstance.length() > 0) {
            this.portNumberBox.setDisabled(true);
        } else {
            this.portNumberBox.setDisabled(false);
        }
    }

    protected void showMessage(String message, boolean scroll) {
        try {
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setMessage(message);
            box.setModalParent(((XulRoot)this.document.getElementById("general-datasource-window")).getRootObject());
            if (scroll) {
                box.setScrollable(true);
                box.setWidth(500);
                box.setHeight(400);
            }
            box.open();
        }
        catch (XulException e) {
            System.out.println("Error creating messagebox " + e.getMessage());
        }
    }

    public void handleUseSecurityCheckbox() {
        if (this.useIntegratedSecurityCheck != null) {
            if (this.useIntegratedSecurityCheck.isChecked()) {
                this.userNameBox.setDisabled(true);
                this.passwordBox.setDisabled(true);
            } else {
                this.userNameBox.setDisabled(false);
                this.passwordBox.setDisabled(false);
            }
        }
    }

    static {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(DatabasePluginType.class);
        DatabaseTypeListener databaseTypeListener = new DatabaseTypeListener(registry){

            @Override
            public void databaseTypeAdded(String pluginName, DatabaseInterface databaseInterface) {
                connectionMap.put(pluginName, databaseInterface);
                connectionNametoID.put(pluginName, databaseInterface.getPluginId());
            }

            @Override
            public void databaseTypeRemoved(String pluginName) {
                connectionMap.remove(pluginName);
                connectionNametoID.remove(pluginName);
            }
        };
        registry.addPluginListener(DatabasePluginType.class, (PluginTypeListener)databaseTypeListener);
        for (PluginInterface plugin : plugins) {
            databaseTypeListener.pluginAdded(plugin);
        }
    }

    protected static abstract class DatabaseTypeListener
    implements PluginTypeListener {
        private final PluginRegistry registry;

        public DatabaseTypeListener(PluginRegistry registry) {
            this.registry = registry;
        }

        public void pluginAdded(Object serviceObject) {
            PluginInterface plugin = (PluginInterface)serviceObject;
            String pluginName = plugin.getName();
            try {
                DatabaseInterface databaseInterface = (DatabaseInterface)this.registry.loadClass(plugin);
                databaseInterface.setPluginId(plugin.getIds()[0]);
                databaseInterface.setName(pluginName);
                this.databaseTypeAdded(pluginName, databaseInterface);
            }
            catch (KettleException e) {
                Throwable t = e;
                if (e.getCause() != null) {
                    t = e.getCause();
                }
                System.out.println("Could not create connection entry for " + pluginName + ".  " + t.getClass().getName());
                LogChannel.GENERAL.logError("Could not create connection entry for " + pluginName + ".  " + t.getClass().getName());
            }
        }

        public abstract void databaseTypeAdded(String var1, DatabaseInterface var2);

        public void pluginRemoved(Object serviceObject) {
            PluginInterface plugin = (PluginInterface)serviceObject;
            String pluginName = plugin.getName();
            this.databaseTypeRemoved(pluginName);
        }

        public abstract void databaseTypeRemoved(String var1);

        public void pluginChanged(Object serviceObject) {
            this.pluginRemoved(serviceObject);
            this.pluginAdded(serviceObject);
        }
    }
}

