/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.celloutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.palo.core.DimensionField;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutput;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="PaloCellOutput", image="PaloCellOutput.svg", i18nPackageName="org.pentaho.di.trans.steps.palo.celloutput", name="PaloCellOutput.TransName", description="PaloCellOutput.TransDescription", documentationUrl="http://wiki.pentaho.com/display/EAI/Palo+Cell+Output", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Palo")
public class PaloCellOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String cube = "";
    private String measureType = "";
    private String updateMode = "SET";
    private String splashMode = "DISABLED";
    private boolean clearCube;
    private List<DimensionField> fields = new ArrayList<DimensionField>();
    private DimensionField measureField = new DimensionField("", "", "");
    private int commitSize = 1000;
    private boolean enableDimensionCache = true;
    private boolean preloadDimensionCache = true;

    public void setDefault() {
        if (this.updateMode == null) {
            this.updateMode = "SET";
        }
        if (this.splashMode == null) {
            this.splashMode = "DISABLED";
        }
    }

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public final void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public final void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public final Object clone() {
        PaloCellOutputMeta retval = (PaloCellOutputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.cube = XMLHandler.getTagValue((Node)stepnode, (String)"cube");
            this.measureType = XMLHandler.getTagValue((Node)stepnode, (String)"measuretype");
            this.updateMode = XMLHandler.getTagValue((Node)stepnode, (String)"updateMode");
            this.splashMode = XMLHandler.getTagValue((Node)stepnode, (String)"splashMode");
            this.clearCube = XMLHandler.getTagValue((Node)stepnode, (String)"clearcube").equals("Y");
            try {
                this.enableDimensionCache = XMLHandler.getTagValue((Node)stepnode, (String)"enableDimensionCache").equals("Y");
                this.preloadDimensionCache = XMLHandler.getTagValue((Node)stepnode, (String)"preloadDimensionCache").equals("Y");
                this.commitSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"commitSize"));
            }
            catch (Exception e) {
                this.enableDimensionCache = false;
                this.preloadDimensionCache = false;
                this.commitSize = 1000;
            }
            this.fields = new ArrayList<DimensionField>();
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                String dimensionName = XMLHandler.getTagValue((Node)fnode, (String)"dimensionname");
                String fieldName = XMLHandler.getTagValue((Node)fnode, (String)"fieldname");
                String fieldType = XMLHandler.getTagValue((Node)fnode, (String)"fieldtype");
                this.fields.add(new DimensionField(dimensionName, fieldName, fieldType));
            }
            int i = 0;
            Node measures = XMLHandler.getSubNode((Node)stepnode, (String)"measures");
            int nrMeasures = XMLHandler.countNodes((Node)measures, (String)"measure");
            if (i < nrMeasures) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)measures, (String)"measure", (int)i);
                String measureName = XMLHandler.getTagValue((Node)fnode, (String)"measurename");
                String fieldName = XMLHandler.getTagValue((Node)fnode, (String)"measurefieldname");
                String fieldType = XMLHandler.getTagValue((Node)fnode, (String)"measurefieldtype");
                this.measureField = new DimensionField(measureName, fieldName, fieldType);
            }
            this.setDefault();
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public final String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cube", (String)this.cube));
        retval.append("    ").append(XMLHandler.addTagValue((String)"measuretype", (String)this.measureType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"updateMode", (String)this.updateMode));
        retval.append("    ").append(XMLHandler.addTagValue((String)"splashMode", (String)this.splashMode));
        retval.append("    ").append(XMLHandler.addTagValue((String)"clearcube", (boolean)this.clearCube));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enableDimensionCache", (boolean)this.enableDimensionCache));
        retval.append("    ").append(XMLHandler.addTagValue((String)"preloadDimensionCache", (boolean)this.preloadDimensionCache));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commitSize", (int)this.commitSize));
        retval.append("    <fields>").append(Const.CR);
        for (DimensionField field : this.fields) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"dimensionname", (String)field.getDimensionName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldname", (String)field.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldtype", (String)field.getFieldType()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <measures>").append(Const.CR);
        if (this.measureField.getDimensionName() != "") {
            retval.append("      <measure>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"measurename", (String)this.measureField.getDimensionName()));
            if (this.measureField.getFieldName() == "") {
                retval.append("        ").append(XMLHandler.addTagValue((String)"measurefieldname", (String)"CHOOSE FIELD"));
            } else {
                retval.append("        ").append(XMLHandler.addTagValue((String)"measurefieldname", (String)this.measureField.getFieldName()));
            }
            retval.append("        ").append(XMLHandler.addTagValue((String)"measurefieldtype", (String)this.measureField.getFieldType()));
            retval.append("      </measure>").append(Const.CR);
        }
        retval.append("    </measures>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(idStep, "connection", databases);
            this.cube = rep.getStepAttributeString(idStep, "cube");
            this.measureType = rep.getStepAttributeString(idStep, "measuretype");
            this.updateMode = rep.getStepAttributeString(idStep, "updateMode");
            this.splashMode = rep.getStepAttributeString(idStep, "splashMode");
            this.clearCube = rep.getStepAttributeBoolean(idStep, "clearcube");
            try {
                this.enableDimensionCache = rep.getStepAttributeBoolean(idStep, "enableDimensionCache");
                this.preloadDimensionCache = rep.getStepAttributeBoolean(idStep, "preloadDimensionCache");
                this.commitSize = (int)rep.getStepAttributeInteger(idStep, "commitSize");
                if (this.commitSize <= 0) {
                    this.setCommitSize(1000);
                }
            }
            catch (Exception e) {
                this.enableDimensionCache = false;
                this.preloadDimensionCache = false;
                this.commitSize = 1000;
            }
            int nrFields = rep.countNrStepAttributes(idStep, "dimensionname");
            for (int i = 0; i < nrFields; ++i) {
                String dimensionName = rep.getStepAttributeString(idStep, i, "dimensionname");
                String fieldName = rep.getStepAttributeString(idStep, i, "fieldname");
                String fieldType = rep.getStepAttributeString(idStep, i, "fieldtype");
                this.fields.add(new DimensionField(dimensionName, fieldName, fieldType));
            }
            String measureName = rep.getStepAttributeString(idStep, "measurename");
            String measureFieldName = rep.getStepAttributeString(idStep, "measurefieldname");
            String measureFieldType = rep.getStepAttributeString(idStep, "measurefieldtype");
            this.measureField = new DimensionField(measureName, measureFieldName, measureFieldType);
            this.setDefault();
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(idTransformation, idStep, "connection", this.databaseMeta);
            rep.saveStepAttribute(idTransformation, idStep, "cube", this.cube);
            rep.saveStepAttribute(idTransformation, idStep, "measuretype", this.measureType);
            rep.saveStepAttribute(idTransformation, idStep, "updateMode", this.updateMode);
            rep.saveStepAttribute(idTransformation, idStep, "splashMode", this.splashMode);
            rep.saveStepAttribute(idTransformation, idStep, "clearcube", this.clearCube);
            rep.saveStepAttribute(idTransformation, idStep, "preloadDimensionCache", this.preloadDimensionCache);
            rep.saveStepAttribute(idTransformation, idStep, "enableDimensionCache", this.enableDimensionCache);
            rep.saveStepAttribute(idTransformation, idStep, "commitSize", (long)this.commitSize);
            rep.saveStepAttribute(idTransformation, idStep, "measurename", this.measureField.getDimensionName());
            rep.saveStepAttribute(idTransformation, idStep, "measurefieldname", this.measureField.getFieldName());
            rep.saveStepAttribute(idTransformation, idStep, "measurefieldtype", this.measureField.getFieldType());
            for (int i = 0; i < this.fields.size(); ++i) {
                rep.saveStepAttribute(idTransformation, idStep, i, "dimensionname", this.fields.get(i).getDimensionName());
                rep.saveStepAttribute(idTransformation, idStep, i, "fieldname", this.fields.get(i).getFieldName());
                rep.saveStepAttribute(idTransformation, idStep, i, "fieldtype", this.fields.get(i).getFieldType());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for idStep=" + idStep, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.databaseMeta != null) {
            CheckResult cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            PaloHelper helper = new PaloHelper(this.databaseMeta, DefaultLogLevel.getLogLevel());
            try {
                helper.connect();
                cr = new CheckResult(1, "Connection to database OK", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (!Utils.isEmpty((CharSequence)this.cube)) {
                    cr = new CheckResult(1, "The name of the cube is entered", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, "The name of the cube is missing.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (this.measureField == null || Utils.isEmpty((CharSequence)this.measureField.getFieldName())) {
                    cr = new CheckResult(4, "Measure field is empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else if (Utils.isEmpty((CharSequence)this.measureField.getFieldType())) {
                    cr = new CheckResult(4, "Measure field type is empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (this.fields == null || this.fields.size() == 0) {
                    cr = new CheckResult(4, "Cell Output Fields are empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                for (DimensionField field : this.fields) {
                    if (Utils.isEmpty((CharSequence)field.getFieldName())) {
                        cr = new CheckResult(4, "Input field for dimension " + field.getDimensionName() + " is empty.", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    if (!Utils.isEmpty((CharSequence)field.getFieldType())) continue;
                    cr = new CheckResult(4, "Input field type for dimension " + field.getDimensionName() + " is empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (KettleException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                helper.disconnect();
            }
        } else {
            CheckResult cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public final StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PaloCellOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public final StepDataInterface getStepData() {
        try {
            return new PaloCellOutputData(this.databaseMeta);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public final String getMeasureType() {
        return this.measureType;
    }

    public final void setMeasureType(String measureType) {
        this.measureType = measureType;
    }

    public List<DimensionField> getFields() {
        return this.fields;
    }

    public void setLevels(List<DimensionField> fields) {
        this.fields = fields;
    }

    public DimensionField getMeasure() {
        return this.measureField;
    }

    public void setMeasureField(DimensionField measureField) {
        this.measureField = measureField;
    }

    public String getUpdateMode() {
        return this.updateMode;
    }

    public void setUpdateMode(String updateMode) {
        this.updateMode = updateMode;
    }

    public String getSplashMode() {
        return this.splashMode;
    }

    public void setSplashMode(String splashMode) {
        this.splashMode = splashMode;
    }

    public void setClearCube(boolean create) {
        this.clearCube = create;
    }

    public boolean getClearCube() {
        return this.clearCube;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setEnableDimensionCache(boolean enableDimensionCache) {
        this.enableDimensionCache = enableDimensionCache;
    }

    public boolean getEnableDimensionCache() {
        return this.enableDimensionCache;
    }

    public void setPreloadDimensionCache(boolean preloadDimensionCache) {
        this.preloadDimensionCache = preloadDimensionCache;
    }

    public boolean getPreloadDimensionCache() {
        return this.preloadDimensionCache;
    }
}

