/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceOper
extends Operator<MROpPlanVisitor> {
    private static final long serialVersionUID = 1L;
    public PhysicalPlan mapPlan;
    public PhysicalPlan reducePlan;
    public PhysicalPlan combinePlan;
    public byte mapKeyType;
    boolean mapDone = false;
    boolean reduceDone = false;
    boolean endOfAllInputInMap = false;
    boolean endOfAllInputInReduce = false;
    boolean globalSort = false;
    boolean limitAfterSort = false;
    boolean limitOnly = false;
    OPER_FEATURE feature = OPER_FEATURE.NONE;
    boolean needsDistinctCombiner = false;
    boolean useSecondaryKey = false;
    String quantFile;
    boolean[] sortOrder;
    boolean[] secondarySortOrder;
    public Set<String> UDFs;
    public Set<PhysicalOperator> scalars;
    boolean isUDFComparatorUsed = false;
    transient NodeIdGenerator nig;
    private String scope;
    int requestedParallelism = -1;
    int estimatedParallelism = -1;
    int runtimeParallelism = -1;
    String customPartitioner = null;
    long limit = -1L;
    PhysicalPlan limitPlan = null;
    private boolean splitter = false;
    private boolean skewedJoin = false;
    private String skewedJoinPartitionFile;
    private boolean usingTypedComparator = false;
    private boolean combineSmallSplits = true;
    public MultiMap<PhysicalOperator, PhysicalOperator> phyToMRMap;

    public MapReduceOper(OperatorKey k) {
        super(k);
        this.mapPlan = new PhysicalPlan();
        this.combinePlan = new PhysicalPlan();
        this.reducePlan = new PhysicalPlan();
        this.UDFs = new HashSet<String>();
        this.scalars = new HashSet<PhysicalOperator>();
        this.nig = NodeIdGenerator.getGenerator();
        this.scope = k.getScope();
        this.phyToMRMap = new MultiMap();
    }

    private String shiftStringByTabs(String DFStr, String tab) {
        StringBuilder sb = new StringBuilder();
        String[] spl = DFStr.split("\n");
        for (int i = 0; i < spl.length; ++i) {
            sb.append(tab);
            sb.append(spl[i]);
            sb.append("\n");
        }
        sb.delete(sb.length() - "\n".length(), sb.length());
        return sb.toString();
    }

    @Override
    public String name() {
        String udfStr = this.getUDFsAsStr();
        StringBuilder sb = new StringBuilder("MapReduce(" + this.requestedParallelism + (udfStr.equals("") ? "" : ",") + udfStr + ")" + " - " + this.mKey.toString() + ":\n");
        int index = sb.length();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.mapPlan.isEmpty()) {
            this.mapPlan.explain(baos);
            String mp = new String(baos.toByteArray());
            sb.append(this.shiftStringByTabs(mp, "|   "));
        } else {
            sb.append("Map Plan Empty");
        }
        if (!this.reducePlan.isEmpty()) {
            baos.reset();
            this.reducePlan.explain(baos);
            String rp = new String(baos.toByteArray());
            sb.insert(index, this.shiftStringByTabs(rp, "|   ") + "\n");
        } else {
            sb.insert(index, "Reduce Plan Empty\n");
        }
        return sb.toString();
    }

    private String getUDFsAsStr() {
        StringBuilder sb = new StringBuilder();
        if (this.UDFs != null && this.UDFs.size() > 0) {
            for (String str : this.UDFs) {
                sb.append(str.substring(str.lastIndexOf(46) + 1));
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    public void visit(MROpPlanVisitor v) throws VisitorException {
        v.visitMROp(this);
    }

    public boolean isMapDone() {
        return this.mapDone;
    }

    public void setMapDone(boolean mapDone) {
        this.mapDone = mapDone;
    }

    public void setMapDoneSingle(boolean mapDone) throws PlanException {
        this.mapDone = mapDone;
        if (mapDone && this.mapPlan.getLeaves().size() > 1) {
            this.mapPlan.addAsLeaf(this.getUnion());
        }
    }

    public void setMapDoneMultiple(boolean mapDone) throws PlanException {
        this.mapDone = mapDone;
        if (mapDone && this.mapPlan.getLeaves().size() > 0) {
            this.mapPlan.addAsLeaf(this.getUnion());
        }
    }

    private POUnion getUnion() {
        return new POUnion(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
    }

    public boolean isReduceDone() {
        return this.reduceDone;
    }

    public void setReduceDone(boolean reduceDone) {
        this.reduceDone = reduceDone;
    }

    public boolean isGlobalSort() {
        return this.globalSort;
    }

    public boolean isSkewedJoin() {
        return this.skewedJoinPartitionFile != null;
    }

    public void setSkewedJoinPartitionFile(String file) {
        this.skewedJoinPartitionFile = file;
    }

    public String getSkewedJoinPartitionFile() {
        return this.skewedJoinPartitionFile;
    }

    public void setSkewedJoin(boolean skJoin) {
        this.skewedJoin = skJoin;
    }

    public boolean getSkewedJoin() {
        return this.skewedJoin;
    }

    public void setGlobalSort(boolean globalSort) {
        this.globalSort = globalSort;
    }

    public boolean isLimitAfterSort() {
        return this.limitAfterSort;
    }

    public void setLimitAfterSort(boolean las) {
        this.limitAfterSort = las;
    }

    public boolean isLimitOnly() {
        return this.limitOnly;
    }

    public void setLimitOnly(boolean limitOnly) {
        this.limitOnly = limitOnly;
    }

    public boolean isIndexer() {
        return this.feature == OPER_FEATURE.INDEXER;
    }

    public void markIndexer() {
        this.feature = OPER_FEATURE.INDEXER;
    }

    public boolean isSampler() {
        return this.feature == OPER_FEATURE.SAMPLER;
    }

    public void markSampler() {
        this.feature = OPER_FEATURE.SAMPLER;
    }

    public boolean isGroupBy() {
        return this.feature == OPER_FEATURE.GROUPBY;
    }

    public void markGroupBy() {
        this.feature = OPER_FEATURE.GROUPBY;
    }

    public boolean isCogroup() {
        return this.feature == OPER_FEATURE.COGROUP;
    }

    public void markCogroup() {
        this.feature = OPER_FEATURE.COGROUP;
    }

    public boolean isRegularJoin() {
        return this.feature == OPER_FEATURE.HASHJOIN;
    }

    public void markRegularJoin() {
        this.feature = OPER_FEATURE.HASHJOIN;
    }

    public boolean needsDistinctCombiner() {
        return this.needsDistinctCombiner;
    }

    public void setNeedsDistinctCombiner(boolean nic) {
        this.needsDistinctCombiner = nic;
    }

    public String getQuantFile() {
        return this.quantFile;
    }

    public void setQuantFile(String quantFile) {
        this.quantFile = quantFile;
    }

    public void setSortOrder(boolean[] sortOrder) {
        if (null == sortOrder) {
            return;
        }
        this.sortOrder = new boolean[sortOrder.length];
        for (int i = 0; i < sortOrder.length; ++i) {
            this.sortOrder[i] = sortOrder[i];
        }
    }

    public void setSecondarySortOrder(boolean[] secondarySortOrder) {
        if (null == secondarySortOrder) {
            return;
        }
        this.secondarySortOrder = new boolean[secondarySortOrder.length];
        for (int i = 0; i < secondarySortOrder.length; ++i) {
            this.secondarySortOrder[i] = secondarySortOrder[i];
        }
    }

    public boolean[] getSortOrder() {
        return this.sortOrder;
    }

    public boolean[] getSecondarySortOrder() {
        return this.secondarySortOrder;
    }

    public boolean isEndOfAllInputSetInMap() {
        return this.endOfAllInputInMap;
    }

    public void setEndOfAllInputInMap(boolean endOfAllInputInMap) {
        this.endOfAllInputInMap = endOfAllInputInMap;
    }

    public boolean isEndOfAllInputSetInReduce() {
        return this.endOfAllInputInReduce;
    }

    public void setEndOfAllInputInReduce(boolean endOfAllInputInReduce) {
        this.endOfAllInputInReduce = endOfAllInputInReduce;
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism;
    }

    public String getCustomPartitioner() {
        return this.customPartitioner;
    }

    public void setSplitter(boolean spl) {
        this.splitter = spl;
    }

    public boolean isSplitter() {
        return this.splitter;
    }

    public boolean getUseSecondaryKey() {
        return this.useSecondaryKey;
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
    }

    protected boolean usingTypedComparator() {
        return this.usingTypedComparator;
    }

    protected void useTypedComparator(boolean useTypedComparator) {
        this.usingTypedComparator = useTypedComparator;
    }

    protected void noCombineSmallSplits() {
        this.combineSmallSplits = false;
    }

    public boolean combineSmallSplits() {
        return this.combineSmallSplits;
    }

    public boolean isRankOperation() {
        return this.getRankOperationId().size() != 0;
    }

    public ArrayList<String> getRankOperationId() {
        ArrayList<String> operationIDs = new ArrayList<String>();
        for (PhysicalOperator operation : this.mapPlan.getRoots()) {
            if (!(operation instanceof PORank)) continue;
            operationIDs.add(((PORank)operation).getOperationID());
        }
        return operationIDs;
    }

    public boolean isCounterOperation() {
        return this.getCounterOperation() != null;
    }

    public boolean isRowNumber() {
        POCounter counter = this.getCounterOperation();
        return counter != null ? counter.isRowNumber() : false;
    }

    public String getOperationID() {
        POCounter counter = this.getCounterOperation();
        return counter != null ? counter.getOperationID() : null;
    }

    private POCounter getCounterOperation() {
        POCounter counter = this.getCounterOperation(this.mapPlan);
        if (counter == null) {
            counter = this.getCounterOperation(this.reducePlan);
        }
        return counter;
    }

    private POCounter getCounterOperation(PhysicalPlan plan) {
        for (PhysicalOperator operator : plan.getLeaves()) {
            List<PhysicalOperator> preds;
            if (operator instanceof POCounter) {
                return (POCounter)operator;
            }
            if (!(operator instanceof POStore) || (preds = plan.getPredecessors(operator)) == null) continue;
            for (PhysicalOperator pred : preds) {
                if (!(pred instanceof POCounter)) continue;
                return (POCounter)pred;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OPER_FEATURE {
        NONE,
        SAMPLER,
        INDEXER,
        GROUPBY,
        COGROUP,
        HASHJOIN;

    }
}

