/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STRSPLITTOBAG
extends EvalFunc<DataBag> {
    private static final BagFactory bagFactory = BagFactory.getInstance();
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (input == null || input.size() < 1) {
            return null;
        }
        try {
            int length;
            String source = (String)input.get(0);
            String delim = input.size() > 1 ? (String)input.get(1) : "\\s";
            int n = length = input.size() > 2 ? (Integer)input.get(2) : 0;
            if (source == null || delim == null) {
                return null;
            }
            String[] splits = source.split(delim, length);
            DataBag dataBag = bagFactory.newDefaultBag();
            for (String eachSplit : splits) {
                Tuple tuple = tupleFactory.newTuple(1);
                tuple.set(0, eachSplit);
                dataBag.add(tuple);
            }
            return dataBag;
        }
        catch (ClassCastException e) {
            this.warn("class cast exception at " + e.getStackTrace()[0], PigWarning.UDF_WARNING_1);
        }
        catch (PatternSyntaxException e) {
            this.warn(e.getMessage(), PigWarning.UDF_WARNING_1);
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 120));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema(new Schema.FieldSchema(null, 55));
        Schema s1 = new Schema();
        s1.add(new Schema.FieldSchema(null, 55));
        s1.add(new Schema.FieldSchema(null, 55));
        Schema s2 = new Schema();
        s2.add(new Schema.FieldSchema(null, 55));
        s2.add(new Schema.FieldSchema(null, 55));
        s2.add(new Schema.FieldSchema(null, 10));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        funcList.add(new FuncSpec(this.getClass().getName(), s1));
        funcList.add(new FuncSpec(this.getClass().getName(), s2));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

