/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.builtin;

import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.ExecType;
import org.apache.pig.ExecTypeProvider;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.BufferedPositionedInputStream;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.streaming.InputHandler;
import org.apache.pig.impl.streaming.OutputHandler;
import org.apache.pig.impl.streaming.PigStreamingUDF;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.streaming.StreamingUDFException;
import org.apache.pig.impl.streaming.StreamingUDFInputHandler;
import org.apache.pig.impl.streaming.StreamingUDFOutputHandler;
import org.apache.pig.impl.streaming.StreamingUDFOutputSchemaException;
import org.apache.pig.impl.streaming.StreamingUtil;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.apache.pig.scripting.ScriptingOutputCapturer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingUDF
extends EvalFunc<Object> {
    private static final Log log = LogFactory.getLog(StreamingUDF.class);
    private static final String PYTHON_CONTROLLER_JAR_PATH = "/python/streaming/controller.py";
    private static final String PYTHON_PIG_UTIL_PATH = "/python/streaming/pig_util.py";
    private static final int UDF_LANGUAGE = 0;
    private static final int PATH_TO_CONTROLLER_FILE = 1;
    private static final int UDF_FILE_NAME = 2;
    private static final int UDF_FILE_PATH = 3;
    private static final int UDF_NAME = 4;
    private static final int PATH_TO_FILE_CACHE = 5;
    private static final int STD_OUT_OUTPUT_PATH = 6;
    private static final int STD_ERR_OUTPUT_PATH = 7;
    private static final int CONTROLLER_LOG_FILE_PATH = 8;
    private static final int IS_ILLUSTRATE = 9;
    private String language;
    private String filePath;
    private String funcName;
    private Schema schema;
    private ExecType execType;
    private String isIllustrate;
    private boolean initialized = false;
    private ScriptingOutputCapturer soc;
    private Process process;
    private ProcessErrorThread stderrThread;
    private ProcessInputThread stdinThread;
    private ProcessOutputThread stdoutThread;
    private InputHandler inputHandler;
    private OutputHandler outputHandler;
    private BlockingQueue<Tuple> inputQueue;
    private BlockingQueue<Object> outputQueue;
    private DataOutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private static final Object ERROR_OUTPUT = new Object();
    private static final Object NULL_OBJECT = new Object();
    private volatile StreamingUDFException outerrThreadsError;
    public static final String TURN_ON_OUTPUT_CAPTURING = "TURN_ON_OUTPUT_CAPTURING";
    private static final int WAIT_FOR_ERROR_LENGTH = 500;
    private static final int MAX_WAIT_FOR_ERROR_ATTEMPTS = 5;

    public StreamingUDF(String language, String filePath, String funcName, String outputSchemaString, String schemaLineNumber, String execType, String isIllustrate) throws StreamingUDFOutputSchemaException, ExecException {
        this.language = language;
        this.filePath = filePath;
        this.funcName = funcName;
        try {
            this.schema = Utils.getSchemaFromString(outputSchemaString);
            this.execType = execType.equals("local") ? ExecType.LOCAL : (execType.equals("mapreduce") ? ExecType.MAPREDUCE : ExecTypeProvider.fromString(execType));
        }
        catch (ParserException pe) {
            throw new StreamingUDFOutputSchemaException(pe.getMessage(), Integer.valueOf(schemaLineNumber));
        }
        catch (IOException ioe) {
            String errorMessage = "Invalid exectype passed to StreamingUDF. Should be local or mapreduce";
            log.error((Object)errorMessage, (Throwable)ioe);
            throw new ExecException(errorMessage, ioe);
        }
        this.isIllustrate = isIllustrate;
    }

    @Override
    public Object exec(Tuple input) throws IOException {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        return this.getOutput(input);
    }

    private void initialize() throws ExecException, IOException {
        this.inputQueue = new ArrayBlockingQueue<Tuple>(1);
        this.outputQueue = new ArrayBlockingQueue<Object>(2);
        this.soc = new ScriptingOutputCapturer(this.execType);
        this.startUdfController();
        this.createInputHandlers();
        this.setStreams();
        this.startThreads();
    }

    private StreamingCommand startUdfController() throws IOException {
        StreamingCommand sc = new StreamingCommand(null, this.constructCommand());
        ProcessBuilder processBuilder = StreamingUtil.createProcess(sc);
        this.process = processBuilder.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new ProcessKiller()));
        return sc;
    }

    private String[] constructCommand() throws IOException {
        String errOutFileName;
        String outFileName;
        String controllerLogFileName;
        String[] command = new String[10];
        Configuration conf = UDFContext.getUDFContext().getJobConf();
        String jarPath = conf.get("mapreduce.job.jar");
        if (jarPath == null) {
            jarPath = conf.get("mapred.jar");
        }
        String jobDir = jarPath != null ? new File(jarPath).getParent() : "";
        String standardOutputRootWriteLocation = this.soc.getStandardOutputRootWriteLocation();
        if (this.execType.isLocal()) {
            controllerLogFileName = standardOutputRootWriteLocation + this.funcName + "_python.log";
            outFileName = standardOutputRootWriteLocation + "cpython_" + this.funcName + "_" + ScriptingOutputCapturer.getRunId() + ".out";
            errOutFileName = standardOutputRootWriteLocation + "cpython_" + this.funcName + "_" + ScriptingOutputCapturer.getRunId() + ".err";
        } else {
            controllerLogFileName = standardOutputRootWriteLocation + this.funcName + "_python.log";
            outFileName = standardOutputRootWriteLocation + this.funcName + ".out";
            errOutFileName = standardOutputRootWriteLocation + this.funcName + ".err";
        }
        this.soc.registerOutputLocation(this.funcName, outFileName);
        command[0] = this.language;
        command[1] = this.getControllerPath(jobDir);
        int lastSeparator = this.filePath.lastIndexOf(File.separator) + 1;
        command[2] = this.filePath.substring(lastSeparator);
        command[3] = lastSeparator <= 0 ? "." : this.filePath.substring(0, lastSeparator - 1);
        command[4] = this.funcName;
        String fileCachePath = jobDir + this.filePath.substring(0, lastSeparator);
        command[5] = "'" + fileCachePath + "'";
        command[6] = outFileName;
        command[7] = errOutFileName;
        command[8] = controllerLogFileName;
        command[9] = this.isIllustrate;
        this.ensureUserFileAvailable(command, fileCachePath);
        return command;
    }

    private void ensureUserFileAvailable(String[] command, String fileCachePath) throws ExecException, IOException {
        File userUdfFile = new File(fileCachePath + command[2] + this.getUserFileExtension());
        if (!userUdfFile.exists()) {
            String absolutePath = this.filePath.startsWith("/") ? this.filePath : "/" + this.filePath;
            absolutePath = absolutePath.replaceAll(":", "");
            String controllerDir = new File(command[1]).getParent();
            String userUdfPath = controllerDir + absolutePath + this.getUserFileExtension();
            userUdfFile = new File(userUdfPath);
            userUdfFile.deleteOnExit();
            userUdfFile.getParentFile().mkdirs();
            if (userUdfFile.exists()) {
                userUdfFile.delete();
                if (!userUdfFile.createNewFile()) {
                    throw new IOException("Unable to create file: " + userUdfFile.getAbsolutePath());
                }
            }
            InputStream udfFileStream = this.getClass().getResourceAsStream(absolutePath + this.getUserFileExtension());
            command[5] = "\"" + userUdfFile.getParentFile().getAbsolutePath() + "\"";
            try {
                FileUtils.copyInputStreamToFile((InputStream)udfFileStream, (File)userUdfFile);
            }
            catch (Exception e) {
                throw new ExecException("Unable to copy user udf file: " + userUdfFile.getName(), e);
            }
            finally {
                udfFileStream.close();
            }
        }
    }

    private String getUserFileExtension() throws ExecException {
        if (this.isPython()) {
            return ".py";
        }
        throw new ExecException("Unrecognized streamingUDF language: " + this.language);
    }

    private void createInputHandlers() throws ExecException, FrontendException {
        PigStreamingUDF serializer = new PigStreamingUDF();
        this.inputHandler = new StreamingUDFInputHandler(serializer);
        PigStreamingUDF deserializer = new PigStreamingUDF(this.schema.getField(0));
        this.outputHandler = new StreamingUDFOutputHandler(deserializer);
    }

    private void setStreams() throws IOException {
        this.stdout = new DataInputStream(new BufferedInputStream(this.process.getInputStream()));
        this.outputHandler.bindTo("", new BufferedPositionedInputStream(this.stdout), 0L, Long.MAX_VALUE);
        this.stdin = new DataOutputStream(new BufferedOutputStream(this.process.getOutputStream()));
        this.inputHandler.bindTo(this.stdin);
        this.stderr = new DataInputStream(new BufferedInputStream(this.process.getErrorStream()));
    }

    private void startThreads() {
        this.stdinThread = new ProcessInputThread();
        this.stdinThread.start();
        this.stdoutThread = new ProcessOutputThread();
        this.stdoutThread.start();
        this.stderrThread = new ProcessErrorThread();
        this.stderrThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getControllerPath(String jarPath) throws IOException {
        if (this.isPython()) {
            String controllerPath = jarPath + PYTHON_CONTROLLER_JAR_PATH;
            File controller = new File(controllerPath);
            if (!controller.exists()) {
                File controllerFile = File.createTempFile("controller", ".py");
                InputStream pythonControllerStream = this.getClass().getResourceAsStream(PYTHON_CONTROLLER_JAR_PATH);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)pythonControllerStream, (File)controllerFile);
                }
                finally {
                    pythonControllerStream.close();
                }
                controllerFile.deleteOnExit();
                File pigUtilFile = new File(controllerFile.getParent() + "/pig_util.py");
                pigUtilFile.deleteOnExit();
                InputStream pythonUtilStream = this.getClass().getResourceAsStream(PYTHON_PIG_UTIL_PATH);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)pythonUtilStream, (File)pigUtilFile);
                }
                finally {
                    pythonUtilStream.close();
                }
                controllerPath = controllerFile.getAbsolutePath();
            }
            return controllerPath;
        }
        throw new ExecException("Invalid language: " + this.language);
    }

    private boolean isPython() {
        return this.language.toLowerCase().startsWith("python");
    }

    private Object getOutput(Tuple input) throws ExecException {
        if (this.outputQueue == null) {
            throw new ExecException("Process has already been shut down.  No way to retrieve output for input: " + input);
        }
        if (ScriptingOutputCapturer.isClassCapturingOutput() && !this.soc.isInstanceCapturingOutput()) {
            Tuple t = TupleFactory.getInstance().newTuple(TURN_ON_OUTPUT_CAPTURING);
            try {
                this.inputQueue.put(t);
            }
            catch (InterruptedException e) {
                throw new ExecException("Failed adding capture input flag to inputQueue");
            }
            this.soc.setInstanceCapturingOutput(true);
        }
        try {
            if (this.getInputSchema() == null || this.getInputSchema().size() == 0) {
                input = TupleFactory.getInstance().newTuple(0);
            }
            this.inputQueue.put(input);
        }
        catch (Exception e) {
            throw new ExecException("Failed adding input to inputQueue", e);
        }
        Object o = null;
        try {
            if (this.outputQueue != null && (o = this.outputQueue.take()) == NULL_OBJECT) {
                o = null;
            }
        }
        catch (Exception e) {
            throw new ExecException("Problem getting output", e);
        }
        if (o == ERROR_OUTPUT) {
            this.outputQueue = null;
            if (this.outerrThreadsError == null) {
                this.outerrThreadsError = new StreamingUDFException(this.language, "Problem with streaming udf.  Can't recreate exception.");
            }
            throw this.outerrThreadsError;
        }
        return o;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return this.schema;
    }

    static /* synthetic */ BlockingQueue access$100(StreamingUDF x0) {
        return x0.inputQueue;
    }

    static /* synthetic */ InputHandler access$200(StreamingUDF x0) {
        return x0.inputHandler;
    }

    static /* synthetic */ DataOutputStream access$300(StreamingUDF x0) {
        return x0.stdin;
    }

    public class ProcessKiller
    implements Runnable {
        public void run() {
            StreamingUDF.this.process.destroy();
        }
    }

    class ProcessErrorThread
    extends Thread {
        public ProcessErrorThread() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                String errInput;
                log.debug((Object)"Starting PET");
                Integer lineNumber = null;
                StringBuffer error = new StringBuffer();
                BufferedReader reader = new BufferedReader(new InputStreamReader(StreamingUDF.this.stderr, Charsets.UTF_8));
                while ((errInput = reader.readLine()) != null) {
                    if (lineNumber == null) {
                        try {
                            lineNumber = Integer.valueOf(errInput);
                        }
                        catch (NumberFormatException nfe) {
                            error.append(errInput + "\n");
                        }
                        continue;
                    }
                    error.append(errInput + "\n");
                }
                StreamingUDF.this.outerrThreadsError = new StreamingUDFException(StreamingUDF.this.language, error.toString(), lineNumber);
                if (StreamingUDF.this.outputQueue != null) {
                    StreamingUDF.this.outputQueue.put(ERROR_OUTPUT);
                }
                if (StreamingUDF.this.stderr != null) {
                    StreamingUDF.this.stderr.close();
                    StreamingUDF.this.stderr = null;
                }
            }
            catch (IOException e) {
                log.debug((Object)"Process Ended", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"standard error problem", (Throwable)e);
            }
        }
    }

    class ProcessOutputThread
    extends Thread {
        ProcessOutputThread() {
            this.setDaemon(true);
        }

        public void run() {
            block9: {
                Object o = null;
                try {
                    log.debug((Object)"Starting POT");
                    o = StreamingUDF.this.outputHandler.getNext().get(0);
                    while (o != OutputHandler.END_OF_OUTPUT) {
                        if (o != null) {
                            StreamingUDF.this.outputQueue.put(o);
                        } else {
                            StreamingUDF.this.outputQueue.put(NULL_OBJECT);
                        }
                        o = StreamingUDF.this.outputHandler.getNext().get(0);
                    }
                }
                catch (Exception e) {
                    if (StreamingUDF.this.outputQueue == null) break block9;
                    try {
                        for (int attempt = 0; StreamingUDF.this.stderrThread.isAlive() && attempt < 5; ++attempt) {
                            Thread.sleep(500L);
                        }
                        if (StreamingUDF.this.outerrThreadsError == null) {
                            StreamingUDF.this.outerrThreadsError = new StreamingUDFException(StreamingUDF.this.language, "Error deserializing output.  Please check that the declared outputSchema for function " + StreamingUDF.this.funcName + " matches the data type being returned.", (Throwable)e);
                        }
                        StreamingUDF.this.outputQueue.put(ERROR_OUTPUT);
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)ie);
                    }
                }
            }
        }
    }

    class ProcessInputThread
    extends Thread {
        ProcessInputThread() {
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                StreamingUDF.access$000().debug((Object)"Starting PIT");
                while (true) lbl-1000:
                // 2 sources

                {
                    inputTuple = (Tuple)StreamingUDF.access$100(StreamingUDF.this).take();
                    StreamingUDF.access$200(StreamingUDF.this).putNext(inputTuple);
                    try {
                        StreamingUDF.access$300(StreamingUDF.this).flush();
                        continue;
                    }
                    catch (Exception e) {
                        return;
                    }
                    break;
                }
            }
            catch (Exception e) {
                StreamingUDF.access$000().error((Object)e);
                return;
            }
            {
                ** while (true)
            }
        }
    }
}

