/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.util.Shell;
import org.apache.pig.builtin.PigStreaming;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingCommand
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    String executable;
    String[] argv;
    List<String> shipSpec = new LinkedList<String>();
    List<String> cacheSpec = new LinkedList<String>();
    Map<Handle, List<HandleSpec>> handleSpecs = new TreeMap<Handle, List<HandleSpec>>();
    boolean persistStderr = false;
    String logDir;
    int logFilesLimit = 100;
    public static final int MAX_TASKS = 100;
    boolean shipFiles = true;
    private PigContext pigContext;

    public StreamingCommand(PigContext pigContext, String[] argv) {
        this.pigContext = pigContext;
        this.argv = argv;
        this.executable = this.argv[0];
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setCommandArgs(String[] argv) {
        this.argv = argv;
    }

    public String[] getCommandArgs() {
        return this.argv;
    }

    public List<String> getShipSpecs() {
        return this.shipSpec;
    }

    public List<String> getCacheSpecs() {
        return this.cacheSpec;
    }

    public void addPathToShip(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Invalid ship specification: '" + path + "' does not exist!");
        }
        if (file.isDirectory()) {
            throw new IOException("Invalid ship specification: '" + path + "' is a directory and can't be shipped!");
        }
        this.shipSpec.add(path);
    }

    public void addPathToCache(String path) throws IOException {
        URI pathUri = null;
        URI dfsPath = null;
        try {
            if (Shell.WINDOWS) {
                path = path.replaceAll("\\\\", "/");
            }
            pathUri = new URI(path);
            dfsPath = new URI(pathUri.getScheme(), pathUri.getAuthority(), pathUri.getPath(), null, null);
        }
        catch (URISyntaxException urise) {
            throw new IOException("Invalid cache specification: " + path);
        }
        boolean exists = false;
        try {
            exists = FileLocalizer.fileExists(dfsPath.toString(), this.pigContext);
        }
        catch (IOException ioe) {
            throw new IOException("Invalid cache specification: '" + dfsPath + "' does not exist!");
        }
        if (!exists) {
            throw new IOException("Invalid cache specification: '" + dfsPath + "' does not exist!");
        }
        if (FileLocalizer.isDirectory(dfsPath.toString(), this.pigContext)) {
            throw new IOException("Invalid cache specification: '" + dfsPath + "' is a directory and can't be cached!");
        }
        this.cacheSpec.add(path);
    }

    public void addHandleSpec(Handle handle, HandleSpec handleSpec) {
        List<HandleSpec> handleSpecList = this.handleSpecs.get((Object)handle);
        if (handleSpecList == null) {
            handleSpecList = new LinkedList<HandleSpec>();
            this.handleSpecs.put(handle, handleSpecList);
        }
        handleSpecList.add(handleSpec);
    }

    public void setInputSpec(HandleSpec spec) {
        List<HandleSpec> inputSpecs = this.getHandleSpecs(Handle.INPUT);
        if (inputSpecs == null || inputSpecs.size() == 0) {
            this.addHandleSpec(Handle.INPUT, spec);
        } else {
            inputSpecs.set(0, spec);
        }
    }

    public HandleSpec getInputSpec() {
        List<HandleSpec> inputSpecs = this.getHandleSpecs(Handle.INPUT);
        if (inputSpecs == null || inputSpecs.size() == 0) {
            this.addHandleSpec(Handle.INPUT, new HandleSpec("stdin", PigStreaming.class.getName()));
        }
        return this.getHandleSpecs(Handle.INPUT).get(0);
    }

    public void setOutputSpec(HandleSpec spec) {
        List<HandleSpec> outputSpecs = this.getHandleSpecs(Handle.OUTPUT);
        if (outputSpecs == null || outputSpecs.size() == 0) {
            this.addHandleSpec(Handle.OUTPUT, spec);
        } else {
            outputSpecs.set(0, spec);
        }
    }

    public HandleSpec getOutputSpec() {
        List<HandleSpec> outputSpecs = this.getHandleSpecs(Handle.OUTPUT);
        if (outputSpecs == null || outputSpecs.size() == 0) {
            this.addHandleSpec(Handle.OUTPUT, new HandleSpec("stdout", PigStreaming.class.getName()));
        }
        return this.getHandleSpecs(Handle.OUTPUT).get(0);
    }

    public List<HandleSpec> getHandleSpecs(Handle handle) {
        return this.handleSpecs.get((Object)handle);
    }

    public boolean getPersistStderr() {
        return this.persistStderr;
    }

    public void setPersistStderr(boolean persistStderr) {
        this.persistStderr = persistStderr;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
        if (this.logDir.startsWith("/")) {
            this.logDir = this.logDir.substring(1);
        }
        this.setPersistStderr(true);
    }

    public int getLogFilesLimit() {
        return this.logFilesLimit;
    }

    public void setLogFilesLimit(int logFilesLimit) {
        this.logFilesLimit = Math.min(100, logFilesLimit);
    }

    public void setShipFiles(boolean shipFiles) {
        this.shipFiles = shipFiles;
    }

    public boolean getShipFiles() {
        return this.shipFiles;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String arg : this.getCommandArgs()) {
            sb.append(arg);
            sb.append(" ");
        }
        sb.append("(" + this.getInputSpec().toString() + "/" + this.getOutputSpec() + ")");
        return sb.toString();
    }

    public Object clone() {
        try {
            StreamingCommand clone = (StreamingCommand)super.clone();
            clone.shipSpec = new ArrayList<String>(this.shipSpec);
            clone.cacheSpec = new ArrayList<String>(this.cacheSpec);
            clone.handleSpecs = new HashMap<Handle, List<HandleSpec>>();
            for (Map.Entry<Handle, List<HandleSpec>> e : this.handleSpecs.entrySet()) {
                ArrayList<HandleSpec> values = new ArrayList<HandleSpec>();
                for (HandleSpec spec : e.getValue()) {
                    values.add((HandleSpec)spec.clone());
                }
                clone.handleSpecs.put(e.getKey(), values);
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HandleSpec
    implements Comparable<HandleSpec>,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        String name;
        String spec;

        public HandleSpec(String handleName) {
            this(handleName, PigStreaming.class.getName());
        }

        public HandleSpec(String handleName, String spec) {
            this.name = handleName;
            this.spec = spec;
        }

        @Override
        public int compareTo(HandleSpec o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return this.name + "-" + this.spec;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSpec() {
            return this.spec;
        }

        public void setSpec(String spec) {
            this.spec = spec;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HandleSpec) {
                HandleSpec other = (HandleSpec)obj;
                return other != null && this.name.equals(other.name) && this.spec.equals(other.spec);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new InternalError(cnse.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Handle {
        INPUT,
        OUTPUT;

    }
}

