/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");

    public static boolean isAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.AUTHORIZATION);
    }

    public static boolean isCellAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_AUTHORIZATION);
    }

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(Table ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
        return protocol;
    }

    public static void grant(Connection connection, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(table), userName, tableName, family, qual, actions);
        }
    }

    public static void grant(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void grant(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant(AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    public static boolean isAccessControllerRunning(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        try (Admin admin = connection.getAdmin();){
            boolean bl = admin.isTableAvailable(ACL_TABLE_NAME);
            return bl;
        }
    }

    public static void revoke(Connection connection, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(table), username, tableName, family, qualifier, actions);
        }
    }

    public static void revoke(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void revoke(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke(AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex) throws Throwable {
        List<Object> permList = new ArrayList();
        try (Table table = connection.getTable(ACL_TABLE_NAME);
             Admin admin = connection.getAdmin();){
            CoprocessorRpcChannel service = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            HTableDescriptor[] htds = null;
            if (tableRegex == null || tableRegex.isEmpty()) {
                permList = ProtobufUtil.getUserPermissions(protocol);
            } else if (tableRegex.charAt(0) == '@') {
                String namespace = tableRegex.substring(1);
                permList = ProtobufUtil.getUserPermissions(protocol, Bytes.toBytes((String)namespace));
            } else {
                for (HTableDescriptor hd : htds = admin.listTables(Pattern.compile(tableRegex), true)) {
                    permList.addAll(ProtobufUtil.getUserPermissions(protocol, hd.getTableName()));
                }
            }
        }
        return permList;
    }

    @Deprecated
    public static void grant(Configuration conf, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.grant(connection, tableName, userName, family, qual, actions);
        }
    }

    @Deprecated
    public static void grant(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.grant(connection, namespace, userName, actions);
        }
    }

    @Deprecated
    public static void grant(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.grant(connection, userName, actions);
        }
    }

    @Deprecated
    public static boolean isAccessControllerRunning(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            boolean bl = AccessControlClient.isAccessControllerRunning(connection);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static AccessControlProtos.GrantResponse grant(Configuration conf, final TableName tableName, final String userName, final byte[] family, final byte[] qual, final AccessControlProtos.Permission.Action ... actions) throws Throwable {
        try (HTable ht = null;){
            TableName aclTableName = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
            ht = new HTable(conf, aclTableName.getName());
            Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.GrantResponse> callable = new Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.GrantResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AccessControlProtos.GrantResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public AccessControlProtos.GrantResponse call(AccessControlProtos.AccessControlService service) throws IOException {
                    AccessControlProtos.GrantRequest.Builder builder = AccessControlProtos.GrantRequest.newBuilder();
                    AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
                    AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
                    for (AccessControlProtos.Permission.Action a : actions) {
                        permissionBuilder.addAction(a);
                    }
                    permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
                    if (family != null) {
                        permissionBuilder.setFamily(ByteStringer.wrap((byte[])family));
                    }
                    if (qual != null) {
                        permissionBuilder.setQualifier(ByteStringer.wrap((byte[])qual));
                    }
                    ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
                    builder.setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)userName)).setPermission(ret));
                    service.grant((RpcController)this.controller, builder.build(), this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], AccessControlProtos.GrantResponse> result = ht.coprocessorService(AccessControlProtos.AccessControlService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            AccessControlProtos.GrantResponse grantResponse = result.values().iterator().next();
            return grantResponse;
        }
    }

    @Deprecated
    public static void revoke(Configuration conf, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.revoke(connection, tableName, username, family, qualifier, actions);
        }
    }

    @Deprecated
    public static void revoke(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.revoke(connection, namespace, userName, actions);
        }
    }

    @Deprecated
    public static void revoke(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.revoke(connection, userName, actions);
        }
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(Configuration conf, String tableRegex) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            List<UserPermission> list = AccessControlClient.getUserPermissions(connection, tableRegex);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static AccessControlProtos.RevokeResponse revoke(Configuration conf, final String username, final TableName tableName, final byte[] family, final byte[] qualifier, final AccessControlProtos.Permission.Action ... actions) throws Throwable {
        try (HTable ht = null;){
            TableName aclTableName = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");
            ht = new HTable(conf, aclTableName.getName());
            Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.RevokeResponse> callable = new Batch.Call<AccessControlProtos.AccessControlService, AccessControlProtos.RevokeResponse>(){
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<AccessControlProtos.RevokeResponse> rpcCallback = new BlockingRpcCallback();

                @Override
                public AccessControlProtos.RevokeResponse call(AccessControlProtos.AccessControlService service) throws IOException {
                    AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
                    AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
                    for (AccessControlProtos.Permission.Action a : actions) {
                        permissionBuilder.addAction(a);
                    }
                    if (tableName != null) {
                        permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
                    }
                    if (family != null) {
                        permissionBuilder.setFamily(ByteStringer.wrap((byte[])family));
                    }
                    if (qualifier != null) {
                        permissionBuilder.setQualifier(ByteStringer.wrap((byte[])qualifier));
                    }
                    ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
                    AccessControlProtos.RevokeRequest builder = AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
                    service.revoke((RpcController)this.controller, builder, this.rpcCallback);
                    return this.rpcCallback.get();
                }
            };
            Map<byte[], AccessControlProtos.RevokeResponse> result = ht.coprocessorService(AccessControlProtos.AccessControlService.class, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, callable);
            AccessControlProtos.RevokeResponse revokeResponse = result.values().iterator().next();
            return revokeResponse;
        }
    }
}

