/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.i18n.webservice;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Provider
@Produces(value={"application/xml", "application/json"})
public class ResourceBundleMessageBodyWriter
implements MessageBodyWriter<ResourceBundle> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ResourceBundle.class.isAssignableFrom(type) && (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType) || MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType));
    }

    public long getSize(ResourceBundle resourceBundle, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(ResourceBundle resourceBundle, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            JSONObject resourceBundleJsonObject = new JSONObject();
            for (String key : Collections.list(resourceBundle.getKeys())) {
                resourceBundleJsonObject.put((Object)key, (Object)resourceBundle.getString(key));
            }
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(entityStream);
                resourceBundleJsonObject.writeJSONString((Writer)outputStreamWriter);
            }
            finally {
                if (outputStreamWriter != null) {
                    outputStreamWriter.flush();
                }
            }
        }
        if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType)) {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element propertiesNode = document.createElement("properties");
                document.appendChild(propertiesNode);
                for (String key : Collections.list(resourceBundle.getKeys())) {
                    Element propertyNode = document.createElement("property");
                    propertiesNode.appendChild(propertyNode);
                    Element keyNode = document.createElement("key");
                    keyNode.setTextContent(key);
                    propertyNode.appendChild(keyNode);
                    Element valueNode = document.createElement("value");
                    valueNode.setTextContent(resourceBundle.getString(key));
                    propertyNode.appendChild(valueNode);
                }
                StreamResult output = new StreamResult(entityStream);
                DOMSource input = new DOMSource(document);
                try {
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    transformer.transform(input, output);
                }
                catch (TransformerException e) {
                    throw new IOException(e);
                }
            }
            catch (ParserConfigurationException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
}

