/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.hbase.factory;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapred.Table9xInputFormatDiscloser;
import org.pentaho.hadoop.hbase.factory.HBase9xAdmin;
import org.pentaho.hadoop.hbase.factory.HBase9xPut;
import org.pentaho.hadoop.hbase.factory.HBase9xTable;
import org.pentaho.hbase.factory.HBaseAdmin;
import org.pentaho.hbase.factory.HBaseClientFactory;
import org.pentaho.hbase.factory.HBaseClientFactoryLocator;
import org.pentaho.hbase.factory.HBasePut;
import org.pentaho.hbase.factory.HBaseTable;
import org.pentaho.hbase.mapred.PentahoTableInputFormat;
import org.pentaho.hbase.mapred.PentahoTableRecordReader;

class HBase9xClientFactory
implements HBaseClientFactory {
    private final Configuration conf;

    HBase9xClientFactory(Configuration conf) throws Exception {
        this.conf = conf;
    }

    @Override
    public HBaseTable getHBaseTable(String tableName) {
        try {
            return new HBase9xTable(this.conf, tableName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public HBaseAdmin getHBaseAdmin() {
        try {
            return new HBase9xAdmin(this.conf);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public HTableDescriptor getHBaseTableDescriptor(String tableName) {
        return new HTableDescriptor(tableName);
    }

    @Override
    public HBaseTable wrap(Object tableObject) {
        if (tableObject == null) {
            throw new NullPointerException("null as a table was passed");
        }
        HTable tab = null;
        if (tableObject instanceof HTable) {
            tab = (HTable)tableObject;
            return new HBase9xTable(tab);
        }
        throw new IllegalArgumentException("Type mismatch:" + HTable.class.getCanonicalName() + " was expected");
    }

    @Override
    public PentahoTableInputFormat getTableInputFormatImpl(final PentahoTableInputFormat common, Configuration conf) {
        return new PentahoTableInputFormat(){
            Table9xInputFormatDiscloser invoker;
            {
                this.invoker = new Table9xInputFormatDiscloser(common);
            }

            @Override
            protected void setHBaseTable(Configuration conf, String tableName) throws IOException {
                this.invoker.setHTable(new HTable(conf, tableName));
            }

            @Override
            protected boolean checkHBaseTable() {
                return this.invoker.getHTable() != null;
            }

            @Override
            protected PentahoTableRecordReader createRecordReader(final Configuration config) {
                return new PentahoTableRecordReader(){

                    public void setHTable(HTable table) {
                        HBaseClientFactory hbcf = HBaseClientFactoryLocator.getHBaseClientFactory(config);
                        this.getImpl().setHTable(hbcf.wrap(table));
                    }
                };
            }
        };
    }

    @Override
    public HBasePut getHBasePut(byte[] key) {
        return new HBase9xPut(key);
    }
}

