/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.function;

import java.io.Serializable;
import java.util.SortedMap;
import javolution.lang.Immutable;
import org.jscience.mathematics.structure.Field;

public interface Interpolator<P, V>
extends Immutable,
Serializable {
    public V interpolate(P var1, SortedMap<P, V> var2);

    public static class Linear<F extends Field<F>>
    implements Interpolator<F, F> {
        private static final long serialVersionUID = 1L;

        @Override
        public F interpolate(F point, SortedMap<F, F> pointValues) {
            Field y = (Field)pointValues.get(point);
            if (y != null) {
                return (F)y;
            }
            SortedMap<F, F> headMap = pointValues.headMap(point);
            Field x1 = (Field)headMap.lastKey();
            Field y1 = (Field)headMap.get(x1);
            SortedMap<F, F> tailMap = pointValues.tailMap(point);
            Field x2 = (Field)tailMap.firstKey();
            Field y2 = (Field)tailMap.get(x2);
            F x = point;
            Field deltaInv = (Field)((Field)x2.plus(x1.opposite())).inverse();
            Field k1 = ((Field)x2.plus(x.opposite())).times(deltaInv);
            Field k2 = ((Field)x.plus(x1.opposite())).times(deltaInv);
            return (F)y1.times(k1).plus(y2.times(k2));
        }
    }
}

