/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastTable;
import org.jscience.mathematics.number.Complex;
import org.jscience.mathematics.vector.ComplexVector;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.Vector;

public final class ComplexMatrix
extends Matrix<Complex> {
    int _n;
    boolean _transposed;
    final FastTable<ComplexVector> _rows = new FastTable();
    private static ObjectFactory<ComplexMatrix> FACTORY = new ObjectFactory<ComplexMatrix>(){

        @Override
        protected ComplexMatrix create() {
            return new ComplexMatrix();
        }
    };
    private static final long serialVersionUID = 1L;

    public static ComplexMatrix valueOf(Complex[][] elements) {
        int m = elements.length;
        int n = elements[0].length;
        ComplexMatrix M = ComplexMatrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            ComplexVector row = ComplexVector.valueOf(elements[i]);
            if (row.getDimension() != n) {
                throw new DimensionException();
            }
            M._rows.add(row);
        }
        return M;
    }

    public static ComplexMatrix valueOf(ComplexVector ... rows) {
        int n = rows[0].getDimension();
        ComplexMatrix M = ComplexMatrix.newInstance(n, false);
        for (ComplexVector rowi : rows) {
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static ComplexMatrix valueOf(List<ComplexVector> rows) {
        int n = rows.get(0).getDimension();
        ComplexMatrix M = ComplexMatrix.newInstance(n, false);
        Iterator<ComplexVector> iterator = rows.iterator();
        int m = rows.size();
        for (int i = 0; i < m; ++i) {
            ComplexVector rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            M._rows.add(rowi);
        }
        return M;
    }

    public static ComplexMatrix valueOf(Matrix<Complex> that) {
        if (that instanceof ComplexMatrix) {
            return (ComplexMatrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        ComplexMatrix M = ComplexMatrix.newInstance(n, false);
        for (int i = 0; i < m; ++i) {
            ComplexVector rowi = ComplexVector.valueOf(that.getRow(i));
            M._rows.add(rowi);
        }
        return M;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public Complex get(int i, int j) {
        return this._transposed ? this._rows.get(j).get(i) : this._rows.get(i).get(j);
    }

    public ComplexVector getRow(int i) {
        if (!this._transposed) {
            return this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        ComplexVector V = ComplexVector.newInstance(n);
        for (int j = 0; j < n; ++j) {
            V.set(j, this._rows.get(j).get(i));
        }
        return V;
    }

    public ComplexVector getColumn(int j) {
        if (this._transposed) {
            return this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        ComplexVector V = ComplexVector.newInstance(m);
        for (int i = 0; i < m; ++i) {
            V.set(i, this._rows.get(i).get(j));
        }
        return V;
    }

    public ComplexVector getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min(m, n);
        ComplexVector V = ComplexVector.newInstance(dimension);
        for (int i = 0; i < dimension; ++i) {
            V.set(i, this.get(i, i));
        }
        return V;
    }

    @Override
    public ComplexMatrix opposite() {
        ComplexMatrix M = ComplexMatrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add(this._rows.get(i).opposite());
        }
        return M;
    }

    @Override
    public ComplexMatrix plus(Matrix<Complex> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        ComplexMatrix M = ComplexMatrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add((ComplexVector)this._rows.get(i).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
        }
        return M;
    }

    public ComplexMatrix minus(Matrix<Complex> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public ComplexMatrix times(Complex k) {
        ComplexMatrix M = ComplexMatrix.newInstance(this._n, this._transposed);
        int p = this._rows.size();
        for (int i = 0; i < p; ++i) {
            M._rows.add(this._rows.get(i).times(k));
        }
        return M;
    }

    @Override
    public ComplexVector times(Vector<Complex> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        ComplexVector V = ComplexVector.newInstance(m);
        for (int i = 0; i < m; ++i) {
            V.set(i, (Complex)this.getRow(i).times((Vector)v));
        }
        return V;
    }

    @Override
    public ComplexMatrix times(Matrix<Complex> that) {
        int n = this.getNumberOfColumns();
        int m = this.getNumberOfRows();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        ComplexMatrix M = ComplexMatrix.newInstance(m, true);
        M._rows.setSize(p);
        Multiply multiply = Multiply.valueOf(this, that, 0, p, M._rows);
        multiply.run();
        Multiply.recycle(multiply);
        return M;
    }

    private FastTable<ComplexVector> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable<ComplexVector> rows = FastTable.newInstance();
        for (int i = 0; i < this._n; ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    public ComplexMatrix inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        return ComplexMatrix.valueOf(LUDecomposition.valueOf(this).inverse());
    }

    @Override
    public Complex determinant() {
        return LUDecomposition.valueOf(this).determinant();
    }

    public ComplexMatrix transpose() {
        ComplexMatrix M = ComplexMatrix.newInstance(this._n, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public Complex cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        ComplexMatrix M = ComplexMatrix.newInstance(m - 1, this._transposed);
        for (int k1 = 0; k1 < m; ++k1) {
            if (k1 == i) continue;
            ComplexVector row = this._rows.get(k1);
            ComplexVector V = ComplexVector.newInstance(this._n - 1);
            M._rows.add(V);
            int k = 0;
            for (int k2 = 0; k2 < this._n; ++k2) {
                if (k2 == j) continue;
                V.set(k++, row.get(k2));
            }
        }
        return M.determinant();
    }

    public ComplexMatrix adjoint() {
        ComplexMatrix M = ComplexMatrix.newInstance(this._n, this._transposed);
        int m = this._rows.size();
        for (int i = 0; i < m; ++i) {
            ComplexVector row = ComplexVector.newInstance(this._n);
            M._rows.add(row);
            for (int j = 0; j < this._n; ++j) {
                Complex cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                row.set(j, (i + j) % 2 == 0 ? cofactor : cofactor.opposite());
            }
        }
        return M.transpose();
    }

    public ComplexMatrix tensor(Matrix<Complex> that) {
        return ComplexMatrix.valueOf(DenseMatrix.valueOf(this).tensor(that));
    }

    public ComplexVector vectorization() {
        return ComplexVector.valueOf(DenseMatrix.valueOf(this).vectorization());
    }

    @Override
    public ComplexMatrix copy() {
        ComplexMatrix M = ComplexMatrix.newInstance(this._n, this._transposed);
        for (ComplexVector row : this._rows) {
            M._rows.add(row.copy());
        }
        return M;
    }

    static ComplexMatrix newInstance(int n, boolean transposed) {
        ComplexMatrix M = FACTORY.object();
        M._rows.clear();
        M._n = n;
        M._transposed = transposed;
        return M;
    }

    private ComplexMatrix() {
    }

    private static class Multiply
    implements Runnable {
        private static final ObjectFactory<Multiply> FACTORY = new ObjectFactory<Multiply>(){

            @Override
            protected Multiply create() {
                return new Multiply();
            }
        };
        private ComplexMatrix _left;
        private Matrix<Complex> _right;
        private int _rightColumnStart;
        private int _rightColumnEnd;
        private FastTable<ComplexVector> _columnsResult;

        private Multiply() {
        }

        static Multiply valueOf(ComplexMatrix left, Matrix<Complex> right, int rightColumnStart, int rightColumnEnd, FastTable<ComplexVector> columnsResult) {
            Multiply multiply = FACTORY.object();
            multiply._left = left;
            multiply._right = right;
            multiply._rightColumnStart = rightColumnStart;
            multiply._rightColumnEnd = rightColumnEnd;
            multiply._columnsResult = columnsResult;
            return multiply;
        }

        static void recycle(Multiply multiply) {
            multiply._left = null;
            multiply._right = null;
            multiply._columnsResult = null;
            FACTORY.recycle(multiply);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this._rightColumnEnd - this._rightColumnStart < 32) {
                FastTable rows = this._left.getRows();
                int m = rows.size();
                for (int j = this._rightColumnStart; j < this._rightColumnEnd; ++j) {
                    Vector<Complex> thatColj = this._right.getColumn(j);
                    ComplexVector column = ComplexVector.newInstance(m);
                    this._columnsResult.set(j, column);
                    for (int i = 0; i < m; ++i) {
                        column.set(i, (Complex)((ComplexVector)rows.get(i)).times((Vector)thatColj));
                    }
                }
            } else {
                int halfIndex = this._rightColumnStart + this._rightColumnEnd >> 1;
                Multiply firstHalf = Multiply.valueOf(this._left, this._right, this._rightColumnStart, halfIndex, this._columnsResult);
                Multiply secondHalf = Multiply.valueOf(this._left, this._right, halfIndex, this._rightColumnEnd, this._columnsResult);
                ConcurrentContext.enter();
                try {
                    ConcurrentContext.execute(firstHalf);
                    ConcurrentContext.execute(secondHalf);
                }
                finally {
                    ConcurrentContext.exit();
                }
                Multiply.recycle(firstHalf);
                Multiply.recycle(secondHalf);
            }
        }
    }
}

