/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHResourceBundleDataCache;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache.EHResourceFactoryCache;

public class EHCacheProvider
implements ResourceDataCacheProvider,
ResourceFactoryCacheProvider,
ResourceBundleDataCacheProvider {
    private static CacheManager cacheManager;
    private static final String DATA_CACHE_NAME = "libloader-data";
    private static final String BUNDLES_CACHE_NAME = "libloader-bundles";
    private static final String FACTORY_CACHE_NAME = "libloader-factory";
    private static final Log logger;

    public static synchronized CacheManager getCacheManager() throws CacheException {
        if (cacheManager == null) {
            cacheManager = CacheManager.getInstance();
        }
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceDataCache createDataCache() {
        try {
            CacheManager manager;
            CacheManager cacheManager = manager = EHCacheProvider.getCacheManager();
            synchronized (cacheManager) {
                if (!manager.cacheExists(DATA_CACHE_NAME)) {
                    Cache libloaderCache = new Cache(DATA_CACHE_NAME, 500, false, false, 600L, 600L, false, 120L);
                    manager.addCache(libloaderCache);
                    return new EHResourceDataCache(libloaderCache);
                }
                return new EHResourceDataCache(manager.getCache(DATA_CACHE_NAME));
            }
        }
        catch (CacheException e) {
            logger.debug((Object)"Failed to create EHCache libloader-data cache", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundleDataCache createBundleDataCache() {
        try {
            CacheManager manager;
            CacheManager cacheManager = manager = EHCacheProvider.getCacheManager();
            synchronized (cacheManager) {
                if (!manager.cacheExists(BUNDLES_CACHE_NAME)) {
                    Cache libloaderCache = new Cache(BUNDLES_CACHE_NAME, 500, false, false, 600L, 600L, false, 120L);
                    manager.addCache(libloaderCache);
                    return new EHResourceBundleDataCache(libloaderCache);
                }
                return new EHResourceBundleDataCache(manager.getCache(BUNDLES_CACHE_NAME));
            }
        }
        catch (CacheException e) {
            logger.debug((Object)"Failed to create EHCache libloader-bundles cache", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceFactoryCache createFactoryCache() {
        try {
            CacheManager manager;
            CacheManager cacheManager = manager = EHCacheProvider.getCacheManager();
            synchronized (cacheManager) {
                if (!manager.cacheExists(FACTORY_CACHE_NAME)) {
                    Cache libloaderCache = new Cache(FACTORY_CACHE_NAME, 500, false, false, 600L, 600L, false, 120L);
                    manager.addCache(libloaderCache);
                    return new EHResourceFactoryCache(libloaderCache);
                }
                return new EHResourceFactoryCache(manager.getCache(FACTORY_CACHE_NAME));
            }
        }
        catch (CacheException e) {
            logger.debug((Object)"Failed to create EHCache libloader-factory cache", (Throwable)e);
            return null;
        }
    }

    static {
        logger = LogFactory.getLog(EHCacheProvider.class);
    }
}

