/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.caching.api.PentahoCacheTemplateConfiguration;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceAlreadyExistsException;
import org.pentaho.di.trans.dataservice.serialization.DataServiceReferenceSynchronizer;
import org.pentaho.di.trans.dataservice.serialization.EmbeddedMetaStoreFactory;
import org.pentaho.di.trans.dataservice.serialization.ServiceTrans;
import org.pentaho.di.trans.dataservice.serialization.UndefinedDataServiceException;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;

public class DataServiceMetaStoreUtil {
    private static final Class<DataServiceMetaStoreUtil> PKG = DataServiceMetaStoreUtil.class;
    private static final HashFunction hashFunction = Hashing.goodFastHash((int)32);
    private final Cache<Integer, String> stepCache;
    protected final DataServiceContext context;

    protected DataServiceMetaStoreUtil(DataServiceContext context, Cache<Integer, String> cache) {
        this.context = context;
        this.stepCache = cache;
    }

    protected DataServiceMetaStoreUtil(DataServiceMetaStoreUtil metaStoreUtil) {
        this(metaStoreUtil.getContext(), metaStoreUtil.getStepCache());
    }

    public static DataServiceMetaStoreUtil create(DataServiceContext context) {
        return new DataServiceMetaStoreUtil(context, DataServiceMetaStoreUtil.initCache(context.getCacheManager()));
    }

    private static Cache<Integer, String> initCache(PentahoCacheManager cacheManager) {
        String name = DataServiceMetaStoreUtil.class.getName() + UUID.randomUUID().toString();
        PentahoCacheTemplateConfiguration template = (PentahoCacheTemplateConfiguration)cacheManager.getTemplates().get("default");
        return template.createCache(name, Integer.class, String.class);
    }

    public DataServiceMeta getDataService(String serviceName, Repository repository, IMetaStore metaStore) throws MetaStoreException {
        ServiceTrans transReference = (ServiceTrans)this.getServiceTransFactory(metaStore).loadElement(serviceName);
        if (transReference == null) {
            throw new MetaStoreException(MessageFormat.format("Data Service {0} not found", serviceName));
        }
        final AtomicReference loadException = new AtomicReference();
        Optional transMeta = FluentIterable.from(transReference.getReferences()).transform(this.createTransMetaLoader(repository, new Function<Exception, Void>(){

            public Void apply(Exception e) {
                loadException.compareAndSet(null, e);
                return null;
            }
        })).transform(Suppliers.supplierFunction()).firstMatch(Predicates.notNull());
        if (transMeta.isPresent()) {
            return this.getDataService(serviceName, (TransMeta)transMeta.get());
        }
        throw new MetaStoreException(MessageFormat.format("Failed to load Data Service {0}", serviceName), (Throwable)loadException.get());
    }

    public DataServiceMeta getDataService(String serviceName, TransMeta serviceTrans) throws MetaStoreException {
        DataServiceMeta dataServiceMeta = (DataServiceMeta)this.getDataServiceFactory(serviceTrans).loadElement(serviceName);
        if (dataServiceMeta == null) {
            throw new MetaStoreException(MessageFormat.format("Data Service {0} not found in transformation {1}", serviceName, serviceTrans.getName()));
        }
        return dataServiceMeta;
    }

    public Iterable<DataServiceMeta> getDataServices(Repository repository, IMetaStore metaStore, Function<Exception, Void> exceptionHandler) {
        List<ServiceTrans> serviceTransList;
        MetaStoreFactory<ServiceTrans> serviceTransFactory = this.getServiceTransFactory(metaStore);
        try {
            serviceTransList = serviceTransFactory.getElements();
        }
        catch (Exception e) {
            exceptionHandler.apply((Object)e);
            serviceTransList = Collections.emptyList();
        }
        ImmutableMap transMetaMap = FluentIterable.from((Iterable)serviceTransList).transformAndConcat((Function)new Function<ServiceTrans, Iterable<ServiceTrans.Reference>>(){

            public Iterable<ServiceTrans.Reference> apply(ServiceTrans serviceTrans) {
                return serviceTrans.getReferences();
            }
        }).toMap(this.createTransMetaLoader(repository, exceptionHandler));
        ArrayList dataServices = Lists.newArrayListWithExpectedSize((int)serviceTransList.size());
        for (ServiceTrans serviceTrans : serviceTransList) {
            Optional transMeta = FluentIterable.from(serviceTrans.getReferences()).transform(Functions.forMap((Map)transMetaMap)).transform(Suppliers.supplierFunction()).firstMatch(Predicates.notNull());
            if (transMeta.isPresent()) {
                try {
                    dataServices.add(this.getDataService(serviceTrans.getName(), (TransMeta)transMeta.get()));
                }
                catch (Exception e) {
                    exceptionHandler.apply((Object)e);
                }
                continue;
            }
            try {
                if (PentahoSessionHolder.getSession() == null || !((Boolean)SecurityHelper.getInstance().runAsSystem(() -> !ServiceTrans.isValid(repository).apply((Object)serviceTrans))).booleanValue()) continue;
                serviceTransFactory.deleteElement(serviceTrans.getName());
            }
            catch (Exception e) {
                exceptionHandler.apply((Object)e);
            }
        }
        return dataServices;
    }

    private Function<ServiceTrans.Reference, Supplier<TransMeta>> createTransMetaLoader(final Repository repository, final Function<? super Exception, ?> exceptionHandler) {
        return new Function<ServiceTrans.Reference, Supplier<TransMeta>>(){

            public Supplier<TransMeta> apply(final ServiceTrans.Reference reference) {
                return Suppliers.memoize((Supplier)new Supplier<TransMeta>(){

                    public TransMeta get() {
                        try {
                            return reference.load(repository);
                        }
                        catch (KettleException e) {
                            exceptionHandler.apply((Object)e);
                            return null;
                        }
                    }
                });
            }
        };
    }

    public Iterable<DataServiceMeta> getDataServices(TransMeta transMeta) {
        try {
            return this.getDataServiceFactory(transMeta).getElements();
        }
        catch (MetaStoreException e) {
            this.getLogChannel().logError("Unable to list data services for " + transMeta.getName(), (Throwable)e);
            return ImmutableList.of();
        }
    }

    public List<String> getDataServiceNames(TransMeta transMeta) throws MetaStoreException {
        return this.getDataServiceFactory(transMeta).getElementNames();
    }

    public List<String> getDataServiceNames(IMetaStore metaStore) throws MetaStoreException {
        return this.getServiceTransFactory(metaStore).getElementNames();
    }

    public DataServiceMeta getDataServiceByStepName(TransMeta transMeta, String stepName) {
        Set<Integer> cacheKeys = DataServiceMetaStoreUtil.createCacheKeys(transMeta, stepName);
        for (Map.Entry entry : this.stepCache.getAll(cacheKeys).entrySet()) {
            DataServiceMeta dataServiceMeta;
            String serviceName = (String)entry.getValue();
            if (serviceName.isEmpty()) {
                return null;
            }
            try {
                dataServiceMeta = this.getDataService(serviceName, transMeta);
            }
            catch (MetaStoreException e) {
                dataServiceMeta = null;
            }
            if (dataServiceMeta != null && dataServiceMeta.getStepname().equals(stepName)) {
                return dataServiceMeta;
            }
            this.stepCache.remove(entry.getKey(), (Object)serviceName);
        }
        for (DataServiceMeta dataServiceMeta : this.getDataServices(transMeta)) {
            if (!dataServiceMeta.getStepname().equalsIgnoreCase(stepName)) continue;
            return dataServiceMeta;
        }
        this.stepCache.putAll(Maps.asMap(cacheKeys, (Function)Functions.constant((Object)"")));
        return null;
    }

    public DataServiceMeta checkDefined(DataServiceMeta dataServiceMeta) throws UndefinedDataServiceException {
        if (Strings.isNullOrEmpty((String)dataServiceMeta.getName())) {
            throw new UndefinedDataServiceException(dataServiceMeta, BaseMessages.getString(PKG, (String)"Messages.SaveError.NameMissing", (String[])new String[0]));
        }
        if (Strings.isNullOrEmpty((String)dataServiceMeta.getStepname())) {
            throw new UndefinedDataServiceException(dataServiceMeta, BaseMessages.getString(PKG, (String)"Messages.SaveError.StepMissing", (String[])new String[0]));
        }
        if (dataServiceMeta.getServiceTrans().findStep(dataServiceMeta.getStepname()) == null) {
            throw new UndefinedDataServiceException(dataServiceMeta, BaseMessages.getString(PKG, (String)"Messages.SaveError.StepNotFound", (String[])new String[]{dataServiceMeta.getStepname()}));
        }
        return dataServiceMeta;
    }

    public DataServiceMeta checkConflict(DataServiceMeta dataServiceMeta, String ignored) throws MetaStoreException, DataServiceAlreadyExistsException {
        TransMeta serviceTrans = dataServiceMeta.getServiceTrans();
        DataServiceMeta stepConflict = this.getDataServiceByStepName(serviceTrans, dataServiceMeta.getStepname());
        if (stepConflict != null && !stepConflict.getName().equals(ignored)) {
            throw new DataServiceAlreadyExistsException(dataServiceMeta, BaseMessages.getString(PKG, (String)"Messages.SaveError.StepConflict", (String[])new String[]{stepConflict.getStepname(), stepConflict.getName()}));
        }
        String name = dataServiceMeta.getName();
        if (name.equals(ignored)) {
            return dataServiceMeta;
        }
        if (this.getDataServiceNames(serviceTrans).contains(name)) {
            throw new DataServiceAlreadyExistsException(dataServiceMeta);
        }
        if (this.getServiceTransMap(serviceTrans).containsKey((Object)name)) {
            throw new DataServiceAlreadyExistsException(dataServiceMeta);
        }
        return dataServiceMeta;
    }

    public void save(DataServiceMeta dataService) throws MetaStoreException {
        TransMeta transMeta = (TransMeta)Preconditions.checkNotNull((Object)dataService.getServiceTrans(), (Object)"Service trans not defined for data service");
        this.getLogChannel().logBasic(MessageFormat.format("Saving ''{0}'' to ''{1}''", dataService.getName(), transMeta.getName()));
        this.getDataServiceFactory(transMeta).saveElement((Object)dataService);
        transMeta.setChanged();
    }

    public void removeDataService(DataServiceMeta dataService) {
        TransMeta transMeta = dataService.getServiceTrans();
        try {
            this.getDataServiceFactory(transMeta).deleteElement(dataService.getName());
            for (Integer key : DataServiceMetaStoreUtil.createCacheKeys(transMeta, dataService.getStepname())) {
                this.stepCache.replace((Object)key, (Object)dataService.getName(), (Object)"");
            }
            transMeta.setChanged();
        }
        catch (MetaStoreException e) {
            this.getLogChannel().logBasic(e.getMessage());
        }
    }

    @Deprecated
    public void sync(TransMeta transMeta, Function<? super Exception, ?> exceptionHandler) {
        DataServiceReferenceSynchronizer syncronizer = new DataServiceReferenceSynchronizer(this.getContext());
        syncronizer.sync(transMeta, (? super Exception e) -> exceptionHandler.apply(e));
    }

    public ImmutableMap<String, ServiceTrans> getServiceTransMap(TransMeta transMeta) throws MetaStoreException {
        return this.getServiceTransMap(transMeta.getRepository(), transMeta.getMetaStore());
    }

    private ImmutableMap<String, ServiceTrans> getServiceTransMap(Repository repository, IMetaStore metaStore) throws MetaStoreException {
        return FluentIterable.from((Iterable)this.getServiceTransFactory(metaStore).getElements()).filter(ServiceTrans.isValid(repository)).uniqueIndex(ServiceTrans.getName);
    }

    public void clearReferences(TransMeta transMeta) {
        MetaStoreFactory<ServiceTrans> serviceTransFactory = this.getServiceTransFactory(transMeta.getMetaStore());
        try {
            FluentIterable names = FluentIterable.from((Iterable)serviceTransFactory.getElements()).filter(ServiceTrans.isReferenceTo(transMeta)).transform(ServiceTrans.getName);
            for (String name : names) {
                serviceTransFactory.deleteElement(name);
            }
        }
        catch (MetaStoreException e) {
            this.getLogChannel().logError("Unable to remove orphaned data service", (Throwable)e);
        }
    }

    protected MetaStoreFactory<ServiceTrans> getServiceTransFactory(IMetaStore metaStore) {
        return new MetaStoreFactory(ServiceTrans.class, metaStore, "pentaho");
    }

    protected MetaStoreFactory<DataServiceMeta> getDataServiceFactory(TransMeta transMeta) {
        return new EmbeddedMetaStoreFactory(transMeta, this.getPushDownFactories(), this.getStepCache());
    }

    static Set<Integer> createCacheKeys(TransMeta transMeta, String stepName) {
        HashCode hash = hashFunction.newHasher().putString((CharSequence)transMeta.getName(), Charsets.UTF_8).putString((CharSequence)stepName, Charsets.UTF_8).hash();
        return ImmutableSet.of((Object)hash.asInt());
    }

    static Map<Integer, String> createCacheEntries(DataServiceMeta dataService) {
        Set<Integer> keys = DataServiceMetaStoreUtil.createCacheKeys(dataService.getServiceTrans(), dataService.getStepname());
        return Maps.asMap(keys, (Function)Functions.constant((Object)dataService.getName()));
    }

    public LogChannelInterface getLogChannel() {
        return this.context.getLogChannel();
    }

    public List<PushDownFactory> getPushDownFactories() {
        return this.context.getPushDownFactories();
    }

    public Function<Exception, Void> logErrors(String message) {
        return e -> {
            this.getLogChannel().logError(message, (Throwable)e);
            return null;
        };
    }

    public DataServiceContext getContext() {
        return this.context;
    }

    public Cache<Integer, String> getStepCache() {
        return this.stepCache;
    }
}

