/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.model;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class DataServiceModel
extends XulEventSourceAdapter {
    private List<PushDownOptimizationMeta> pushDownOptimizations = Lists.newArrayList();
    private String serviceName;
    private String serviceStep;
    private final TransMeta transMeta;

    public DataServiceModel(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        String previous = this.serviceName;
        this.serviceName = serviceName;
        this.firePropertyChange("serviceName", previous, serviceName);
    }

    public String getServiceStep() {
        return this.serviceStep;
    }

    public void setServiceStep(String serviceStep) {
        String previous = this.serviceStep;
        this.serviceStep = serviceStep;
        this.firePropertyChange("serviceStep", previous, serviceStep);
    }

    public ImmutableList<String> getStepFields() {
        ArrayList<String> fields = new ArrayList<String>();
        if (this.getTransMeta() != null && this.getServiceStep() != null) {
            StepMeta stepMeta = this.transMeta.findStep(this.serviceStep);
            try {
                RowMetaInterface row = this.transMeta.getStepFields(stepMeta);
                for (int i = 0; i < row.size(); ++i) {
                    fields.add(row.getValueMeta(i).getName());
                }
                return ImmutableList.copyOf(fields);
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
        return ImmutableList.of();
    }

    public ImmutableList<PushDownOptimizationMeta> getPushDownOptimizations() {
        return ImmutableList.copyOf(this.pushDownOptimizations);
    }

    public void setPushDownOptimizations(List<PushDownOptimizationMeta> pushDownOptimizations) {
        ImmutableList<PushDownOptimizationMeta> previous = this.getPushDownOptimizations();
        this.pushDownOptimizations = Lists.newArrayList(pushDownOptimizations);
        this.firePropertyChange("pushDownOptimizations", previous, this.getPushDownOptimizations());
    }

    public boolean add(PushDownOptimizationMeta pushDownOptimizationMeta) {
        return this.addAll((Collection<PushDownOptimizationMeta>)ImmutableList.of((Object)pushDownOptimizationMeta));
    }

    public boolean addAll(Collection<PushDownOptimizationMeta> pushDownOptimizations) {
        ImmutableList<PushDownOptimizationMeta> previous = this.getPushDownOptimizations();
        if (this.pushDownOptimizations.addAll(pushDownOptimizations)) {
            this.firePropertyChange("pushDownOptimizations", previous, this.getPushDownOptimizations());
            return true;
        }
        return false;
    }

    public boolean remove(PushDownOptimizationMeta pushDownOptimization) {
        ImmutableList<PushDownOptimizationMeta> previous = this.getPushDownOptimizations();
        if (this.pushDownOptimizations.remove(pushDownOptimization)) {
            this.firePropertyChange("pushDownOptimizations", previous, this.getPushDownOptimizations());
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection<PushDownOptimizationMeta> c) {
        ImmutableList<PushDownOptimizationMeta> previous = this.getPushDownOptimizations();
        if (this.pushDownOptimizations.removeAll(c)) {
            this.firePropertyChange("pushDownOptimizations", previous, this.getPushDownOptimizations());
            return true;
        }
        return false;
    }

    public DataServiceMeta getDataService() {
        DataServiceMeta dataService = new DataServiceMeta(this.transMeta);
        dataService.setName(this.getServiceName());
        dataService.setPushDownOptimizationMeta((List<PushDownOptimizationMeta>)this.getPushDownOptimizations());
        dataService.setStepname(this.getServiceStep());
        for (PushDownOptimizationMeta pushDownOptimization : this.pushDownOptimizations) {
            pushDownOptimization.getType().init(this.transMeta, dataService, pushDownOptimization);
        }
        return dataService;
    }

    public ImmutableList<PushDownOptimizationMeta> getPushDownOptimizations(final Class<? extends PushDownType> type) {
        return FluentIterable.from(this.getPushDownOptimizations()).filter((Predicate)new Predicate<PushDownOptimizationMeta>(){

            public boolean apply(PushDownOptimizationMeta input) {
                return type.isInstance(input.getType());
            }
        }).toList();
    }
}

