/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import org.apache.aries.rsa.discovery.zookeeper.server.Utils;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperStarter
implements ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperStarter.class);
    protected ZookeeperServer main;
    private final BundleContext bundleContext;
    private Thread zkMainThread;
    private Map<String, ?> curConfiguration;

    public ZookeeperStarter(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public synchronized void shutdown() {
        if (this.main != null) {
            LOG.info("Shutting down ZooKeeper server");
            try {
                this.main.shutdown();
                if (this.zkMainThread != null) {
                    this.zkMainThread.join();
                }
            }
            catch (Throwable e) {
                LOG.error(e.getMessage(), e);
            }
            this.main = null;
            this.zkMainThread = null;
        }
    }

    private void setDefaults(Dictionary<String, String> dict) throws IOException {
        Utils.removeEmptyValues(dict);
        Utils.setDefault(dict, "tickTime", "2000");
        Utils.setDefault(dict, "initLimit", "10");
        Utils.setDefault(dict, "syncLimit", "5");
        Utils.setDefault(dict, "clientPort", "2181");
        Utils.setDefault(dict, "dataDir", new File(this.bundleContext.getDataFile(""), "zkdata").getCanonicalPath());
    }

    public synchronized void updated(Dictionary<String, ?> dict) throws ConfigurationException {
        LOG.debug("Received configuration update for Zookeeper Server: " + dict);
        try {
            Map<String, ?> configMap;
            if (dict != null) {
                this.setDefaults(dict);
            }
            if (!(configMap = Utils.toMap(dict)).equals(this.curConfiguration)) {
                this.shutdown();
                this.curConfiguration = configMap;
                if (dict != null) {
                    this.startFromConfig(this.parseConfig(dict));
                    LOG.info("Applied configuration update: " + dict);
                }
            }
        }
        catch (Exception th) {
            LOG.error("Problem applying configuration update: " + dict, (Throwable)th);
        }
    }

    private QuorumPeerConfig parseConfig(Dictionary<String, ?> dict) throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(Utils.toProperties(dict));
        return config;
    }

    protected void startFromConfig(QuorumPeerConfig config) {
        int numServers = config.getServers().size();
        this.main = numServers > 1 ? new MyQuorumPeerMain(config) : new MyZooKeeperServerMain(config);
        this.zkMainThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ZookeeperStarter.this.main.startup();
                }
                catch (Throwable e) {
                    LOG.error("Problem running ZooKeeper server.", e);
                }
            }
        });
        this.zkMainThread.start();
    }

    static class MyZooKeeperServerMain
    extends ZooKeeperServerMain
    implements ZookeeperServer {
        private QuorumPeerConfig config;

        MyZooKeeperServerMain(QuorumPeerConfig config) {
            this.config = config;
        }

        @Override
        public void startup() throws IOException {
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.readFrom(this.config);
            this.runFromConfig(serverConfig);
        }

        @Override
        public void shutdown() {
            try {
                super.shutdown();
            }
            catch (Exception e) {
                LOG.error("Error shutting down ZooKeeper", (Throwable)e);
            }
        }
    }

    static class MyQuorumPeerMain
    extends QuorumPeerMain
    implements ZookeeperServer {
        private QuorumPeerConfig config;

        MyQuorumPeerMain(QuorumPeerConfig config) {
            this.config = config;
        }

        @Override
        public void startup() throws IOException {
            this.runFromConfig(this.config);
        }

        @Override
        public void shutdown() {
            if (null != this.quorumPeer) {
                this.quorumPeer.shutdown();
            }
        }
    }

    static interface ZookeeperServer {
        public void startup() throws IOException;

        public void shutdown();
    }
}

