/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerField;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputData;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.SubtransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;
import org.pentaho.metastore.api.IMetaStore;

public class KafkaConsumerInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = KafkaConsumerInputMeta.class;
    private KafkaConsumerInputMeta kafkaConsumerInputMeta;
    private KafkaConsumerInputData kafkaConsumerInputData;
    private KafkaConsumerCallable callable;
    private ExecutorService executorService;
    private Map<KafkaConsumerField.Name, Integer> positions;
    AtomicLong messageOffset = new AtomicLong();
    private final HashMap<TopicPartition, Long> maxOffsets = new HashMap();

    public KafkaConsumerInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        this.kafkaConsumerInputMeta = (KafkaConsumerInputMeta)stepMetaInterface;
        this.kafkaConsumerInputData = (KafkaConsumerInputData)stepDataInterface;
        try {
            this.kafkaConsumerInputMeta.setParentStepMeta(this.getStepMeta());
            this.kafkaConsumerInputMeta.setFileName(this.kafkaConsumerInputMeta.getTransformationPath());
            TransMeta transMeta = TransExecutorMeta.loadMappingMeta((StepWithMappingMeta)this.kafkaConsumerInputMeta, (Repository)this.getTransMeta().getRepository(), (IMetaStore)this.getTransMeta().getMetaStore(), (VariableSpace)this.getParentVariableSpace());
            this.kafkaConsumerInputData.subtransExecutor = new SubtransExecutor(this.getTrans(), transMeta, true, (TransExecutorData)this.kafkaConsumerInputData, new TransExecutorParameters());
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"KafkaConsumerInput.Error.InitFailed", (String[])new String[0]), e);
            return false;
        }
        boolean superInit = super.init((StepMetaInterface)this.kafkaConsumerInputMeta, (StepDataInterface)this.kafkaConsumerInputData);
        if (!superInit) {
            return false;
        }
        Consumer consumer = this.kafkaConsumerInputMeta.getKafkaFactory().consumer(this.kafkaConsumerInputMeta, arg_0 -> ((KafkaConsumerInput)this).environmentSubstitute(arg_0), this.kafkaConsumerInputMeta.getKeyField().getOutputType(), this.kafkaConsumerInputMeta.getMessageField().getOutputType());
        ArrayList<String> topicList = new ArrayList<String>();
        for (String topic : this.kafkaConsumerInputMeta.getTopics()) {
            topicList.add(this.environmentSubstitute(topic));
        }
        consumer.subscribe((Collection)Sets.newHashSet(topicList));
        this.callable = new KafkaConsumerCallable(consumer);
        this.startBatchDurationTimer();
        return true;
    }

    public void startBatchDurationTimer() {
        this.kafkaConsumerInputData.timer = new Timer();
        if (Long.parseLong(this.environmentSubstitute(this.kafkaConsumerInputMeta.getBatchDuration())) <= 0L) {
            return;
        }
        this.kafkaConsumerInputData.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    KafkaConsumerInput.this.sendBufferToSubtrans(true);
                }
                catch (KettleException e) {
                    KafkaConsumerInput.this.logError(e.getMessage());
                }
            }
        }, Long.parseLong(this.environmentSubstitute(this.kafkaConsumerInputMeta.getBatchDuration())));
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.kafkaConsumerInputMeta = (KafkaConsumerInputMeta)smi;
        this.kafkaConsumerInputData = (KafkaConsumerInputData)sdi;
        Object[] r = this.getRow();
        if (r == null && !this.first) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.kafkaConsumerInputData.outputRowMeta = new RowMeta();
            this.kafkaConsumerInputMeta.getFields(this.kafkaConsumerInputData.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            if (this.executorService == null) {
                this.executorService = Executors.newSingleThreadExecutor();
            }
            List valueMetas = this.kafkaConsumerInputData.outputRowMeta.getValueMetaList();
            this.positions = new HashMap<KafkaConsumerField.Name, Integer>(valueMetas.size());
            IntStream.range(0, valueMetas.size()).forEach(idx -> {
                Optional<KafkaConsumerField.Name> match = Arrays.stream(KafkaConsumerField.Name.values()).filter(name -> {
                    KafkaConsumerField f = name.getFieldFromMeta(this.kafkaConsumerInputMeta);
                    String fieldName = this.environmentSubstitute(f.getOutputName());
                    return fieldName != null && fieldName.equals(((ValueMetaInterface)valueMetas.get(idx)).getName());
                }).findFirst();
                match.ifPresent(name -> this.positions.put((KafkaConsumerField.Name)((Object)((Object)name)), idx));
            });
            Future<Void> future = this.executorService.submit(this.callable);
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"KafkaConsumerInput.Error.WaitingForMessages", (String[])new String[0]), (Throwable)e);
            }
        }
        return true;
    }

    void processMessageAsRow(ConsumerRecord<String, String> record) throws KettleException {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.kafkaConsumerInputData.outputRowMeta.size());
        if (this.positions.get((Object)KafkaConsumerField.Name.KEY) != null) {
            rowData[this.positions.get((Object)((Object)KafkaConsumerField.Name.KEY)).intValue()] = record.key();
        }
        if (this.positions.get((Object)KafkaConsumerField.Name.MESSAGE) != null) {
            rowData[this.positions.get((Object)((Object)KafkaConsumerField.Name.MESSAGE)).intValue()] = record.value();
        }
        if (this.positions.get((Object)KafkaConsumerField.Name.TOPIC) != null) {
            rowData[this.positions.get((Object)((Object)KafkaConsumerField.Name.TOPIC)).intValue()] = record.topic();
        }
        if (this.positions.get((Object)KafkaConsumerField.Name.PARTITION) != null) {
            rowData[this.positions.get((Object)((Object)KafkaConsumerField.Name.PARTITION)).intValue()] = (long)record.partition();
        }
        if (this.positions.get((Object)KafkaConsumerField.Name.OFFSET) != null) {
            rowData[this.positions.get((Object)((Object)KafkaConsumerField.Name.OFFSET)).intValue()] = record.offset();
        }
        if (this.positions.get((Object)KafkaConsumerField.Name.TIMESTAMP) != null) {
            rowData[this.positions.get((Object)((Object)KafkaConsumerField.Name.TIMESTAMP)).intValue()] = record.timestamp();
        }
        this.collectRow(this.kafkaConsumerInputData.outputRowMeta, rowData);
        this.sendBufferToSubtrans(false);
        this.incrementLinesInput();
        if (record.offset() > this.messageOffset.get()) {
            this.messageOffset.set(record.offset());
        }
    }

    private synchronized void sendBufferToSubtrans(boolean forcedByTimer) throws KettleException {
        if (forcedByTimer || (long)this.kafkaConsumerInputData.buffer.size() == Long.parseLong(this.environmentSubstitute(this.kafkaConsumerInputMeta.getBatchSize()))) {
            Optional result = this.kafkaConsumerInputData.subtransExecutor.execute(this.kafkaConsumerInputData.buffer);
            this.kafkaConsumerInputData.buffer.clear();
            if (Long.parseLong(this.environmentSubstitute(this.kafkaConsumerInputMeta.getBatchDuration())) >= 0L) {
                this.kafkaConsumerInputData.timer.cancel();
                this.startBatchDurationTimer();
            }
            if (result.isPresent() && ((Result)result.get()).getNrErrors() > 0L) {
                this.stopAll();
            }
        }
    }

    synchronized void collectRow(RowMetaInterface rowMeta, Object[] rowData) {
        this.kafkaConsumerInputData.buffer.add(new RowMetaAndData(rowMeta, rowData));
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        this.callable.shutdown();
        this.kafkaConsumerInputData.timer.cancel();
    }

    public void resumeRunning() {
        this.callable.pauseLatch.countDown();
        super.resumeRunning();
    }

    public void pauseRunning() {
        this.callable.pauseLatch = new CountDownLatch(1);
        super.pauseRunning();
    }

    class KafkaConsumerCallable
    implements Callable<Void> {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Consumer consumer;
        private CountDownLatch pauseLatch = new CountDownLatch(0);

        public KafkaConsumerCallable(Consumer consumer) {
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                ConsumerRecords records;
                block7: while (!this.closed.get()) {
                    this.waitIfPaused();
                    records = this.consumer.poll(1000L);
                    this.waitIfPaused();
                    for (ConsumerRecord record : records) {
                        KafkaConsumerInput.this.maxOffsets.put(new TopicPartition(record.topic(), record.partition()), record.offset());
                        if (this.closed.get()) {
                            for (TopicPartition topicPartition : KafkaConsumerInput.this.maxOffsets.keySet()) {
                                this.consumer.seek(topicPartition, ((Long)KafkaConsumerInput.this.maxOffsets.get(topicPartition)).longValue());
                            }
                            this.consumer.commitSync();
                            continue block7;
                        }
                        try {
                            KafkaConsumerInput.this.processMessageAsRow((ConsumerRecord<String, String>)record);
                        }
                        catch (KettleException e) {
                            KafkaConsumerInput.this.logError(BaseMessages.getString((Class)PKG, (String)"KafkaConsumerInput.Error.ProcessingMessage", (String[])new String[]{(String)record.key(), (String)record.value()}), e);
                        }
                    }
                }
                records = null;
                return records;
            }
            catch (WakeupException e) {
                if (!this.closed.get()) {
                    throw e;
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.consumer.close();
            }
        }

        public void waitIfPaused() {
            try {
                this.pauseLatch.await();
            }
            catch (InterruptedException e) {
                KafkaConsumerInput.this.logError(BaseMessages.getString((Class)PKG, (String)"KafkaConsumerInput.Error.Polling", (String[])new String[0]), e);
            }
        }

        public void shutdown() {
            this.closed.set(true);
            this.consumer.wakeup();
        }
    }
}

