/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerField;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaDialogHelper;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class KafkaConsumerInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    public static final int INPUT_WIDTH = 350;
    private static Class<?> PKG = KafkaConsumerInputMeta.class;
    private static final Map<String, String> DEFAULT_OPTION_VALUES = ImmutableMap.of((Object)"auto.offset.reset", (Object)"latest");
    private final KafkaFactory kafkaFactory = KafkaFactory.defaultFactory();
    private KafkaConsumerInputMeta meta;
    private TransMeta executorTransMeta = null;
    private Label wlTransPath;
    private TextVar wTransPath;
    private Button wbBrowseTrans;
    private ObjectLocationSpecificationMethod specificationMethod;
    private Label wlClusterName;
    private ComboVar wClusterName;
    private Label wlTopic;
    private Label wlConsumerGroup;
    private TextVar wConsumerGroup;
    private ModifyListener lsMod;
    private TableView fieldsTable;
    private TableView topicsTable;
    private TableView optionsTable;
    private Label wlBatchSize;
    private TextVar wBatchSize;
    private Label wlBatchDuration;
    private TextVar wBatchDuration;
    private CTabFolder wTabFolder;
    private CTabItem wSetupTab;
    private CTabItem wBatchTab;
    private CTabItem wFieldsTab;
    private CTabItem wOptionsTab;
    private Composite wSetupComp;
    private Composite wFieldsComp;
    private Composite wBatchComp;
    private Composite wOptionsComp;
    private Button wbDirect;
    private Button wbCluster;
    private Label wlBootstrapServers;
    private TextVar wBootstrapServers;

    public KafkaConsumerInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.meta = (KafkaConsumerInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.shell.setMinimumSize(527, 622);
        this.lsMod = e -> this.meta.setChanged();
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)spacer);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        fdSpacer.width = 497;
        spacer.setLayoutData((Object)fdSpacer);
        this.wlTransPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlTransPath);
        this.wlTransPath.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Transformation", (String[])new String[0]));
        FormData fdlTransPath = new FormData();
        fdlTransPath.left = new FormAttachment(0, 0);
        fdlTransPath.top = new FormAttachment((Control)spacer, 15);
        fdlTransPath.right = new FormAttachment(50, 0);
        this.wlTransPath.setLayoutData((Object)fdlTransPath);
        this.wTransPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTransPath);
        this.wTransPath.addModifyListener(this.lsMod);
        FormData fdTransPath = new FormData();
        fdTransPath.left = new FormAttachment(0, 0);
        fdTransPath.right = new FormAttachment(75, 0);
        fdTransPath.top = new FormAttachment((Control)this.wlTransPath, 5);
        this.wTransPath.setLayoutData((Object)fdTransPath);
        this.wbBrowseTrans = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowseTrans);
        this.wbBrowseTrans.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Transformation.Browse", (String[])new String[0]));
        FormData fdBrowseTrans = new FormData();
        fdBrowseTrans.left = new FormAttachment((Control)this.wTransPath, 5);
        fdBrowseTrans.top = new FormAttachment((Control)this.wlTransPath, 5);
        this.wbBrowseTrans.setLayoutData((Object)fdBrowseTrans);
        this.wbBrowseTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (KafkaConsumerInputDialog.this.repository != null) {
                    KafkaConsumerInputDialog.this.selectRepositoryTrans();
                } else {
                    KafkaConsumerInputDialog.this.selectFileTrans();
                }
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)hSpacer);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 2;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransPath, 15);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.buildSetupTab();
        this.buildBatchTab();
        this.buildFieldsTab();
        this.buildOptionsTab();
        this.lsCancel = e -> this.cancel();
        this.lsOK = e -> this.ok();
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                KafkaConsumerInputDialog.this.ok();
            }
        };
        this.wClusterName.addSelectionListener(this.lsDef);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                KafkaConsumerInputDialog.this.cancel();
            }
        });
        this.getData();
        this.setSize();
        this.meta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void buildSetupTab() {
        this.wSetupTab = new CTabItem(this.wTabFolder, 0);
        this.wSetupTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.SetupTab", (String[])new String[0]));
        this.wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        this.wSetupComp.setLayout((Layout)setupLayout);
        Group wConnectionGroup = new Group(this.wSetupComp, 16);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Connection", (String[])new String[0]));
        FormLayout flConnection = new FormLayout();
        flConnection.marginHeight = 15;
        flConnection.marginWidth = 15;
        wConnectionGroup.setLayout((Layout)flConnection);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, 0);
        fdConnectionGroup.top = new FormAttachment(0, 0);
        fdConnectionGroup.right = new FormAttachment(100, 0);
        fdConnectionGroup.width = 350;
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        this.props.setLook((Control)wConnectionGroup);
        this.wbDirect = new Button((Composite)wConnectionGroup, 16);
        this.wbDirect.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Direct", (String[])new String[0]));
        FormData fdbDirect = new FormData();
        fdbDirect.left = new FormAttachment(0, 0);
        fdbDirect.top = new FormAttachment(0, 0);
        this.wbDirect.setLayoutData((Object)fdbDirect);
        this.wbDirect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.lsMod.modifyText(null);
                KafkaConsumerInputDialog.this.toggleVisibility(true);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.toggleVisibility(true);
            }
        });
        this.props.setLook((Control)this.wbDirect);
        this.wbCluster = new Button((Composite)wConnectionGroup, 16);
        this.wbCluster.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Cluster", (String[])new String[0]));
        FormData fdbCluster = new FormData();
        fdbCluster.left = new FormAttachment(0, 0);
        fdbCluster.top = new FormAttachment((Control)this.wbDirect, 10);
        this.wbCluster.setLayoutData((Object)fdbCluster);
        this.wbCluster.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.lsMod.modifyText(null);
                KafkaConsumerInputDialog.this.toggleVisibility(false);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KafkaConsumerInputDialog.this.toggleVisibility(false);
            }
        });
        this.props.setLook((Control)this.wbCluster);
        Label environmentSeparator = new Label((Composite)wConnectionGroup, 514);
        FormData fdenvironmentSeparator = new FormData();
        fdenvironmentSeparator.top = new FormAttachment((Control)this.wbDirect, 0, 128);
        fdenvironmentSeparator.left = new FormAttachment((Control)this.wbCluster, 15);
        fdenvironmentSeparator.bottom = new FormAttachment((Control)this.wbCluster, 0, 1024);
        environmentSeparator.setLayoutData((Object)fdenvironmentSeparator);
        this.wlClusterName = new Label((Composite)wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlClusterName);
        this.wlClusterName.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.HadoopCluster", (String[])new String[0]));
        FormData fdlClusterName = new FormData();
        fdlClusterName.left = new FormAttachment((Control)environmentSeparator, 15);
        fdlClusterName.top = new FormAttachment(0, 0);
        fdlClusterName.right = new FormAttachment(78, 0);
        this.wlClusterName.setLayoutData((Object)fdlClusterName);
        this.wClusterName = new ComboVar((VariableSpace)this.transMeta, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wClusterName);
        this.wClusterName.addModifyListener(this.lsMod);
        FormData fdClusterName = new FormData();
        fdClusterName.left = new FormAttachment((Control)this.wlClusterName, 0, 16384);
        fdClusterName.top = new FormAttachment((Control)this.wlClusterName, 5);
        fdClusterName.right = new FormAttachment(78, 0);
        this.wClusterName.setLayoutData((Object)fdClusterName);
        this.wlBootstrapServers = new Label((Composite)wConnectionGroup, 16384);
        this.props.setLook((Control)this.wlBootstrapServers);
        this.wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BootstrapServers", (String[])new String[0]));
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment((Control)environmentSeparator, 15);
        fdlBootstrapServers.top = new FormAttachment(0, 0);
        fdlBootstrapServers.right = new FormAttachment(78, 0);
        this.wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar((VariableSpace)this.transMeta, (Composite)wConnectionGroup, 18436);
        this.props.setLook((Control)this.wBootstrapServers);
        this.wBootstrapServers.addModifyListener(this.lsMod);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment((Control)this.wlBootstrapServers, 0, 16384);
        fdBootstrapServers.top = new FormAttachment((Control)this.wlBootstrapServers, 5);
        fdBootstrapServers.right = new FormAttachment(78, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        this.wlTopic = new Label(this.wSetupComp, 16384);
        this.props.setLook((Control)this.wlTopic);
        this.wlTopic.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Topics", (String[])new String[0]));
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)wConnectionGroup, 10);
        fdlTopic.right = new FormAttachment(50, 0);
        this.wlTopic.setLayoutData((Object)fdlTopic);
        this.wConsumerGroup = new TextVar((VariableSpace)this.transMeta, this.wSetupComp, 18436);
        this.props.setLook((Control)this.wConsumerGroup);
        this.wConsumerGroup.addModifyListener(this.lsMod);
        FormData fdConsumerGroup = new FormData();
        fdConsumerGroup.left = new FormAttachment(0, 0);
        fdConsumerGroup.bottom = new FormAttachment(100, 0);
        fdConsumerGroup.width = 350;
        this.wConsumerGroup.setLayoutData((Object)fdConsumerGroup);
        this.wlConsumerGroup = new Label(this.wSetupComp, 16384);
        this.props.setLook((Control)this.wlConsumerGroup);
        this.wlConsumerGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.ConsumerGroup", (String[])new String[0]));
        FormData fdlConsumerGroup = new FormData();
        fdlConsumerGroup.left = new FormAttachment(0, 0);
        fdlConsumerGroup.bottom = new FormAttachment((Control)this.wConsumerGroup, -5, 128);
        fdlConsumerGroup.right = new FormAttachment(50, 0);
        this.wlConsumerGroup.setLayoutData((Object)fdlConsumerGroup);
        this.buildTopicsTable(this.wSetupComp, (Control)this.wlTopic, (Control)this.wlConsumerGroup);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        this.wSetupComp.setLayoutData((Object)fdSetupComp);
        this.wSetupComp.layout();
        this.wSetupTab.setControl((Control)this.wSetupComp);
    }

    public void toggleVisibility(boolean isDirect) {
        this.wlBootstrapServers.setVisible(isDirect);
        this.wBootstrapServers.setVisible(isDirect);
        this.wlClusterName.setVisible(!isDirect);
        this.wClusterName.setVisible(!isDirect);
    }

    private void buildBatchTab() {
        this.wBatchTab = new CTabItem(this.wTabFolder, 0);
        this.wBatchTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BatchTab", (String[])new String[0]));
        this.wBatchComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wBatchComp);
        FormLayout batchLayout = new FormLayout();
        batchLayout.marginHeight = 15;
        batchLayout.marginWidth = 15;
        this.wBatchComp.setLayout((Layout)batchLayout);
        FormData fdBatchComp = new FormData();
        fdBatchComp.left = new FormAttachment(0, 0);
        fdBatchComp.top = new FormAttachment(0, 0);
        fdBatchComp.right = new FormAttachment(100, 0);
        fdBatchComp.bottom = new FormAttachment(100, 0);
        this.wSetupComp.setLayoutData((Object)fdBatchComp);
        this.wlBatchSize = new Label(this.wBatchComp, 16384);
        this.props.setLook((Control)this.wlBatchSize);
        this.wlBatchSize.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BatchSize", (String[])new String[0]));
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(50, 0);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar((VariableSpace)this.transMeta, this.wBatchComp, 18436);
        this.props.setLook((Control)this.wBatchSize);
        this.wBatchSize.addModifyListener(this.lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(0, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wlBatchSize, 5);
        fdBatchSize.width = 75;
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        this.wlBatchDuration = new Label(this.wBatchComp, 16384);
        this.props.setLook((Control)this.wlBatchDuration);
        this.wlBatchDuration.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BatchDuration", (String[])new String[0]));
        FormData fdlBatchDuration = new FormData();
        fdlBatchDuration.left = new FormAttachment(0, 0);
        fdlBatchDuration.top = new FormAttachment((Control)this.wBatchSize, 10);
        fdlBatchDuration.right = new FormAttachment(50, 0);
        this.wlBatchDuration.setLayoutData((Object)fdlBatchDuration);
        this.wBatchDuration = new TextVar((VariableSpace)this.transMeta, this.wBatchComp, 18436);
        this.props.setLook((Control)this.wBatchDuration);
        this.wBatchDuration.addModifyListener(this.lsMod);
        FormData fdBatchDuration = new FormData();
        fdBatchDuration.left = new FormAttachment(0, 0);
        fdBatchDuration.top = new FormAttachment((Control)this.wlBatchDuration, 5);
        fdBatchDuration.width = 75;
        this.wBatchDuration.setLayoutData((Object)fdBatchDuration);
        this.wBatchComp.layout();
        this.wBatchTab.setControl((Control)this.wBatchComp);
    }

    private void buildFieldsTab() {
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.FieldsTab", (String[])new String[0]));
        this.wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        this.wFieldsComp.setLayout((Layout)fieldsLayout);
        FormData fieldsFormData = new FormData();
        fieldsFormData.left = new FormAttachment(0, 0);
        fieldsFormData.top = new FormAttachment((Control)this.wFieldsComp, 0);
        fieldsFormData.right = new FormAttachment(100, 0);
        fieldsFormData.bottom = new FormAttachment(100, 0);
        this.wFieldsComp.setLayoutData((Object)fieldsFormData);
        this.buildFieldTable(this.wFieldsComp, (Control)this.wFieldsComp);
        this.wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)this.wFieldsComp);
    }

    private void buildOptionsTab() {
        this.wOptionsTab = new CTabItem(this.wTabFolder, 0);
        this.wOptionsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OptionsTab", (String[])new String[0]));
        this.wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wOptionsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        this.wOptionsComp.setLayout((Layout)fieldsLayout);
        Label optionsLabel = new Label(this.wOptionsComp, 16384);
        this.props.setLook((Control)optionsLabel);
        optionsLabel.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OptionsLabel", (String[])new String[0]));
        FormData fdlOptions = new FormData();
        fdlOptions.left = new FormAttachment(0, 0);
        fdlOptions.top = new FormAttachment(0, 0);
        fdlOptions.right = new FormAttachment(50, 0);
        optionsLabel.setLayoutData((Object)fdlOptions);
        FormData optionsFormData = new FormData();
        optionsFormData.left = new FormAttachment(0, 0);
        optionsFormData.top = new FormAttachment((Control)this.wOptionsComp, 0);
        optionsFormData.right = new FormAttachment(100, 0);
        optionsFormData.bottom = new FormAttachment(100, 0);
        this.wOptionsComp.setLayoutData((Object)optionsFormData);
        this.buildOptionsTable(this.wOptionsComp, (Control)optionsLabel);
        this.wOptionsComp.layout();
        this.wOptionsTab.setControl((Control)this.wOptionsComp);
    }

    private void buildFieldTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getFieldColumns();
        int fieldCount = KafkaConsumerField.Name.values().length;
        this.fieldsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, fieldCount, true, this.lsMod, this.props, false);
        this.fieldsTable.setSortable(false);
        this.fieldsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(147);
            table.getColumn(2).setWidth(147);
            table.getColumn(3).setWidth(147);
        });
        this.populateFieldData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.right = new FormAttachment(100, 0);
        Arrays.stream(this.fieldsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.fieldsTable.setReadonly(true);
        this.fieldsTable.setLayoutData((Object)fdData);
    }

    private void buildOptionsTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getOptionsColumns();
        if (this.meta.getConfig().size() == 0) {
            List<String> list = KafkaDialogHelper.getConsumerAdvancedConfigOptionNames();
            LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
            for (String item : list) {
                advancedConfig.put(item, DEFAULT_OPTION_VALUES.getOrDefault(item, ""));
            }
            this.meta.setConfig(advancedConfig);
        }
        int fieldCount = this.meta.getConfig().size();
        this.optionsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        this.optionsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(220);
            table.getColumn(2).setWidth(220);
        });
        this.populateOptionsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        Arrays.stream(this.optionsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.optionsTable.setLayoutData((Object)fdData);
    }

    private ColumnInfo[] getFieldColumns() {
        KafkaConsumerField.Type[] values = KafkaConsumerField.Type.values();
        String[] supportedTypes = (String[])Arrays.stream(values).map(v -> v.toString()).toArray(String[]::new);
        ColumnInfo referenceName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Ref", (String[])new String[0]), 1, false, true);
        ColumnInfo name = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo type = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Type", (String[])new String[0]), 2, supportedTypes, false);
        type.setDisabledListener(rowNumber -> {
            String ref = this.fieldsTable.getTable().getItem(rowNumber).getText(1);
            KafkaConsumerField.Name refName = KafkaConsumerField.Name.valueOf(ref.toUpperCase());
            return refName != KafkaConsumerField.Name.KEY && refName != KafkaConsumerField.Name.MESSAGE;
        });
        return new ColumnInfo[]{referenceName, name, type};
    }

    private ColumnInfo[] getOptionsColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.NameField", (String[])new String[0]), 1, false, false);
        ColumnInfo value = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Value", (String[])new String[0]), 1, false, false);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateFieldData() {
        List<KafkaConsumerField> fieldDefinitions = this.meta.getFieldDefinitions();
        int rowIndex = 0;
        for (KafkaConsumerField field : fieldDefinitions) {
            TableItem key = this.fieldsTable.getTable().getItem(rowIndex++);
            if (field.getKafkaName() != null) {
                key.setText(1, field.getKafkaName().toString());
            }
            if (field.getOutputName() != null) {
                key.setText(2, field.getOutputName());
            }
            if (field.getOutputType() == null) continue;
            key.setText(3, field.getOutputType().toString());
        }
    }

    private void populateOptionsData() {
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.meta.getConfig().entrySet()) {
            TableItem key = this.optionsTable.getTable().getItem(rowIndex++);
            key.setText(1, entry.getKey());
            key.setText(2, entry.getValue());
        }
    }

    private void populateTopicsData() {
        List<String> topics = this.meta.getTopics();
        int rowIndex = 0;
        for (String topic : topics) {
            TableItem key = this.topicsTable.getTable().getItem(rowIndex++);
            if (topic == null) continue;
            key.setText(1, topic);
        }
    }

    private void buildTopicsTable(Composite parentWidget, Control controlAbove, Control controlBelow) {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.NameField", (String[])new String[0]), 2, new String[1], false)};
        columns[0].setUsingVariables(true);
        int topicsCount = this.meta.getTopics().size();
        Listener lsFocusInTopic = e -> {
            CCombo ccom = (CCombo)e.widget;
            ComboVar cvar = (ComboVar)ccom.getParent();
            KafkaDialogHelper kdh = new KafkaDialogHelper(this.wClusterName, cvar, this.wbCluster, this.wBootstrapServers, this.kafkaFactory, this.meta.getNamedClusterService(), this.meta.getNamedClusterServiceLocator(), this.meta.getMetastoreLocator(), this.optionsTable, this.meta.getParentStepMeta());
            kdh.clusterNameChanged(e);
        };
        this.topicsTable = new TableView((VariableSpace)this.transMeta, parentWidget, 67586, columns, topicsCount, false, this.lsMod, this.props, false, true, lsFocusInTopic);
        this.topicsTable.setSortable(false);
        this.topicsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(316);
        });
        this.populateTopicsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(controlAbove, 5);
        fdData.right = new FormAttachment(0, 337);
        fdData.bottom = new FormAttachment(controlBelow, -10, 128);
        Arrays.stream(this.topicsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.topicsTable.setLayoutData((Object)fdData);
    }

    private void getData() {
        if (this.meta.getTransformationPath() != null) {
            this.wTransPath.setText(this.meta.getTransformationPath());
        }
        try {
            List names = this.meta.getNamedClusterService().listNames((IMetaStore)Spoon.getInstance().getMetaStore());
            this.wClusterName.setItems(names.toArray(new String[names.size()]));
        }
        catch (MetaStoreException e) {
            this.log.logError("Failed to get defined named clusters", (Throwable)e);
        }
        if (this.meta.getClusterName() != null) {
            this.wClusterName.setText(this.meta.getClusterName());
        }
        if (this.meta.getDirectBootstrapServers() != null) {
            this.wBootstrapServers.setText(this.meta.getDirectBootstrapServers());
        }
        this.populateTopicsData();
        if (this.meta.getConsumerGroup() != null) {
            this.wConsumerGroup.setText(this.meta.getConsumerGroup());
        }
        if (this.meta.getBatchSize() != null) {
            this.wBatchSize.setText(this.meta.getBatchSize());
        }
        if (this.meta.getBatchDuration() != null) {
            this.wBatchDuration.setText(this.meta.getBatchDuration());
        }
        if (this.isDirect()) {
            this.wbCluster.setSelection(false);
            this.wbDirect.setSelection(true);
        } else {
            this.wbCluster.setSelection(true);
            this.wbDirect.setSelection(false);
        }
        this.toggleVisibility(this.isDirect());
        this.populateFieldData();
    }

    private boolean isDirect() {
        return KafkaConsumerInputMeta.ConnectionType.DIRECT.equals((Object)this.meta.getConnectionType());
    }

    private Image getImage() {
        PluginInterface plugin = PluginRegistry.getInstance().getPlugin(StepPluginType.class, (Object)this.stepMeta.getStepMetaInterface());
        String id = plugin.getIds()[0];
        if (id != null) {
            return ((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(id)).getAsBitmapForSize((Device)this.shell.getDisplay(), 32, 32);
        }
        return null;
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.meta.setTransformationPath(this.wTransPath.getText());
        this.meta.setClusterName(this.wClusterName.getText());
        this.setTopicsFromTable();
        this.meta.setConsumerGroup(this.wConsumerGroup.getText());
        this.meta.setBatchSize(this.wBatchSize.getText());
        this.meta.setBatchDuration(this.wBatchDuration.getText());
        this.meta.setConnectionType(this.wbDirect.getSelection() ? KafkaConsumerInputMeta.ConnectionType.DIRECT : KafkaConsumerInputMeta.ConnectionType.CLUSTER);
        this.meta.setDirectBootstrapServers(this.wBootstrapServers.getText());
        this.setFieldsFromTable();
        this.setOptionsFromTable();
        this.dispose();
    }

    private void setFieldsFromTable() {
        int itemCount = this.fieldsTable.getItemCount();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = this.fieldsTable.getTable().getItem(rowIndex);
            String kafkaName = row.getText(1);
            String outputName = row.getText(2);
            String outputType = row.getText(3);
            try {
                KafkaConsumerField.Name ref = KafkaConsumerField.Name.valueOf(kafkaName.toUpperCase());
                KafkaConsumerField field = new KafkaConsumerField(ref, outputName, KafkaConsumerField.Type.valueOf(outputType));
                this.meta.setField(field);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (!this.isDebug()) continue;
                this.logDebug(e.getMessage(), new Object[]{e});
            }
        }
    }

    private void setTopicsFromTable() {
        int itemCount = this.topicsTable.getItemCount();
        ArrayList<String> tableTopics = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = this.topicsTable.getTable().getItem(rowIndex);
            String topic = row.getText(1);
            if ("".equals(topic) || tableTopics.indexOf(topic) != -1) continue;
            tableTopics.add(topic);
        }
        this.meta.setTopics(tableTopics);
    }

    private void setOptionsFromTable() {
        this.meta.setConfig(KafkaDialogHelper.getConfig(this.optionsTable));
    }

    private void selectRepositoryTrans() {
        try {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository);
            String transName = sod.open();
            RepositoryDirectoryInterface repdir = sod.getDirectory();
            if (transName != null && repdir != null) {
                this.loadRepositoryTrans(transName, repdir);
                String path = this.getPath(this.executorTransMeta.getRepositoryDirectory().getPath());
                String fullPath = path + "/" + this.executorTransMeta.getName();
                this.wTransPath.setText(fullPath);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    protected String getPath(String path) {
        String parentPath = this.transMeta.getRepositoryDirectory().getPath();
        if (path.startsWith(parentPath)) {
            path = path.replace(parentPath, "${Internal.Entry.Current.Directory}");
        }
        return path;
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.executorTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, false, null);
        this.executorTransMeta.clearChanged();
    }

    private void selectFileTrans() {
        String curFile = this.transMeta.environmentSubstitute(this.wTransPath.getText());
        FileObject root = null;
        String parentFolder = null;
        try {
            parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fileName = file.getName().toString();
            if (fileName != null) {
                this.loadFileTrans(fileName);
                if (parentFolder != null && fileName.startsWith(parentFolder)) {
                    fileName = fileName.replace(parentFolder, "${Internal.Entry.Current.Directory}");
                }
                this.wTransPath.setText(fileName);
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            }
        }
        catch (IOException | KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransExecutorDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)e);
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.executorTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname), this.repository);
        this.executorTransMeta.clearChanged();
    }

    void loadTransformation() throws KettleException {
        String filename = this.wTransPath.getText();
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        switch (this.specificationMethod) {
            case FILENAME: {
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (!filename.endsWith(".ktr")) {
                    filename = filename + ".ktr";
                    this.wTransPath.setText(filename);
                }
                this.loadFileTrans(filename);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (filename.endsWith(".ktr")) {
                    filename = filename.replace(".ktr", "");
                    this.wTransPath.setText(filename);
                }
                String realTransname = transPath = this.transMeta.environmentSubstitute(filename);
                String realDirectory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    realTransname = transPath.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutorDialog.Exception.UnableToFindRepositoryDirectory", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
        }
    }
}

