/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigstats.PigStats;

@InterfaceAudience.LimitedPrivate(value={"Penny"})
@InterfaceStability.Unstable
public class ToolsPigServer
extends PigServer {
    private PigPlans plans = null;

    public ToolsPigServer(String execTypeString) throws ExecException, IOException {
        super(execTypeString);
    }

    public ToolsPigServer(PigContext ctx) throws ExecException, IOException {
        super(ctx);
    }

    public ToolsPigServer(ExecType execType, Properties properties) throws ExecException {
        super(execType, properties);
    }

    public void registerNoRun(String fileName, Map<String, String> params, List<String> paramFiles) throws IOException, FrontendException {
        String substituted = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(fileName);
            substituted = this.pigContext.doParamSubstitution(fis, this.paramMapToList(params), paramFiles);
        }
        try {
            GruntParser grunt = new GruntParser(new StringReader(substituted), (PigServer)this);
            grunt.setInteractive(false);
            this.setBatchOn();
            grunt.parseOnly();
        }
        catch (ParseException e) {
            this.log.error((Object)e.getLocalizedMessage());
            throw new IOException(e);
        }
        PigServer.Graph g = this.getClonedGraph();
        LogicalPlan lp = g.getPlan(null);
        this.plans = new PigPlans(lp);
    }

    public PigPlans getPlans() {
        return this.plans;
    }

    public List<ExecJob> runPlan(LogicalPlan newPlan, String jobName) throws FrontendException, ExecException {
        PigStats stats = this.launchPlan(newPlan, jobName);
        return this.getJobs(stats);
    }

    public static class PigPlans {
        public LogicalPlan lp;

        public PigPlans(LogicalPlan lp) {
            this.lp = lp;
        }
    }
}

