/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputMeta;
import org.pentaho.bigdata.api.format.FormatService;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroInputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class AvroInput
extends BaseFileInputStep<AvroInputMeta, AvroInputData> {
    public static long SPLIT_SIZE = 0x8000000L;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public AvroInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AvroInputMeta)smi;
        this.data = (AvroInputData)sdi;
        try {
            if (((AvroInputData)this.data).input == null || ((AvroInputData)this.data).reader == null || ((AvroInputData)this.data).rowIterator == null) {
                FormatService formatService;
                try {
                    formatService = (FormatService)this.namedClusterServiceLocator.getService(((AvroInputMeta)this.meta).getNamedCluster(), FormatService.class);
                }
                catch (ClusterInitializationException e) {
                    throw new KettleException("can't get service format shim ", (Throwable)e);
                }
                if (((AvroInputMeta)this.meta).getFilename() == null) {
                    throw new KettleException("No output files defined");
                }
                ((AvroInputData)this.data).input = (IPentahoAvroInputFormat)formatService.createInputFormat(IPentahoAvroInputFormat.class);
                ((AvroInputData)this.data).input.setInputFile(((AvroInputMeta)this.meta).getParentStepMeta().getParentTransMeta().environmentSubstitute(((AvroInputMeta)this.meta).getFilename()));
                ((AvroInputData)this.data).input.setInputSchemaFile(((AvroInputMeta)this.meta).getParentStepMeta().getParentTransMeta().environmentSubstitute(((AvroInputMeta)this.meta).getSchemaFilename()));
                ((AvroInputData)this.data).input.setSchema(AvroInput.createSchemaFromMeta((AvroInputMetaBase)this.meta));
                ((AvroInputData)this.data).reader = ((AvroInputData)this.data).input.createRecordReader(null);
                ((AvroInputData)this.data).rowIterator = ((AvroInputData)this.data).reader.iterator();
            }
            if (((AvroInputData)this.data).rowIterator.hasNext()) {
                RowMetaAndData row = ((AvroInputData)this.data).rowIterator.next();
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            ((AvroInputData)this.data).reader.close();
            ((AvroInputData)this.data).reader = null;
            ((AvroInputData)this.data).input = null;
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    protected boolean init() {
        return true;
    }

    protected IBaseFileInputReader createReader(AvroInputMeta meta, AvroInputData data, FileObject file) throws Exception {
        return null;
    }

    public static SchemaDescription retrieveSchema(NamedClusterServiceLocator namedClusterServiceLocator, NamedCluster namedCluster, String schemaPath, String dataPath) throws Exception {
        FormatService formatService = (FormatService)namedClusterServiceLocator.getService(namedCluster, FormatService.class);
        IPentahoAvroInputFormat in = (IPentahoAvroInputFormat)formatService.createInputFormat(IPentahoAvroInputFormat.class);
        return in.readSchema(schemaPath, dataPath);
    }

    public static SchemaDescription createSchemaFromMeta(AvroInputMetaBase meta) {
        SchemaDescription schema = new SchemaDescription();
        for (FormatInputOutputField f : meta.getInpuFields()) {
            SchemaDescription schemaDescription = schema;
            schemaDescription.getClass();
            SchemaDescription.Field field = new SchemaDescription.Field(schemaDescription, f.getPath(), f.getName(), f.getType(), f.getIfNullValue(), true);
            schema.addField(field);
        }
        return schema;
    }
}

