/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.input;

import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputMetaBase;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInput;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.input.AvroInputData;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;

@Step(id="AvroInputNew", image="AI.svg", name="AvroInput.Name", description="AvroInput.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/Avro_Input", i18nPackageName="org.pentaho.di.trans.steps.avro")
@InjectionSupported(localizationPrefix="AvroInput.Injection.", groups={"FIELDS"}, hide={"FILEMASK", "EXCLUDE_FILEMASK", "FILE_REQUIRED", "INCLUDE_SUBFOLDERS", "FIELD_POSITION", "FIELD_LENGTH", "FIELD_IGNORE", "FIELD_FORMAT", "FIELD_PRECISION", "FIELD_CURRENCY", "FIELD_DECIMAL", "FIELD_GROUP", "FIELD_REPEAT", "FIELD_TRIM_TYPE", "ACCEPT_FILE_NAMES", "ACCEPT_FILE_STEP", "PASS_THROUGH_FIELDS", "ACCEPT_FILE_FIELD", "ADD_FILES_TO_RESULT", "IGNORE_ERRORS", "FILE_ERROR_FIELD", "FILE_ERROR_MESSAGE_FIELD", "SKIP_BAD_FILES", "WARNING_FILES_TARGET_DIR", "WARNING_FILES_EXTENTION", "ERROR_FILES_TARGET_DIR", "ERROR_FILES_EXTENTION", "LINE_NR_FILES_TARGET_DIR", "LINE_NR_FILES_EXTENTION", "FILE_SHORT_FILE_FIELDNAME", "FILE_EXTENSION_FIELDNAME", "FILE_PATH_FIELDNAME", "FILE_SIZE_FIELDNAME", "FILE_HIDDEN_FIELDNAME", "FILE_LAST_MODIFICATION_FIELDNAME", "FILE_URI_FIELDNAME", "FILE_ROOT_URI_FIELDNAME", "FILENAME"})
public class AvroInputMeta
extends AvroInputMetaBase {
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final NamedClusterService namedClusterService;

    public AvroInputMeta(NamedClusterServiceLocator namedClusterServiceLocator, NamedClusterService namedClusterService) {
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.namedClusterService = namedClusterService;
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new AvroInput(stepMeta, stepDataInterface, copyNr, transMeta, trans, this.namedClusterServiceLocator);
    }

    public StepDataInterface getStepData() {
        return new AvroInputData();
    }

    public NamedCluster getNamedCluster() {
        return this.namedClusterService.getClusterTemplate();
    }

    public NamedClusterServiceLocator getNamedClusterServiceLocator() {
        return this.namedClusterServiceLocator;
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        try {
            for (int i = 0; i < this.inputFields.size(); ++i) {
                FormatInputOutputField field = (FormatInputOutputField)this.inputFields.get(i);
                String value = space.environmentSubstitute(field.getName());
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)value, (int)field.getType());
                v.setOrigin(origin);
                rowMeta.addValueMeta(v);
            }
        }
        catch (KettlePluginException e) {
            throw new KettleStepException("Unable to create value type", (Throwable)e);
        }
    }
}

