/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.output;

import java.io.IOException;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroFormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.output.AvroOutputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.output.AvroOutputMeta;
import org.pentaho.bigdata.api.format.FormatService;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroOutputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class AvroOutput
extends BaseStep
implements StepInterface {
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private AvroOutputMeta meta;
    private AvroOutputData data;

    public AvroOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] currentRow;
            this.meta = (AvroOutputMeta)smi;
            this.data = (AvroOutputData)sdi;
            if (this.data.output == null) {
                this.init();
            }
            if ((currentRow = this.getRow()) != null) {
                RowMeta outputRMI = new RowMeta();
                Object[] outputData = new Object[this.meta.getOutputFields().size()];
                for (int i = 0; i < this.meta.getOutputFields().size(); ++i) {
                    int inputRowIndex = this.getInputRowMeta().indexOfValue(((AvroFormatInputOutputField)this.meta.getOutputFields().get(i)).getName());
                    if (inputRowIndex == -1) {
                        throw new KettleException("Field name [" + ((AvroFormatInputOutputField)this.meta.getOutputFields().get(i)).getName() + " ] couldn't be found in the input stream!");
                    }
                    ValueMetaInterface vmi = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)this.getInputRowMeta().getValueMeta(inputRowIndex));
                    outputRMI.addValueMeta(i, vmi);
                    outputData[i] = currentRow[inputRowIndex];
                }
                this.data.writer.write(new RowMetaAndData((RowMetaInterface)outputRMI, outputData));
                return true;
            }
            this.closeWriter();
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    public void init() throws Exception {
        IPentahoAvroOutputFormat.COMPRESSION compression;
        FormatService formatService;
        try {
            formatService = (FormatService)this.namedClusterServiceLocator.getService(this.meta.getNamedCluster(), FormatService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        if (this.meta.getFilename() == null) {
            throw new KettleException("No output files defined");
        }
        SchemaDescription schemaDescription = new SchemaDescription();
        for (AvroFormatInputOutputField f : this.meta.getOutputFields()) {
            SchemaDescription schemaDescription2 = schemaDescription;
            schemaDescription2.getClass();
            SchemaDescription.Field field = new SchemaDescription.Field(schemaDescription2, f.getPath(), f.getName(), f.getType(), ValueMetaBase.convertStringToBoolean((String)f.getNullString()).booleanValue());
            field.defaultValue = f.getIfNullValue();
            schemaDescription.addField(field);
        }
        this.data.output = (IPentahoAvroOutputFormat)formatService.createOutputFormat(IPentahoAvroOutputFormat.class);
        this.data.output.setOutputFile(this.meta.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.meta.getFilename()));
        this.data.output.setSchemaDescription(schemaDescription);
        try {
            compression = IPentahoAvroOutputFormat.COMPRESSION.valueOf((String)this.meta.getCompressionType().toUpperCase());
        }
        catch (Exception ex) {
            compression = IPentahoAvroOutputFormat.COMPRESSION.UNCOMPRESSED;
        }
        this.data.output.setCompression(compression);
        this.data.output.setNameSpace(this.meta.getNamespace());
        this.data.output.setRecordName(this.meta.getRecordName());
        this.data.output.setDocValue(this.meta.getDocValue());
        this.data.output.setSchemaFilename(this.meta.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.meta.getSchemaFilename()));
        this.data.writer = this.data.output.createRecordWriter();
    }

    public void closeWriter() throws KettleException {
        try {
            this.data.writer.close();
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
        this.data.output = null;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AvroOutputMeta)smi;
        this.data = (AvroOutputData)sdi;
        return super.init(smi, sdi);
    }
}

