/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.avro.output;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroFormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.NullableValuesEnum;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.BaseAvroStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.avro.output.AvroOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class AvroOutputDialog
extends BaseAvroStepDialog<AvroOutputMeta>
implements StepDialogInterface {
    private static final Class<?> PKG = AvroOutputMeta.class;
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 554;
    private static final int COLUMNS_SEP = 75;
    private static final String SCHEMA_SCHEME_DEFAULT = "hdfs";
    private TableView wOutputFields;
    protected ComboVar wCompression;
    protected TextVar wRecordName;
    protected TextVar wDocValue;
    protected TextVar wNameSpace;
    protected TextVar wSchemaPath;
    protected Button wbSchemaBrowse;

    public AvroOutputDialog(Shell parent, Object avroOutputMeta, TransMeta transMeta, String sname) {
        this(parent, (AvroOutputMeta)((Object)avroOutputMeta), transMeta, sname);
    }

    public AvroOutputDialog(Shell parent, AvroOutputMeta avroOutputMeta, TransMeta transMeta, String sname) {
        super(parent, avroOutputMeta, transMeta, sname);
        this.meta = avroOutputMeta;
    }

    @Override
    protected Control createAfterFile(Composite afterFile) {
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addFieldsTab(wTabFolder);
        this.addSchemaTab(wTabFolder);
        this.addOptionsTab(wTabFolder);
        new BaseAvroStepDialog.FD((Control)wTabFolder).left(0, 0).top(0, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString(PKG, (String)"AvroOutputDialog.Shell.Title", (String[])new String[0]);
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                AvroOutputDialog.this.getFields();
            }
        };
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseAvroStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Path", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Default", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Fields.column.Null", (String[])new String[0]), 2, NullableValuesEnum.getValuesArr(), true)};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        this.wOutputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 7, this.lsMod, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 30, 20, 20, 20, 10});
        this.wOutputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wOutputFields);
        new BaseAvroStepDialog.FD((Control)this.wOutputFields).left(0, 0).right(100, 0).top((Control)wComp, 0).bottom((Control)wGetFields, -10).apply();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        new BaseAvroStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wOutputFields.getTable());
        this.setTruncatedColumn(this.wOutputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wOutputFields.getTable(), 1);
        }
    }

    private void addSchemaTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.TabTitle", (String[])new String[0]));
        Composite wTabComposite = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wTabComposite);
        this.props.setLook((Control)wTabComposite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 15;
        wTabComposite.setLayout((Layout)formLayout);
        Group wSourceGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)wSourceGroup);
        wSourceGroup.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.SourceTitle", (String[])new String[0]));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        wSourceGroup.setLayout((Layout)layout);
        FormData fdSource = new FormData();
        fdSource.top = new FormAttachment(0, 0);
        fdSource.right = new FormAttachment(100, -15);
        fdSource.left = new FormAttachment(0, 15);
        wSourceGroup.setLayoutData((Object)fdSource);
        Label wlSchemaPath = new Label((Composite)wSourceGroup, 131072);
        wlSchemaPath.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.FileName", (String[])new String[0]));
        this.props.setLook((Control)wlSchemaPath);
        new BaseAvroStepDialog.FD((Control)wlSchemaPath).left(0, 0).top(0, 0).apply();
        this.wSchemaPath = new TextVar((VariableSpace)this.transMeta, (Composite)wSourceGroup, 18436);
        this.props.setLook((Control)this.wSchemaPath);
        new BaseAvroStepDialog.FD((Control)this.wSchemaPath).left(0, 0).top((Control)wlSchemaPath, 5).width(350 + VAR_EXTRA_WIDTH).rright().apply();
        this.wbSchemaBrowse = new Button((Composite)wSourceGroup, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbSchemaBrowse.setText(this.getMsg("System.Button.Browse"));
        this.wbSchemaBrowse.addListener(13, event -> this.browseForFileInputPathForSchema());
        int bOffset = (this.wbSchemaBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wSchemaPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        new BaseAvroStepDialog.FD((Control)this.wbSchemaBrowse).left((Control)this.wSchemaPath, 5).top((Control)wlSchemaPath, 5 - bOffset).apply();
        Group wAvroDetailsGroup = new Group(wTabComposite, 32);
        this.props.setLook((Control)wAvroDetailsGroup);
        wAvroDetailsGroup.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.AvroDetailsTitle", (String[])new String[0]));
        layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wSourceGroup.setLayout((Layout)layout);
        wAvroDetailsGroup.setLayout((Layout)layout);
        FormData fdAvroDetailsGroup = new FormData();
        fdAvroDetailsGroup.top = new FormAttachment((Control)wSourceGroup, 15);
        fdAvroDetailsGroup.right = new FormAttachment(100, -15);
        fdAvroDetailsGroup.left = new FormAttachment(0, 15);
        wAvroDetailsGroup.setLayoutData((Object)fdAvroDetailsGroup);
        Label wlNameSpace = new Label((Composite)wAvroDetailsGroup, 131072);
        wlNameSpace.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.Namespace", (String[])new String[0]));
        this.props.setLook((Control)wlNameSpace);
        new BaseAvroStepDialog.FD((Control)wlNameSpace).left(0, 0).top(0, 0).apply();
        this.wNameSpace = new TextVar((VariableSpace)this.transMeta, (Composite)wAvroDetailsGroup, 18436);
        this.props.setLook((Control)this.wNameSpace);
        new BaseAvroStepDialog.FD((Control)this.wNameSpace).left(0, 0).top((Control)wlNameSpace, 5).width(250).rright().apply();
        Label wlRecordName = new Label((Composite)wAvroDetailsGroup, 131072);
        wlRecordName.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.RecordName", (String[])new String[0]));
        this.props.setLook((Control)wlRecordName);
        new BaseAvroStepDialog.FD((Control)wlRecordName).left(0, 0).top((Control)this.wNameSpace, 10).apply();
        this.wRecordName = new TextVar((VariableSpace)this.transMeta, (Composite)wAvroDetailsGroup, 18436);
        this.props.setLook((Control)this.wRecordName);
        new BaseAvroStepDialog.FD((Control)this.wRecordName).left(0, 0).top((Control)wlRecordName, 5).width(250).rright().apply();
        Label wlDocValue = new Label((Composite)wAvroDetailsGroup, 131072);
        wlDocValue.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.DocValue", (String[])new String[0]));
        this.props.setLook((Control)wlDocValue);
        new BaseAvroStepDialog.FD((Control)wlDocValue).left(0, 0).top((Control)this.wRecordName, 10).apply();
        this.wDocValue = new TextVar((VariableSpace)this.transMeta, (Composite)wAvroDetailsGroup, 18436);
        this.props.setLook((Control)this.wDocValue);
        new BaseAvroStepDialog.FD((Control)this.wDocValue).left(0, 0).top((Control)wlDocValue, 5).width(250).rright().apply();
    }

    private void addOptionsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Options.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wComp);
        this.props.setLook((Control)wComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        wComp.setLayout((Layout)formLayout);
        Label lCompression = this.createLabel(wComp, "AvroOutputDialog.Options.Compression");
        new BaseAvroStepDialog.FD((Control)lCompression).left(0, 0).top((Control)wComp, 0).apply();
        this.wCompression = this.createComboVar(wComp, ((AvroOutputMeta)this.meta).getCompressionTypes());
        new BaseAvroStepDialog.FD((Control)this.wCompression).left(0, 0).top((Control)lCompression, 5).width(150 + VAR_EXTRA_WIDTH).apply();
    }

    protected ComboVar createComboVar(Composite container, String[] options) {
        ComboVar combo = new ComboVar((VariableSpace)this.transMeta, container, 18432);
        combo.setItems(options);
        combo.addModifyListener(this.lsMod);
        return combo;
    }

    protected String getComboVarValue(ComboVar combo) {
        String text = combo.getText();
        String data = (String)combo.getData(text);
        return data != null ? data : text;
    }

    private Label createLabel(Composite container, String labelRef) {
        Label label = new Label(container, 0);
        label.setText(BaseMessages.getString(PKG, (String)labelRef, (String[])new String[0]));
        this.props.setLook((Control)label);
        return label;
    }

    @Override
    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        List<String> validationErrorFields = this.validateOutputFields(this.wOutputFields, (AvroOutputMeta)this.meta);
        if (validationErrorFields != null && !validationErrorFields.isEmpty()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"AvroOutput.MissingDefaultFields.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"AvroOutput.MissingDefaultFields.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo((AvroOutputMeta)this.meta, false);
        this.dispose();
    }

    @Override
    protected void getData(AvroOutputMeta meta) {
        if (meta.getFilename() != null) {
            this.wPath.setText(meta.getFilename());
        }
        if (meta.getSchemaFilename() != null) {
            this.wSchemaPath.setText(meta.getSchemaFilename());
        }
        if (meta.getDocValue() != null) {
            this.wDocValue.setText(meta.getDocValue());
        }
        if (meta.getNamespace() != null) {
            this.wNameSpace.setText(meta.getNamespace());
        }
        if (meta.getRecordName() != null) {
            this.wRecordName.setText(meta.getRecordName());
        }
        this.populateFieldsUI(meta, this.wOutputFields);
        this.wCompression.setText(meta.getCompressionType());
    }

    @Override
    protected void getInfo(AvroOutputMeta meta, boolean preview) {
        meta.setFilename(this.wPath.getText());
        meta.setDocValue(this.wDocValue.getText());
        meta.setNamespace(this.wNameSpace.getText());
        meta.setRecordName(this.wRecordName.getText());
        meta.setSchemaFilename(this.wSchemaPath.getText());
        meta.setCompressionType(this.wCompression.getText());
        this.saveOutputFields(this.wOutputFields, meta);
    }

    private void saveOutputFields(TableView wFields, AvroOutputMeta meta) {
        int nrFields = wFields.nrNonEmpty();
        ArrayList<AvroFormatInputOutputField> outputFields = new ArrayList<AvroFormatInputOutputField>();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            AvroFormatInputOutputField field = new AvroFormatInputOutputField();
            field.setPath(item.getText(j++));
            field.setName(item.getText(j++));
            field.setType(item.getText(j++));
            field.setIfNullValue(item.getText(j++));
            field.setNullString(this.getNullableValue(item.getText(j++)));
            outputFields.add(field);
        }
        meta.setOutputFields(outputFields);
    }

    private List<String> validateOutputFields(TableView wFields, AvroOutputMeta meta) {
        int nrFields = wFields.nrNonEmpty();
        ArrayList<String> validationErrorFields = new ArrayList<String>();
        for (int i = 0; i < nrFields; ++i) {
            String nullString;
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            String path = item.getText(j++);
            String name = item.getText(j++);
            String type = item.getText(j++);
            String defaultValue = item.getText(j++);
            if (!(nullString = this.getNullableValue(item.getText(j++))).equals(NullableValuesEnum.NO.getValue()) || defaultValue != null && !defaultValue.trim().isEmpty()) continue;
            validationErrorFields.add(name);
        }
        return validationErrorFields;
    }

    private String getNullableValue(String nullString) {
        return nullString != null && !nullString.isEmpty() ? nullString : NullableValuesEnum.getDefaultValue().getValue();
    }

    private void populateFieldsUI(AvroOutputMeta meta, TableView wOutputFields) {
        this.populateFieldsUI(meta.getOutputFields(), wOutputFields, (field, item) -> {
            int i = 1;
            item.setText(i++, this.coalesce(field.getPath()));
            item.setText(i++, this.coalesce(field.getName()));
            item.setText(i++, this.coalesce(field.getTypeDesc()));
            item.setText(i++, this.coalesce(field.getIfNullValue()));
            item.setText(i++, this.coalesce(field.getNullString()));
        });
    }

    private String coalesce(String value) {
        return value == null ? "" : value;
    }

    private void populateFieldsUI(List<AvroFormatInputOutputField> fields, TableView wFields, BiConsumer<AvroFormatInputOutputField, TableItem> converter) {
        int nrFields = fields.size();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = null;
            item = i < wFields.table.getItemCount() ? wFields.table.getItem(i) : new TableItem(wFields.table, 0);
            converter.accept(fields.get(i), item);
        }
    }

    protected void getFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wOutputFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, (TableItemInsertListener)listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private String getSchemeFromPath(String path) {
        if (Utils.isEmpty((CharSequence)path)) {
            return SCHEMA_SCHEME_DEFAULT;
        }
        int endIndex = path.indexOf(58);
        if (endIndex > 0) {
            return path.substring(0, endIndex);
        }
        return SCHEMA_SCHEME_DEFAULT;
    }

    private void browseForFileInputPathForSchema() {
        try {
            String fileName;
            VfsFileChooserDialog fileChooserDialog;
            String path = this.transMeta.environmentSubstitute(this.wSchemaPath.getText());
            if (Utils.isEmpty((CharSequence)path)) {
                fileChooserDialog = this.getVfsFileChooserDialog(null, null);
                fileName = "hdfs://";
            } else {
                FileObject initialFile = this.getInitialFile(this.wSchemaPath.getText());
                FileObject rootFile = initialFile.getFileSystem().getRoot();
                fileChooserDialog = this.getVfsFileChooserDialog(rootFile, initialFile);
                fileName = null;
            }
            FileObject selectedFile = fileChooserDialog.open(this.shell, null, this.getSchemeFromPath(path), true, fileName, FILES_FILTERS, fileFilterNames, true, 2, true, true);
            if (selectedFile != null) {
                this.wSchemaPath.setText(selectedFile.getURL().toString());
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("AvroInputDialog.SchemaFileBrowser.FileSystemException"));
        }
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 554;
    }

    @Override
    protected Listener getPreview() {
        return null;
    }
}

