/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input;

import java.nio.file.NoSuchFileException;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInputMeta;
import org.pentaho.big.data.kettle.plugins.formats.parquet.input.ParquetInputMetaBase;
import org.pentaho.bigdata.api.format.FormatService;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetInputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class ParquetInput
extends BaseFileInputStep<ParquetInputMeta, ParquetInputData> {
    public static long SPLIT_SIZE = 0x8000000L;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public ParquetInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ParquetInputMeta)smi;
        this.data = (ParquetInputData)sdi;
        try {
            if (((ParquetInputData)this.data).splits == null) {
                this.initSplits();
            }
            if (((ParquetInputData)this.data).currentSplit >= ((ParquetInputData)this.data).splits.size()) {
                this.setOutputDone();
                return false;
            }
            if (((ParquetInputData)this.data).reader == null) {
                this.openReader((ParquetInputData)this.data);
            }
            if (((ParquetInputData)this.data).rowIterator.hasNext()) {
                RowMetaAndData row = ((ParquetInputData)this.data).rowIterator.next();
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            ((ParquetInputData)this.data).reader.close();
            ((ParquetInputData)this.data).reader = null;
            this.logDebug("Close split {0}", new Object[]{((ParquetInputData)this.data).currentSplit});
            ++((ParquetInputData)this.data).currentSplit;
            return true;
        }
        catch (NoSuchFileException ex) {
            throw new KettleException("No input file");
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    void initSplits() throws Exception {
        FormatService formatService = (FormatService)this.namedClusterServiceLocator.getService(((ParquetInputMeta)this.meta).getNamedCluster(), FormatService.class);
        if (((ParquetInputMeta)this.meta).inputFiles == null || ((FormatInputFile)((ParquetInputMeta)this.meta).inputFiles).fileName == null || ((FormatInputFile)((ParquetInputMeta)this.meta).inputFiles).fileName.length == 0) {
            throw new KettleException("No input files defined");
        }
        SchemaDescription schema = ParquetInput.createSchemaFromMeta((ParquetInputMetaBase)this.meta);
        ((ParquetInputData)this.data).input = (IPentahoParquetInputFormat)formatService.createInputFormat(IPentahoParquetInputFormat.class);
        ((ParquetInputData)this.data).input.setSchema(schema);
        String inputFileName = this.environmentSubstitute(((FormatInputFile)((ParquetInputMeta)this.meta).inputFiles).fileName[0]);
        FileObject inputFileObject = KettleVFS.getFileObject((String)inputFileName);
        if (AliasedFileObject.isAliasedFile((FileObject)inputFileObject)) {
            inputFileName = ((AliasedFileObject)inputFileObject).getOriginalURIString();
        }
        ((ParquetInputData)this.data).input.setInputFile(inputFileName);
        ((ParquetInputData)this.data).input.setSplitSize(SPLIT_SIZE);
        ((ParquetInputData)this.data).splits = ((ParquetInputData)this.data).input.getSplits();
        this.logDebug("Input split count: {0}", new Object[]{((ParquetInputData)this.data).splits.size()});
        ((ParquetInputData)this.data).currentSplit = 0;
    }

    void openReader(ParquetInputData data) throws Exception {
        this.logDebug("Open split {0}", new Object[]{data.currentSplit});
        IPentahoInputFormat.IPentahoInputSplit sp = data.splits.get(data.currentSplit);
        data.reader = data.input.createRecordReader(sp);
        data.rowIterator = data.reader.iterator();
    }

    protected boolean init() {
        return true;
    }

    protected IBaseFileInputReader createReader(ParquetInputMeta meta, ParquetInputData data, FileObject file) throws Exception {
        return null;
    }

    public static SchemaDescription retrieveSchema(NamedClusterServiceLocator namedClusterServiceLocator, NamedCluster namedCluster, String path) throws Exception {
        FormatService formatService = (FormatService)namedClusterServiceLocator.getService(namedCluster, FormatService.class);
        IPentahoParquetInputFormat in = (IPentahoParquetInputFormat)formatService.createInputFormat(IPentahoParquetInputFormat.class);
        return in.readSchema(path);
    }

    public static SchemaDescription createSchemaFromMeta(ParquetInputMetaBase meta) {
        SchemaDescription schema = new SchemaDescription();
        for (FormatInputOutputField f : (FormatInputOutputField[])meta.inputFields) {
            SchemaDescription schemaDescription = schema;
            schemaDescription.getClass();
            SchemaDescription.Field field = new SchemaDescription.Field(schemaDescription, f.getPath(), f.getName(), f.getType(), true);
            schema.addField(field);
        }
        return schema;
    }
}

