/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.BaseParquetStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInput;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.ParquetInputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class ParquetInputDialog
extends BaseParquetStepDialog<ParquetInputMeta> {
    private static final int DIALOG_WIDTH = 526;
    private static final int DIALOG_HEIGHT = 506;
    private static final int AVRO_PATH_COLUMN_INDEX = 1;
    private static final int FIELD_NAME_COLUMN_INDEX = 2;
    private static final int FIELD_TYPE_COLUMN_INDEX = 3;
    private TableView wInputFields;

    public ParquetInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (ParquetInputMeta)((Object)in), transMeta, sname);
    }

    @Override
    protected Control createAfterFile(Composite shell) {
        Button wGetFields = new Button(shell, 8);
        wGetFields.setText(BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.Fields.Get", (String[])new String[0]));
        wGetFields.addListener(13, event -> {
            try {
                this.setFields(ParquetInput.retrieveSchema(((ParquetInputMeta)this.meta).namedClusterServiceLocator, ((ParquetInputMeta)this.meta).getNamedCluster(), this.wPath.getText().trim()));
            }
            catch (ClusterInitializationException ex) {
                if (!BaseParquetStepDialog.checkForNonActiveShim(ex)) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        this.props.setLook((Control)wGetFields);
        new BaseParquetStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        Label wlFields = new Label(shell, 131072);
        wlFields.setText(BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        new BaseParquetStepDialog.FD((Control)wlFields).left(0, 0).top(0, 10).apply();
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.Fields.column.AvroPath", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames())};
        this.wInputFields = new TableView((VariableSpace)this.transMeta, shell, 68116, parameterColumns, 7, this.lsMod, this.props);
        this.props.setLook((Control)this.wInputFields);
        new BaseParquetStepDialog.FD((Control)this.wInputFields).left(0, 0).right(100, 0).top((Control)wlFields, 5).bottom((Control)wGetFields, -10).apply();
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 50, 25, 25});
        this.wInputFields.getTable().addListener(11, (Listener)resizer);
        this.setTruncatedColumn(this.wInputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wInputFields.getTable(), 1);
        }
        return wGetFields;
    }

    @Override
    protected void getData(ParquetInputMeta meta) {
        if (((FormatInputFile)meta.inputFiles).fileName.length > 0) {
            this.wPath.setText(((FormatInputFile)meta.inputFiles).fileName[0]);
        }
        int nrFields = ((FormatInputOutputField[])meta.inputFields).length;
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = null;
            item = i < this.wInputFields.table.getItemCount() ? this.wInputFields.table.getItem(i) : new TableItem(this.wInputFields.table, 0);
            FormatInputOutputField inputField = ((FormatInputOutputField[])meta.inputFields)[i];
            if (inputField.getPath() != null) {
                item.setText(1, inputField.getPath());
            }
            if (inputField.getName() != null) {
                item.setText(2, inputField.getName());
            }
            item.setText(3, inputField.getTypeDesc());
        }
    }

    protected void setFields(SchemaDescription schema) {
        this.wInputFields.table.removeAll();
        for (SchemaDescription.Field f : schema) {
            TableItem item = new TableItem(this.wInputFields.table, 0);
            item.setText(1, f.formatFieldName);
            item.setText(2, f.formatFieldName);
            item.setText(3, ValueMetaFactory.getValueMetaName((int)f.pentahoValueMetaType));
        }
    }

    @Override
    protected void getInfo(ParquetInputMeta meta, boolean preview) {
        String filePath = this.wPath.getText();
        if (filePath != null && !filePath.isEmpty()) {
            meta.allocateFiles(1);
            ((FormatInputFile)meta.inputFiles).fileName[0] = this.wPath.getText().trim();
        }
        int nrFields = this.wInputFields.nrNonEmpty();
        meta.inputFields = new FormatInputOutputField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wInputFields.getNonEmpty(i);
            FormatInputOutputField field = new FormatInputOutputField();
            field.setPath(item.getText(1));
            field.setName(item.getText(2));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(3)));
            ((FormatInputOutputField[])meta.inputFields)[i] = field;
        }
    }

    @Override
    protected int getWidth() {
        return 526;
    }

    @Override
    protected int getHeight() {
        return 506;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.Shell.Title", (String[])new String[0]);
    }

    @Override
    protected Listener getPreview() {
        return event -> {
            ParquetInputMeta oneMeta = (ParquetInputMeta)((Object)((Object)((ParquetInputMeta)this.meta).clone()));
            oneMeta.allocateFiles(1);
            ((FormatInputFile)oneMeta.inputFiles).fileName[0] = this.wPath.getText().trim();
            try {
                SchemaDescription schema = ParquetInput.retrieveSchema(((ParquetInputMeta)this.meta).namedClusterServiceLocator, ((ParquetInputMeta)this.meta).getNamedCluster(), ((FormatInputFile)oneMeta.inputFiles).fileName[0]);
                ArrayList<FormatInputOutputField> fields = new ArrayList<FormatInputOutputField>();
                for (SchemaDescription.Field f : schema) {
                    FormatInputOutputField fo = new FormatInputOutputField();
                    fo.setPath(f.formatFieldName);
                    fo.setName(f.formatFieldName);
                    fo.setType(f.pentahoValueMetaType);
                    fields.add(fo);
                }
                oneMeta.inputFields = (BaseFileField[])fields.toArray(new FormatInputOutputField[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"ParquetInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                Trans trans = progressDialog.getTrans();
                String loggingText = progressDialog.getLoggingText();
                if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString((Class)this.PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                prd.open();
            }
        };
    }
}

