/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output;

import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output.ParquetOutputData;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output.ParquetOutputMeta;
import org.pentaho.big.data.kettle.plugins.formats.parquet.output.ParquetOutputMetaBase;
import org.pentaho.bigdata.api.format.FormatService;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetOutputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class ParquetOutput
extends BaseStep
implements StepInterface {
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private ParquetOutputMeta meta;
    private ParquetOutputData data;

    public ParquetOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] currentRow = this.getRow();
            if (this.data.output == null) {
                if (currentRow == null) {
                    this.setOutputDone();
                    return true;
                }
                this.init(this.getInputRowMeta());
            }
            if (currentRow != null) {
                RowMetaAndData row = new RowMetaAndData(this.getInputRowMeta(), currentRow);
                this.data.writer.write(row);
                this.putRow(row.getRowMeta(), row.getData());
                return true;
            }
            this.closeWriter();
            this.setOutputDone();
            return false;
        }
        catch (KettleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
    }

    public void init(RowMetaInterface rowMeta) throws Exception {
        IPentahoParquetOutputFormat.COMPRESSION compression;
        FormatService formatService;
        try {
            formatService = (FormatService)this.namedClusterServiceLocator.getService(this.meta.getNamedCluster(), FormatService.class);
        }
        catch (ClusterInitializationException e) {
            throw new KettleException("can't get service format shim ", (Throwable)e);
        }
        if (this.meta.getFilename() == null) {
            throw new KettleException("No output files defined");
        }
        this.data.output = (IPentahoParquetOutputFormat)formatService.createOutputFormat(IPentahoParquetOutputFormat.class);
        String outputFileName = this.environmentSubstitute(this.meta.constructOutputFilename());
        FileObject outputFileObject = KettleVFS.getFileObject((String)outputFileName);
        if (AliasedFileObject.isAliasedFile((FileObject)outputFileObject)) {
            outputFileName = ((AliasedFileObject)outputFileObject).getOriginalURIString();
        }
        this.data.output.setOutputFile(outputFileName, this.meta.overrideOutput);
        this.data.output.setSchema(this.createSchema(rowMeta));
        try {
            compression = IPentahoParquetOutputFormat.COMPRESSION.valueOf((String)this.meta.getCompressionType(this.variables).name().toUpperCase());
        }
        catch (Exception ex) {
            compression = IPentahoParquetOutputFormat.COMPRESSION.UNCOMPRESSED;
        }
        this.data.output.setCompression(compression);
        this.data.output.setVersion(ParquetOutputMetaBase.ParquetVersion.PARQUET_1.equals((Object)this.meta.getParquetVersion(this.variables)) ? IPentahoParquetOutputFormat.VERSION.VERSION_1_0 : IPentahoParquetOutputFormat.VERSION.VERSION_2_0);
        if (this.meta.getRowGroupSize(this.variables) > 0) {
            this.data.output.setRowGroupSize(this.meta.getRowGroupSize(this.variables) * 1024 * 1024);
        }
        if (this.meta.getDataPageSize(this.variables) > 0) {
            this.data.output.setDataPageSize(this.meta.getDataPageSize(this.variables) * 1024);
        }
        this.data.output.enableDictionary(this.meta.enableDictionary);
        if (this.meta.getDictPageSize(this.variables) > 0) {
            this.data.output.setDictionaryPageSize(this.meta.getDictPageSize(this.variables) * 1024);
        }
        this.data.writer = this.data.output.createRecordWriter();
    }

    private SchemaDescription createSchema(RowMetaInterface rowMeta) {
        SchemaDescription schema = ParquetOutput.createSchemaFromMeta(this.meta);
        if (schema.isEmpty()) {
            for (ValueMetaInterface v : rowMeta.getValueMetaList()) {
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                SchemaDescription.Field field = new SchemaDescription.Field(schemaDescription, v.getName(), v.getName(), v.getType(), true);
                switch (v.getType()) {
                    case 2: {
                        field.defaultValue = "";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        field.defaultValue = "0";
                        break;
                    }
                    case 3: 
                    case 9: {
                        field.defaultValue = "0";
                    }
                }
                schema.addField(field);
            }
        }
        return schema;
    }

    public void closeWriter() throws KettleException {
        try {
            this.data.writer.close();
        }
        catch (IOException e) {
            throw new KettleException((Throwable)e);
        }
        this.data.output = null;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ParquetOutputMeta)smi;
        this.data = (ParquetOutputData)sdi;
        return super.init(smi, sdi);
    }

    public static SchemaDescription createSchemaFromMeta(ParquetOutputMetaBase meta) {
        SchemaDescription schema = new SchemaDescription();
        for (FormatInputOutputField f : meta.outputFields) {
            SchemaDescription schemaDescription = schema;
            schemaDescription.getClass();
            SchemaDescription.Field field = new SchemaDescription.Field(schemaDescription, f.getPath(), f.getName(), f.getType(), f.isNullable());
            field.defaultValue = f.getIfNullValue();
            schema.addField(field);
        }
        return schema;
    }
}

