/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output;

import java.util.Arrays;
import java.util.function.BiConsumer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.impl.NullableValuesEnum;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.BaseParquetStepDialog;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.output.ParquetOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class ParquetOutputDialog
extends BaseParquetStepDialog<ParquetOutputMeta>
implements StepDialogInterface {
    private static final Class<?> PKG = ParquetOutputMeta.class;
    private static final int SHELL_WIDTH = 698;
    private static final int SHELL_HEIGHT = 620;
    private static final int COLUMNS_SEP = 75;
    private static final int OFFSET = 16;
    private TableView wOutputFields;
    private Button wOverwriteExistingFile;
    private ComboVar wCompression;
    private ComboVar wVersion;
    private TextVar wRowSize;
    private TextVar wPageSize;
    private TextVar wExtension;
    private TextVar wDictPageSize;
    private Label lDict;
    private Button wDictionaryEncoding;
    private Button wIncludeDateInFilename;
    private Button wIncludeTimeInFilename;
    private Button wSpecifyDateTimeFormat;
    private ComboVar wDateTimeFormat;

    public ParquetOutputDialog(Shell parent, Object parquetOutputMeta, TransMeta transMeta, String sname) {
        this(parent, (ParquetOutputMeta)((Object)parquetOutputMeta), transMeta, sname);
    }

    public ParquetOutputDialog(Shell parent, ParquetOutputMeta parquetOutputMeta, TransMeta transMeta, String sname) {
        super(parent, parquetOutputMeta, transMeta, sname);
        this.meta = parquetOutputMeta;
    }

    @Override
    protected Control createAfterFile(Composite afterFile) {
        this.wOverwriteExistingFile = new Button(afterFile, 32);
        this.wOverwriteExistingFile.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.OverwriteFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wOverwriteExistingFile);
        new BaseParquetStepDialog.FD((Control)this.wOverwriteExistingFile).left(0, 0).top((Control)afterFile, 10).apply();
        this.wOverwriteExistingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
            }
        });
        CTabFolder wTabFolder = new CTabFolder(afterFile, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        this.addFieldsTab(wTabFolder);
        this.addOptionsTab(wTabFolder);
        new BaseParquetStepDialog.FD((Control)wTabFolder).left(0, 0).top((Control)this.wOverwriteExistingFile, 15).right(100, 0).bottom(100, 0).apply();
        wTabFolder.setSelection(0);
        return wTabFolder;
    }

    @Override
    protected String getStepTitle() {
        return BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Shell.Title", (String[])new String[0]);
    }

    private void addFieldsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wComp);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        wComp.setLayout((Layout)layout);
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                ParquetOutputDialog.this.getFields();
            }
        };
        Button wGetFields = new Button(wComp, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.Get", (String[])new String[0]));
        this.props.setLook((Control)wGetFields);
        new BaseParquetStepDialog.FD((Control)wGetFields).bottom(100, 0).right(100, 0).apply();
        wGetFields.addListener(13, this.lsGet);
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Path", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Default", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Fields.column.Null", (String[])new String[0]), 2, NullableValuesEnum.getValuesArr(), true)};
        parameterColumns[0].setAutoResize(false);
        parameterColumns[1].setUsingVariables(true);
        this.wOutputFields = new TableView((VariableSpace)this.transMeta, wComp, 68116, parameterColumns, 7, this.lsMod, this.props);
        ColumnsResizer resizer = new ColumnsResizer(new int[]{0, 30, 20, 20, 20, 10});
        this.wOutputFields.getTable().addListener(11, (Listener)resizer);
        this.props.setLook((Control)this.wOutputFields);
        new BaseParquetStepDialog.FD((Control)this.wOutputFields).left(0, 0).right(100, 0).top((Control)wComp, 0).bottom((Control)wGetFields, -10).apply();
        this.wOutputFields.setRowNums();
        this.wOutputFields.optWidth(true);
        new BaseParquetStepDialog.FD((Control)wComp).left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).apply();
        wTab.setControl((Control)wComp);
        for (ColumnInfo col : parameterColumns) {
            col.setAutoResize(false);
        }
        resizer.addColumnResizeListeners(this.wOutputFields.getTable());
        this.setTruncatedColumn(this.wOutputFields.getTable(), 1);
        if (!Const.isWindows()) {
            this.addColumnTooltip(this.wOutputFields.getTable(), 1);
        }
    }

    private void addOptionsTab(CTabFolder wTabFolder) {
        CTabItem wTab = new CTabItem(wTabFolder, 0);
        wTab.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.TabTitle", (String[])new String[0]));
        Composite wComp = new Composite((Composite)wTabFolder, 0);
        wTab.setControl((Control)wComp);
        this.props.setLook((Control)wComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        wComp.setLayout((Layout)formLayout);
        Label lCompression = this.createLabel(wComp, "ParquetOutputDialog.Options.Compression");
        new BaseParquetStepDialog.FD((Control)lCompression).left(0, 0).top((Control)wComp, 0).apply();
        this.wCompression = this.createComboVar(wComp, ((ParquetOutputMeta)this.meta).getCompressionTypes());
        new BaseParquetStepDialog.FD((Control)this.wCompression).left(0, 0).top((Control)lCompression, 5).width(100 + VAR_EXTRA_WIDTH).apply();
        Label lVersion = this.createLabel(wComp, "ParquetOutputDialog.Options.Version");
        new BaseParquetStepDialog.FD((Control)lVersion).left(0, 0).top((Control)this.wCompression, 10).apply();
        this.wVersion = this.createComboVar(wComp, ((ParquetOutputMeta)this.meta).getVersionTypes());
        new BaseParquetStepDialog.FD((Control)this.wVersion).left(0, 0).top((Control)lVersion, 5).width(100 + VAR_EXTRA_WIDTH).apply();
        Label lRowSize = this.createLabel(wComp, "ParquetOutputDialog.Options.RowSize");
        new BaseParquetStepDialog.FD((Control)lRowSize).left(0, 0).top((Control)this.wVersion, 10).apply();
        this.wRowSize = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wRowSize).left(0, 0).top((Control)lRowSize, 5).width(100 + VAR_EXTRA_WIDTH).apply();
        this.setIntegerOnly(this.wRowSize);
        this.wRowSize.addModifyListener(this.lsMod);
        Label lDataPageSize = this.createLabel(wComp, "ParquetOutputDialog.Options.PageSize");
        new BaseParquetStepDialog.FD((Control)lDataPageSize).left(0, 0).top((Control)this.wRowSize, 10).apply();
        this.wPageSize = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wPageSize).left(0, 0).top((Control)lDataPageSize, 5).width(100 + VAR_EXTRA_WIDTH).apply();
        this.setIntegerOnly(this.wPageSize);
        this.wPageSize.addModifyListener(this.lsMod);
        this.wDictionaryEncoding = new Button(wComp, 32);
        this.wDictionaryEncoding.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.DictionaryEncoding", (String[])new String[0]));
        this.props.setLook((Control)this.wDictionaryEncoding);
        new BaseParquetStepDialog.FD((Control)this.wDictionaryEncoding).left(0, 0).top((Control)this.wPageSize, 10).apply();
        this.wDictionaryEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
                ParquetOutputDialog.this.actualizeDictionaryPageSizeControl();
            }
        });
        this.lDict = new Label(wComp, 0);
        this.lDict.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.DictPageSize", (String[])new String[0]));
        new BaseParquetStepDialog.FD((Control)this.lDict).left(0, 16).top((Control)this.wDictionaryEncoding, 5).apply();
        this.wDictPageSize = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wDictPageSize).left(0, 16).top((Control)this.lDict, 5).width(100 + VAR_EXTRA_WIDTH - 16).apply();
        this.setIntegerOnly(this.wDictPageSize);
        this.wDictPageSize.addModifyListener(this.lsMod);
        ComboVar leftRef = this.wCompression;
        Label lExtension = new Label(wComp, 0);
        lExtension.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.Extension", (String[])new String[0]));
        new BaseParquetStepDialog.FD((Control)lExtension).left((Control)leftRef, 75).top((Control)wComp, 0).apply();
        this.wExtension = new TextVar((VariableSpace)this.transMeta, wComp, 18436);
        new BaseParquetStepDialog.FD((Control)this.wExtension).left((Control)leftRef, 75).top((Control)lExtension, 5).width(100 + VAR_EXTRA_WIDTH).apply();
        this.wExtension.addModifyListener(this.lsMod);
        this.wIncludeDateInFilename = new Button(wComp, 32);
        this.wIncludeDateInFilename.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.IncludeDateInFilename", (String[])new String[0]));
        this.props.setLook((Control)this.wIncludeDateInFilename);
        new BaseParquetStepDialog.FD((Control)this.wIncludeDateInFilename).left((Control)leftRef, 75).top((Control)this.wExtension, 15).apply();
        this.wIncludeDateInFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
            }
        });
        this.wIncludeTimeInFilename = new Button(wComp, 32);
        this.wIncludeTimeInFilename.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.IncludeTimeInFilename", (String[])new String[0]));
        this.props.setLook((Control)this.wIncludeTimeInFilename);
        new BaseParquetStepDialog.FD((Control)this.wIncludeTimeInFilename).left((Control)leftRef, 75).top((Control)this.wIncludeDateInFilename, 10).apply();
        this.wIncludeTimeInFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
            }
        });
        this.wSpecifyDateTimeFormat = new Button(wComp, 32);
        this.wSpecifyDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"ParquetOutputDialog.Options.SpecifyDateTimeFormat", (String[])new String[0]));
        this.props.setLook((Control)this.wSpecifyDateTimeFormat);
        new BaseParquetStepDialog.FD((Control)this.wSpecifyDateTimeFormat).left((Control)leftRef, 75).top((Control)this.wIncludeTimeInFilename, 10).apply();
        this.wSpecifyDateTimeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ParquetOutputMeta)ParquetOutputDialog.this.meta).setChanged();
                ParquetOutputDialog.this.wDateTimeFormat.setEnabled(ParquetOutputDialog.this.wSpecifyDateTimeFormat.getSelection());
                ParquetOutputDialog.this.actualizeDateTimeControls();
            }
        });
        String[] dates = Const.getDateFormats();
        dates = (String[])Arrays.stream(dates).filter(d -> d.indexOf(47) < 0 && d.indexOf(92) < 0 && d.indexOf(58) < 0).toArray(String[]::new);
        this.wDateTimeFormat = this.createComboVar(wComp, dates);
        this.props.setLook((Control)this.wDateTimeFormat);
        new BaseParquetStepDialog.FD((Control)this.wDateTimeFormat).left((Control)leftRef, 91).top((Control)this.wSpecifyDateTimeFormat, 5).width(200).apply();
        this.wDateTimeFormat.addModifyListener(this.lsMod);
    }

    void actualizeDictionaryPageSizeControl() {
        boolean dictionaryEncoding = this.wDictionaryEncoding.getSelection();
        this.lDict.setEnabled(dictionaryEncoding);
        this.wDictPageSize.setEnabled(dictionaryEncoding);
    }

    void actualizeDateTimeControls() {
        boolean allowedToIncludeDateTime = !this.wSpecifyDateTimeFormat.getSelection();
        this.wIncludeDateInFilename.setEnabled(allowedToIncludeDateTime);
        this.wIncludeTimeInFilename.setEnabled(allowedToIncludeDateTime);
        if (!allowedToIncludeDateTime) {
            this.wIncludeDateInFilename.setSelection(false);
            this.wIncludeTimeInFilename.setSelection(false);
        }
    }

    protected ComboVar createComboVar(Composite container, String[] options) {
        ComboVar combo = new ComboVar((VariableSpace)this.transMeta, container, 18436);
        combo.setItems(options);
        combo.addModifyListener(this.lsMod);
        return combo;
    }

    protected String getComboVarValue(ComboVar combo) {
        String text = combo.getText();
        String data = (String)combo.getData(text);
        return data != null ? data : text;
    }

    private Label createLabel(Composite container, String labelRef) {
        Label label = new Label(container, 0);
        label.setText(BaseMessages.getString(PKG, (String)labelRef, (String[])new String[0]));
        this.props.setLook((Control)label);
        return label;
    }

    @Override
    protected void getData(ParquetOutputMeta meta) {
        if (meta.getFilename() != null) {
            this.wPath.setText(meta.getFilename());
        }
        this.wOverwriteExistingFile.setSelection(meta.isOverrideOutput());
        this.populateFieldsUI(meta, this.wOutputFields);
        this.wCompression.setText(this.coalesce(meta.getCompressionType()));
        this.wVersion.setText(this.coalesce(meta.getParquetVersion()));
        this.wDictionaryEncoding.setSelection(meta.isEnableDictionary());
        this.wDictPageSize.setText(this.coalesce(meta.getDictPageSize()));
        this.wRowSize.setText(this.coalesce(meta.getRowGroupSize()));
        this.wPageSize.setText(this.coalesce(meta.getDataPageSize()));
        this.wExtension.setText(this.coalesce(meta.getExtension()));
        this.wIncludeDateInFilename.setSelection(meta.isDateInFilename());
        this.wIncludeTimeInFilename.setSelection(meta.isTimeInFilename());
        String dateTimeFormat = this.coalesce(meta.getDateTimeFormat());
        if (!dateTimeFormat.isEmpty()) {
            this.wSpecifyDateTimeFormat.setSelection(true);
            this.wDateTimeFormat.setText(dateTimeFormat);
        } else {
            this.wSpecifyDateTimeFormat.setSelection(false);
            this.wDateTimeFormat.setEnabled(false);
        }
        this.actualizeDictionaryPageSizeControl();
        this.actualizeDateTimeControls();
    }

    private String coalesce(String value) {
        return value == null ? "" : value;
    }

    @Override
    protected void getInfo(ParquetOutputMeta meta, boolean preview) {
        meta.setFilename(this.wPath.getText());
        meta.setOverrideOutput(this.wOverwriteExistingFile.getSelection());
        this.saveOutputFields(this.wOutputFields, meta);
        meta.setCompressionType(this.wCompression.getText());
        meta.setParquetVersion(this.wVersion.getText());
        meta.setEnableDictionary(this.wDictionaryEncoding.getSelection());
        meta.setDictPageSize(this.wDictPageSize.getText());
        meta.setRowGroupSize(this.wRowSize.getText());
        meta.setDataPageSize(this.wPageSize.getText());
        meta.setExtension(this.wExtension.getText());
        if (this.wSpecifyDateTimeFormat.getSelection()) {
            meta.setDateTimeFormat(this.wDateTimeFormat.getText());
            meta.setDateInFilename(false);
            meta.setTimeInFilename(false);
        } else {
            meta.setDateTimeFormat(null);
            meta.setDateInFilename(this.wIncludeDateInFilename.getSelection());
            meta.setTimeInFilename(this.wIncludeTimeInFilename.getSelection());
        }
    }

    private void saveOutputFields(TableView wFields, ParquetOutputMeta meta) {
        int nrFields = wFields.nrNonEmpty();
        FormatInputOutputField[] outputFields = new FormatInputOutputField[nrFields];
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = wFields.getNonEmpty(i);
            int j = 1;
            FormatInputOutputField field = new FormatInputOutputField();
            field.setPath(item.getText(j++));
            field.setName(item.getText(j++));
            field.setType(item.getText(j++));
            field.setIfNullValue(item.getText(j++));
            field.setNullable(NullableValuesEnum.YES.getValue().equals(item.getText(j++)));
            outputFields[i] = field;
        }
        meta.outputFields = outputFields;
    }

    private void populateFieldsUI(ParquetOutputMeta meta, TableView wOutputFields) {
        this.populateFieldsUI(meta.outputFields, wOutputFields, (field, item) -> {
            int i = 1;
            item.setText(i++, this.coalesce(field.getPath()));
            item.setText(i++, this.coalesce(field.getName()));
            item.setText(i++, this.coalesce(field.getTypeDesc()));
            item.setText(i++, this.coalesce(field.getIfNullValue()));
            item.setText(i++, field.isNullable() ? NullableValuesEnum.YES.getValue() : NullableValuesEnum.NO.getValue());
        });
    }

    private void populateFieldsUI(FormatInputOutputField[] fields, TableView wFields, BiConsumer<FormatInputOutputField, TableItem> converter) {
        for (int i = 0; i < fields.length; ++i) {
            TableItem item = null;
            item = i < wFields.table.getItemCount() ? wFields.table.getItem(i) : new TableItem(wFields.table, 0);
            converter.accept(fields[i], item);
        }
    }

    protected void getFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wOutputFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, (boolean)false, (TableItemInsertListener)listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    @Override
    protected int getWidth() {
        return 698;
    }

    @Override
    protected int getHeight() {
        return 620;
    }

    @Override
    protected Listener getPreview() {
        return null;
    }
}

