/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.ops4j.spi.NoServiceProviderException;
import org.ops4j.spi.NonUniqueServiceProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderFinder {
    public static <T> List<T> findServiceProviders(Class<T> klass) {
        ServiceLoader<T> loader = ServiceLoader.load(klass);
        ArrayList<T> providers = new ArrayList<T>();
        Iterator<T> it = loader.iterator();
        while (it.hasNext()) {
            providers.add(it.next());
        }
        return providers;
    }

    public static <T> T findAnyServiceProvider(Class<T> klass) {
        ServiceLoader<T> loader = ServiceLoader.load(klass);
        Iterator<T> it = loader.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <T> T loadAnyServiceProvider(Class<T> klass) {
        T provider = ServiceProviderFinder.findAnyServiceProvider(klass);
        if (provider == null) {
            throw new NoServiceProviderException(klass.getName() + ": no service provider found in META-INF/services on classpath");
        }
        return provider;
    }

    public static <T> T loadUniqueServiceProvider(Class<T> klass) {
        List<T> providers = ServiceProviderFinder.findServiceProviders(klass);
        if (providers.isEmpty()) {
            throw new NoServiceProviderException(klass.getName() + ": no service provider found in META-INF/services on classpath");
        }
        if (providers.size() > 1) {
            throw new NonUniqueServiceProviderException(klass.getName() + ": multiple service providers found in META-INF/services on classpath");
        }
        return providers.get(0);
    }
}

