/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMasterFileSystem;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptorMigrationToSubdir;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Private
public class MasterFileSystem {
    private static final Log LOG = LogFactory.getLog(MasterFileSystem.class);
    public static final String HBASE_DIR_PERMS = "hbase.rootdir.perms";
    public static final String HBASE_WAL_DIR_PERMS = "hbase.wal.dir.perms";
    Configuration conf;
    Server master;
    private final MetricsMasterFileSystem metricsMasterFilesystem = new MetricsMasterFileSystem();
    private ClusterId clusterId;
    private final FileSystem fs;
    private final FileSystem walFs;
    private final Path walRootDir;
    private volatile boolean walFsOk = true;
    private final Path oldLogDir;
    private final Path rootdir;
    private final Path tempdir;
    final Lock splitLogLock = new ReentrantLock();
    final boolean distributedLogReplay;
    final SplitLogManager splitLogManager;
    private final MasterServices services;
    static final PathFilter META_FILTER = new PathFilter(){

        public boolean accept(Path p) {
            return DefaultWALProvider.isMetaFile(p);
        }
    };
    static final PathFilter NON_META_FILTER = new PathFilter(){

        public boolean accept(Path p) {
            return !DefaultWALProvider.isMetaFile(p);
        }
    };

    public MasterFileSystem(Server master, MasterServices services) throws IOException {
        this.conf = master.getConfiguration();
        this.master = master;
        this.services = services;
        this.rootdir = FSUtils.getRootDir(this.conf);
        this.tempdir = new Path(this.rootdir, ".tmp");
        this.fs = this.rootdir.getFileSystem(this.conf);
        this.walRootDir = FSUtils.getWALRootDir(this.conf);
        this.walFs = FSUtils.getWALFileSystem(this.conf);
        FSUtils.setFsDefault(this.conf, new Path(this.walFs.getUri()));
        this.walFs.setConf(this.conf);
        FSUtils.setFsDefault(this.conf, new Path(this.fs.getUri()));
        this.fs.setConf(this.conf);
        this.oldLogDir = this.createInitialFileSystemLayout();
        HFileSystem.addLocationsOrderInterceptor(this.conf);
        this.splitLogManager = new SplitLogManager(master, master.getConfiguration(), master, services, master.getServerName());
        this.distributedLogReplay = this.splitLogManager.isLogReplaying();
    }

    @VisibleForTesting
    SplitLogManager getSplitLogManager() {
        return this.splitLogManager;
    }

    private Path createInitialFileSystemLayout() throws IOException {
        this.checkRootDir(this.rootdir, this.conf, this.fs, "hbase.rootdir", HBASE_DIR_PERMS);
        if (!this.walRootDir.equals((Object)this.rootdir)) {
            this.checkRootDir(this.walRootDir, this.conf, this.walFs, "hbase.wal.dir", HBASE_WAL_DIR_PERMS);
        }
        this.checkTempDir(this.tempdir, this.conf, this.fs);
        Path oldLogDir = new Path(this.walRootDir, "oldWALs");
        if (!this.walFs.exists(oldLogDir)) {
            this.walFs.mkdirs(oldLogDir);
        }
        return oldLogDir;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public boolean checkFileSystem() {
        if (this.walFsOk) {
            try {
                FSUtils.checkFileSystemAvailable(this.walFs);
                FSUtils.checkDfsSafeMode(this.conf);
            }
            catch (IOException e) {
                this.master.abort("Shutting down HBase cluster: file system not available", e);
                this.walFsOk = false;
            }
        }
        return this.walFsOk;
    }

    protected FileSystem getWALFileSystem() {
        return this.walFs;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getRootDir() {
        return this.rootdir;
    }

    public Path getWALRootDir() {
        return this.walRootDir;
    }

    public Path getTempDir() {
        return this.tempdir;
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    Set<ServerName> getFailedServersFromLogFolders() {
        boolean retrySplitting = !this.conf.getBoolean("hbase.hlog.split.skip.errors", false);
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        Path logsDirPath = new Path(this.walRootDir, "WALs");
        do {
            if (this.master.isStopped()) {
                LOG.warn((Object)"Master stopped while trying to get failed servers.");
                break;
            }
            try {
                if (!this.walFs.exists(logsDirPath)) {
                    return serverNames;
                }
                FileStatus[] logFolders = FSUtils.listStatus(this.walFs, logsDirPath, null);
                Set<ServerName> onlineServers = ((HMaster)this.master).getServerManager().getOnlineServers().keySet();
                if (logFolders == null || logFolders.length == 0) {
                    LOG.debug((Object)"No log files to split, proceeding...");
                    return serverNames;
                }
                for (FileStatus status : logFolders) {
                    FileStatus[] curLogFiles = FSUtils.listStatus(this.walFs, status.getPath(), null);
                    if (curLogFiles == null || curLogFiles.length == 0) continue;
                    ServerName serverName = DefaultWALProvider.getServerNameFromWALDirectoryName(status.getPath());
                    if (null == serverName) {
                        LOG.warn((Object)("Log folder " + status.getPath() + " doesn't look like its name includes a " + "region server name; leaving in place. If you see later errors about missing " + "write ahead logs they may be saved in this location."));
                        continue;
                    }
                    if (!onlineServers.contains(serverName)) {
                        LOG.info((Object)("Log folder " + status.getPath() + " doesn't belong " + "to a known region server, splitting"));
                        serverNames.add(serverName);
                        continue;
                    }
                    LOG.info((Object)("Log folder " + status.getPath() + " belongs to an existing region server"));
                }
                retrySplitting = false;
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Failed getting failed servers to be recovered.", (Throwable)ioe);
                if (!this.checkFileSystem()) {
                    LOG.warn((Object)"Bad Filesystem, exiting");
                    Runtime.getRuntime().halt(1);
                }
                try {
                    if (!retrySplitting) continue;
                    Thread.sleep(this.conf.getInt("hbase.hlog.split.failure.retry.interval", 30000));
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted, aborting since cannot return w/o splitting");
                    Thread.currentThread().interrupt();
                    retrySplitting = false;
                    Runtime.getRuntime().halt(1);
                }
            }
        } while (retrySplitting);
        return serverNames;
    }

    public void splitLog(ServerName serverName) throws IOException {
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        serverNames.add(serverName);
        this.splitLog(serverNames);
    }

    public void splitMetaLog(ServerName serverName) throws IOException {
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        serverNames.add(serverName);
        this.splitMetaLog(serverNames);
    }

    public void splitMetaLog(Set<ServerName> serverNames) throws IOException {
        this.splitLog(serverNames, META_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="We only release this lock when we set it. Updates to code that uses it should verify use of the guard boolean.")
    private List<Path> getLogDirs(Set<ServerName> serverNames) throws IOException {
        ArrayList<Path> logDirs = new ArrayList<Path>();
        boolean needReleaseLock = false;
        if (!this.services.isInitialized()) {
            this.splitLogLock.lock();
            needReleaseLock = true;
        }
        try {
            for (ServerName serverName : serverNames) {
                Path logDir = new Path(this.walRootDir, DefaultWALProvider.getWALDirectoryName(serverName.toString()));
                Path splitDir = logDir.suffix("-splitting");
                if (this.walFs.exists(logDir)) {
                    if (!this.walFs.rename(logDir, splitDir)) {
                        throw new IOException("Failed fs.rename for log split: " + logDir);
                    }
                    logDir = splitDir;
                    LOG.debug((Object)("Renamed region directory: " + splitDir));
                } else if (!this.walFs.exists(splitDir)) {
                    LOG.info((Object)("Log dir for server " + serverName + " does not exist"));
                    continue;
                }
                logDirs.add(splitDir);
            }
        }
        finally {
            if (needReleaseLock) {
                this.splitLogLock.unlock();
            }
        }
        return logDirs;
    }

    public void prepareLogReplay(ServerName serverName, Set<HRegionInfo> regions) throws IOException {
        if (!this.distributedLogReplay) {
            return;
        }
        if (regions == null || regions.isEmpty()) {
            return;
        }
        this.splitLogManager.markRegionsRecovering(serverName, regions);
    }

    public void splitLog(Set<ServerName> serverNames) throws IOException {
        this.splitLog(serverNames, NON_META_FILTER);
    }

    void removeStaleRecoveringRegionsFromZK(Set<ServerName> failedServers) throws IOException, InterruptedIOException {
        this.splitLogManager.removeStaleRecoveringRegions(failedServers);
    }

    public void splitLog(Set<ServerName> serverNames, PathFilter filter) throws IOException {
        long splitTime = 0L;
        long splitLogSize = 0L;
        List<Path> logDirs = this.getLogDirs(serverNames);
        this.splitLogManager.handleDeadWorkers(serverNames);
        splitTime = EnvironmentEdgeManager.currentTime();
        splitLogSize = this.splitLogManager.splitLogDistributed(serverNames, logDirs, filter);
        splitTime = EnvironmentEdgeManager.currentTime() - splitTime;
        if (this.metricsMasterFilesystem != null) {
            if (filter == META_FILTER) {
                this.metricsMasterFilesystem.addMetaWALSplit(splitTime, splitLogSize);
            } else {
                this.metricsMasterFilesystem.addSplit(splitTime, splitLogSize);
            }
        }
    }

    private Path checkRootDir(Path rd, Configuration c, FileSystem fs, String dirConfKey, String dirPermsConfName) throws IOException {
        FSUtils.waitOnSafeMode(c, c.getInt("hbase.server.thread.wakefrequency", 10000));
        boolean isSecurityEnabled = "kerberos".equalsIgnoreCase(c.get("hbase.security.authentication"));
        FsPermission dirPerms = new FsPermission(c.get(dirPermsConfName, "700"));
        try {
            if (!fs.exists(rd)) {
                if (isSecurityEnabled) {
                    fs.mkdirs(rd, dirPerms);
                } else {
                    fs.mkdirs(rd);
                }
                FSUtils.setVersion(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000), c.getInt("hbase.server.versionfile.writeattempts", 3));
            } else {
                if (!fs.isDirectory(rd)) {
                    throw new IllegalArgumentException(rd.toString() + " is not a directory");
                }
                if (isSecurityEnabled && !dirPerms.equals((Object)fs.getFileStatus(rd).getPermission())) {
                    LOG.warn((Object)("Found rootdir permissions NOT matching expected \"" + dirPermsConfName + "\" for " + "rootdir=" + rd.toString() + " permissions=" + fs.getFileStatus(rd).getPermission() + " and  \"" + dirPermsConfName + "\" configured as " + c.get(dirPermsConfName, "700") + ". Automatically setting the permissions. You" + " can change the permissions by setting \"" + dirPermsConfName + "\" in hbase-site.xml " + "and restarting the master"));
                    fs.setPermission(rd, dirPerms);
                }
                FSUtils.checkVersion(fs, rd, true, c.getInt("hbase.server.thread.wakefrequency", 10000), c.getInt("hbase.server.versionfile.writeattempts", 3));
            }
        }
        catch (DeserializationException de) {
            LOG.fatal((Object)("Please fix invalid configuration for " + dirConfKey), (Throwable)de);
            IOException ioe = new IOException();
            ioe.initCause(de);
            throw ioe;
        }
        catch (IllegalArgumentException iae) {
            LOG.fatal((Object)("Please fix invalid configuration for " + dirConfKey + " " + rd.toString()), (Throwable)iae);
            throw iae;
        }
        if (dirConfKey.equals("hbase.rootdir")) {
            if (!FSUtils.checkClusterIdExists(fs, rd, c.getInt("hbase.server.thread.wakefrequency", 10000))) {
                FSUtils.setClusterId(fs, rd, new ClusterId(), c.getInt("hbase.server.thread.wakefrequency", 10000));
            }
            this.clusterId = FSUtils.getClusterId(fs, rd);
            if (!FSUtils.metaRegionExists(fs, rd)) {
                MasterFileSystem.bootstrap(rd, c);
            } else {
                FSTableDescriptorMigrationToSubdir.migrateFSTableDescriptorsIfNecessary(fs, rd);
            }
            FSTableDescriptors fsd = new FSTableDescriptors(c, fs, rd);
            fsd.createTableDescriptor(new HTableDescriptor(fsd.get(TableName.META_TABLE_NAME)));
        }
        return rd;
    }

    private void checkTempDir(Path tmpdir, Configuration c, FileSystem fs) throws IOException {
        if (fs.exists(tmpdir)) {
            for (Path tabledir : FSUtils.getTableDirs(fs, tmpdir)) {
                for (Path regiondir : FSUtils.getRegionDirs(fs, tabledir)) {
                    HFileArchiver.archiveRegion(fs, this.rootdir, tabledir, regiondir);
                }
            }
            if (!fs.delete(tmpdir, true)) {
                throw new IOException("Unable to clean the temp directory: " + tmpdir);
            }
        }
        if (!fs.mkdirs(tmpdir)) {
            throw new IOException("HBase temp directory '" + tmpdir + "' creation failure.");
        }
    }

    private static void bootstrap(Path rd, Configuration c) throws IOException {
        LOG.info((Object)"BOOTSTRAP: creating hbase:meta region");
        try {
            HRegionInfo metaHRI = new HRegionInfo(HRegionInfo.FIRST_META_REGIONINFO);
            HTableDescriptor metaDescriptor = new FSTableDescriptors(c).get(TableName.META_TABLE_NAME);
            MasterFileSystem.setInfoFamilyCachingForMeta(metaDescriptor, false);
            HRegion meta = HRegion.createHRegion(metaHRI, rd, c, metaDescriptor, null, true, true);
            MasterFileSystem.setInfoFamilyCachingForMeta(metaDescriptor, true);
            HRegion.closeHRegion(meta);
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException((IOException)e);
            LOG.error((Object)"bootstrap", (Throwable)e);
            throw e;
        }
    }

    public static void setInfoFamilyCachingForMeta(HTableDescriptor metaDescriptor, boolean b) {
        for (HColumnDescriptor hcd : metaDescriptor.getColumnFamilies()) {
            if (!Bytes.equals((byte[])hcd.getName(), (byte[])HConstants.CATALOG_FAMILY)) continue;
            hcd.setBlockCacheEnabled(b);
            hcd.setInMemory(b);
        }
    }

    public void deleteRegion(HRegionInfo region) throws IOException {
        HFileArchiver.archiveRegion(this.conf, this.fs, region);
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.fs.delete(FSUtils.getTableDir(this.rootdir, tableName), true);
    }

    public Path moveTableToTemp(TableName tableName) throws IOException {
        Path srcPath = FSUtils.getTableDir(this.rootdir, tableName);
        Path tempPath = FSUtils.getTableDir(this.tempdir, tableName);
        if (!this.fs.exists(tempPath.getParent()) && !this.fs.mkdirs(tempPath.getParent())) {
            throw new IOException("HBase temp directory '" + tempPath.getParent() + "' creation failure.");
        }
        if (!this.fs.rename(srcPath, tempPath)) {
            throw new IOException("Unable to move '" + srcPath + "' to temp '" + tempPath + "'");
        }
        return tempPath;
    }

    public void updateRegionInfo(HRegionInfo region) {
    }

    public void deleteFamilyFromFS(HRegionInfo region, byte[] familyName, boolean hasMob) throws IOException {
        Path tableDir = FSUtils.getTableDir(this.rootdir, region.getTable());
        HFileArchiver.archiveFamily(this.fs, this.conf, region, tableDir, familyName);
        Path familyDir = new Path(tableDir, new Path(region.getEncodedName(), Bytes.toString((byte[])familyName)));
        if (!this.fs.delete(familyDir, true) && this.fs.exists(familyDir)) {
            throw new IOException("Could not delete family " + Bytes.toString((byte[])familyName) + " from FileSystem for region " + region.getRegionNameAsString() + "(" + region.getEncodedName() + ")");
        }
        if (hasMob) {
            Path mobTableDir = FSUtils.getTableDir(new Path(this.getRootDir(), "mobdir"), region.getTable());
            HRegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(region.getTable());
            Path mobFamilyDir = new Path(mobTableDir, new Path(mobRegionInfo.getEncodedName(), Bytes.toString((byte[])familyName)));
            MobUtils.archiveMobStoreFiles(this.conf, this.fs, mobRegionInfo, mobFamilyDir, familyName);
            if (!this.fs.delete(mobFamilyDir, true)) {
                throw new IOException("Could not delete mob store files for family " + Bytes.toString((byte[])familyName) + " from FileSystem region " + mobRegionInfo.getRegionNameAsString() + "(" + mobRegionInfo.getEncodedName() + ")");
            }
        }
    }

    public void stop() {
        if (this.splitLogManager != null) {
            this.splitLogManager.stop();
        }
    }

    public HTableDescriptor deleteColumn(TableName tableName, byte[] familyName) throws IOException {
        LOG.info((Object)("DeleteColumn. Table = " + tableName + " family = " + Bytes.toString((byte[])familyName)));
        HTableDescriptor htd = this.services.getTableDescriptors().get(tableName);
        htd.removeFamily(familyName);
        this.services.getTableDescriptors().add(htd);
        return htd;
    }

    public HTableDescriptor modifyColumn(TableName tableName, HColumnDescriptor hcd) throws IOException {
        LOG.info((Object)("AddModifyColumn. Table = " + tableName + " HCD = " + hcd.toString()));
        HTableDescriptor htd = this.services.getTableDescriptors().get(tableName);
        byte[] familyName = hcd.getName();
        if (!htd.hasFamily(familyName)) {
            throw new InvalidFamilyOperationException("Family '" + Bytes.toString((byte[])familyName) + "' doesn't exists so cannot be modified");
        }
        htd.modifyFamily(hcd);
        this.services.getTableDescriptors().add(htd);
        return htd;
    }

    public HTableDescriptor addColumn(TableName tableName, HColumnDescriptor hcd) throws IOException {
        LOG.info((Object)("AddColumn. Table = " + tableName + " HCD = " + hcd.toString()));
        HTableDescriptor htd = this.services.getTableDescriptors().get(tableName);
        if (htd == null) {
            throw new InvalidFamilyOperationException("Family '" + hcd.getNameAsString() + "' cannot be modified as HTD is null");
        }
        htd.addFamily(hcd);
        this.services.getTableDescriptors().add(htd);
        return htd;
    }

    public void setLogRecoveryMode() throws IOException {
        this.splitLogManager.setRecoveryMode(false);
    }

    public ZooKeeperProtos.SplitLogTask.RecoveryMode getLogRecoveryMode() {
        return this.splitLogManager.getRecoveryMode();
    }

    public void logFileSystemState(Log log) throws IOException {
        FSUtils.logFileSystemState(this.fs, this.rootdir, log);
    }
}

