/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SweepJobNodeTracker
extends ZooKeeperListener {
    private String parentNode;
    private String lockNodePrefix;
    private String owner;
    private String lockNode;

    public SweepJobNodeTracker(ZooKeeperWatcher watcher, String parentNode, String owner) {
        super(watcher);
        this.parentNode = parentNode;
        this.owner = owner;
        this.lockNodePrefix = ZKUtil.joinZNode((String)parentNode, (String)"write-");
    }

    public void start() throws KeeperException {
        this.watcher.registerListener((ZooKeeperListener)this);
        List children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.watcher, (String)this.parentNode);
        if (children != null && !children.isEmpty()) {
            TreeSet<String> sortedChildren = new TreeSet<String>();
            sortedChildren.addAll(children);
            SortedSet<String> tails = sortedChildren.tailSet(this.lockNodePrefix);
            if (!tails.isEmpty()) {
                for (String tail : tails) {
                    String path = ZKUtil.joinZNode((String)this.parentNode, (String)tail);
                    byte[] data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)path);
                    ZooKeeperProtos.TableLock lock = TableLockManager.fromBytes(data);
                    HBaseProtos.ServerName serverName = lock.getLockOwner();
                    ServerName sn = ServerName.valueOf((String)serverName.getHostName(), (int)serverName.getPort(), (long)serverName.getStartCode());
                    if (!this.owner.equals(sn.toString())) continue;
                    this.lockNode = path;
                    return;
                }
            }
        }
        System.exit(1);
    }

    public void nodeDeleted(String path) {
        if (path.equals(this.lockNode)) {
            System.exit(1);
        }
    }
}

