/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.tmpl.QueryProfileTmpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProfileServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(QueryProfileServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String opId = request.getParameter("operationId");
        ServletContext ctx = this.getServletContext();
        SessionManager sessionManager = (SessionManager)ctx.getAttribute("hive.sm");
        OperationManager opManager = sessionManager.getOperationManager();
        QueryInfo queryInfo = opManager.getQueryInfo(opId);
        if (queryInfo == null) {
            LOG.debug("No display object found for operation {} ", (Object)opId);
            return;
        }
        new QueryProfileTmpl().render(response.getWriter(), queryInfo);
    }
}

