/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.aries.rsa.provider.fastbin.api.AsyncCallback;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.AbstractInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.ResponseFuture;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;

public class AsyncFutureInvocationStrategy
extends AbstractInvocationStrategy {
    private FutureCompleter completer = new FutureCompleter();

    @Override
    protected void doService(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        final AbstractInvocationStrategy.AsyncServiceResponse helper = new AbstractInvocationStrategy.AsyncServiceResponse(loader, method, responseStream, onComplete, serializationStrategy);
        try {
            Class<?>[] types = method.getParameterTypes();
            Object[] args = new Object[types.length];
            serializationStrategy.decodeRequest(loader, types, requestStream, args);
            Future future = (Future)method.invoke(target, args);
            CompletableFuture<Object> completable = null;
            completable = future instanceof CompletableFuture ? (CompletableFuture<Object>)future : this.completer.complete(future);
            completable.whenComplete((BiConsumer)new BiConsumer<Object, Throwable>(){

                @Override
                public void accept(Object returnValue, Throwable exception) {
                    helper.send(exception, returnValue);
                }
            });
        }
        catch (Throwable t) {
            helper.send(t, null);
        }
    }

    @Override
    protected ResponseFuture createResponse(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args) throws Exception {
        return new AsyncResponseFuture(loader, method, serializationStrategy, Dispatch.getCurrentQueue());
    }

    @Override
    protected Class getResultType(Method method) {
        try {
            Type type = method.getGenericReturnType();
            ParameterizedType t = (ParameterizedType)type;
            return (Class)t.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return super.getResultType(method);
        }
    }

    private static class FutureCompleter
    extends Thread {
        private ConcurrentMap<Future<Object>, CompletableFuture<Object>> futures;
        private Semaphore counter;
        private AtomicBoolean started;

        public FutureCompleter() {
            this.setName("Fastbin-Future-Completer");
            this.setDaemon(true);
            this.futures = new ConcurrentHashMap<Future<Object>, CompletableFuture<Object>>();
            this.counter = new Semaphore(0);
            this.started = new AtomicBoolean(false);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block7: while (true) {
                takenPermits = Math.max(1, this.counter.availablePermits());
                try {
                    this.counter.acquire(takenPermits);
                }
                catch (InterruptedException e) {
                    continue;
                }
                entrySet = this.futures.entrySet();
                processed = 0;
                var4_5 = entrySet.iterator();
                while (true) {
                    if (!var4_5.hasNext()) continue block7;
                    entry = var4_5.next();
                    if (processed != takenPermits) ** break;
                    continue block7;
                    future = (Future)entry.getKey();
                    if (future.isDone()) {
                        try {
                            object = future.get();
                            ((CompletableFuture)entry.getValue()).complete(object);
                        }
                        catch (ExecutionException e) {
                            ((CompletableFuture)entry.getValue()).completeExceptionally(e.getCause());
                        }
                        catch (Exception e) {
                            ((CompletableFuture)entry.getValue()).completeExceptionally(e);
                        }
                        this.futures.remove(future);
                        ++processed;
                    } else {
                        this.counter.release();
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException var7_11) {
                    }
                }
                break;
            }
        }

        public CompletableFuture<Object> complete(Future<Object> future) {
            if (this.started.compareAndSet(false, true)) {
                this.start();
            }
            CompletableFuture<Object> completable = new CompletableFuture<Object>();
            this.futures.put(future, completable);
            this.counter.release();
            return completable;
        }
    }

    private class AsyncResponseFuture
    implements ResponseFuture,
    AsyncCallback {
        private final ClassLoader loader;
        private final Method method;
        private final SerializationStrategy serializationStrategy;
        private final DispatchQueue queue;
        private CompletableFuture<Object> future;

        public AsyncResponseFuture(ClassLoader loader, Method method, SerializationStrategy serializationStrategy, DispatchQueue queue) {
            this.loader = loader;
            this.method = method;
            this.serializationStrategy = serializationStrategy;
            this.queue = queue;
            this.future = new CompletableFuture();
        }

        @Override
        public void set(final DataByteArrayInputStream source) {
            if (this.queue != null) {
                this.queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        AsyncResponseFuture.this.decodeIt(source);
                    }
                });
            } else {
                this.decodeIt(source);
            }
        }

        private void decodeIt(DataByteArrayInputStream source) {
            try {
                this.serializationStrategy.decodeResponse(this.loader, AsyncFutureInvocationStrategy.this.getResultType(this.method), source, this);
            }
            catch (Throwable e) {
                this.onFailure(e);
            }
        }

        @Override
        public void fail(Throwable throwable) {
            this.onFailure(throwable);
        }

        public void onSuccess(Object result) {
            this.future.complete(result);
        }

        @Override
        public void onFailure(Throwable failure) {
            this.future.completeExceptionally(failure);
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws Exception {
            return this.future;
        }
    }
}

