/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.input;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputMetaBase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class AvroInputMetaBase
extends BaseFileInputMeta<BaseFileInputAdditionalField, FormatInputFile, FormatInputOutputField>
implements ResolvableResource {
    private static final Class<?> PKG = AvroOutputMetaBase.class;
    @Injection(name="AVRO_FILENAME")
    private String filename;
    @Injection(name="SCHEMA_FILENAME")
    protected String schemaFilename;
    protected List<FormatInputOutputField> inputFields = new ArrayList<FormatInputOutputField>();

    public AvroInputMetaBase() {
        this.additionalOutputFields = new BaseFileInputAdditionalField();
        this.inputFiles = new FormatInputFile();
    }

    public void allocateFiles(int nrFiles) {
        ((FormatInputFile)this.inputFiles).environment = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileName = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).excludeFileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileRequired = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).includeSubFolders = new String[nrFiles];
    }

    public String getEncoding() {
        return null;
    }

    public void setDefault() {
        this.allocateFiles(0);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<FormatInputOutputField> getInpuFields() {
        return this.inputFields;
    }

    public void setInputFields(List<FormatInputOutputField> inputFields) {
        this.inputFields = inputFields;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<FormatInputOutputField> avroInputFields = new ArrayList<FormatInputOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                FormatInputOutputField inputField = new FormatInputOutputField();
                inputField.setPath(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                inputField.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                inputField.setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                inputField.setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullable"));
                inputField.setIfNullValue(XMLHandler.getTagValue((Node)fnode, (String)"default"));
                inputField.setSourceType(XMLHandler.getTagValue((Node)fnode, (String)"sourcetype"));
                avroInputFields.add(inputField);
            }
            this.inputFields = avroInputFields;
            this.schemaFilename = XMLHandler.getTagValue((Node)stepnode, (String)"schemaFilename");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        String INDENT = "    ";
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.size(); ++i) {
            FormatInputOutputField field = this.inputFields.get(i);
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getPath()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullable", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)field.getIfNullValue()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"sourcetype", (String)field.getSourceTypeDesc()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaFilename", (String)this.schemaFilename));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            ArrayList<FormatInputOutputField> avroOutputFields = new ArrayList<FormatInputOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                FormatInputOutputField inputField = new FormatInputOutputField();
                inputField.setPath(rep.getStepAttributeString(id_step, i, "path"));
                inputField.setName(rep.getStepAttributeString(id_step, i, "name"));
                inputField.setType(rep.getStepAttributeString(id_step, i, "type"));
                inputField.setIfNullValue(rep.getStepAttributeString(id_step, i, "nullable"));
                inputField.setNullString(rep.getStepAttributeString(id_step, i, "default"));
                inputField.setSourceType(rep.getStepAttributeString(id_step, i, "sourcetype"));
                avroOutputFields.add(inputField);
            }
            this.inputFields = avroOutputFields;
            this.schemaFilename = rep.getStepAttributeString(id_step, "schemaFilename");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            for (int i = 0; i < this.inputFields.size(); ++i) {
                FormatInputOutputField field = this.inputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getPath());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "nullable", field.getIfNullValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "default", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "sourcetype", field.getSourceTypeDesc());
            }
            super.saveRep(rep, metaStore, id_transformation, id_step);
            rep.saveStepAttribute(id_transformation, id_step, "schemaFilename", this.schemaFilename);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void resolve() {
        FileObject fileObject;
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.schemaFilename != null && !this.schemaFilename.isEmpty()) {
            try {
                String realSchemaFilename = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.schemaFilename);
                fileObject = KettleVFS.getFileObject((String)realSchemaFilename);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.schemaFilename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getSchemaFilename() {
        return this.schemaFilename;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }
}

