/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.output;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.avro.AvroFormatInputOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class AvroOutputMetaBase
extends BaseStepMeta
implements StepMetaInterface,
ResolvableResource {
    private static final Class<?> PKG = AvroOutputMetaBase.class;
    @Injection(name="FILENAME")
    private String filename;
    @InjectionDeep
    private List<AvroFormatInputOutputField> outputFields = new ArrayList<AvroFormatInputOutputField>();
    @Injection(name="OPTIONS_COMPRESSION")
    protected String compressionType;
    @Injection(name="SCHEMA_FILENAME")
    protected String schemaFilename;
    @Injection(name="SCHEMA_NAMESPACE")
    protected String namespace;
    @Injection(name="SCHEMA_RECORD_NAME")
    protected String recordName;
    @Injection(name="SCHEMA_DOC_VALUE")
    protected String docValue;

    public void setDefault() {
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<AvroFormatInputOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<AvroFormatInputOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<AvroFormatInputOutputField> avroOutputFields = new ArrayList<AvroFormatInputOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                AvroFormatInputOutputField outputField = new AvroFormatInputOutputField();
                outputField.setPath(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                outputField.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                outputField.setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                outputField.setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullable"));
                outputField.setIfNullValue(XMLHandler.getTagValue((Node)fnode, (String)"default"));
                avroOutputFields.add(outputField);
            }
            this.outputFields = avroOutputFields;
            this.compressionType = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            this.schemaFilename = XMLHandler.getTagValue((Node)stepnode, (String)"schemaFilename");
            this.namespace = XMLHandler.getTagValue((Node)stepnode, (String)"namespace");
            this.docValue = XMLHandler.getTagValue((Node)stepnode, (String)"docValue");
            this.recordName = XMLHandler.getTagValue((Node)stepnode, (String)"recordName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        String INDENT = "    ";
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.size(); ++i) {
            AvroFormatInputOutputField field = this.outputFields.get(i);
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getPath()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullable", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)field.getIfNullValue()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"compression", (String)this.compressionType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaFilename", (String)this.schemaFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"namespace", (String)this.namespace));
        retval.append("    ").append(XMLHandler.addTagValue((String)"docValue", (String)this.docValue));
        retval.append("    ").append(XMLHandler.addTagValue((String)"recordName", (String)this.recordName));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            ArrayList<AvroFormatInputOutputField> avroOutputFields = new ArrayList<AvroFormatInputOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                AvroFormatInputOutputField outputField = new AvroFormatInputOutputField();
                outputField.setPath(rep.getStepAttributeString(id_step, i, "path"));
                outputField.setName(rep.getStepAttributeString(id_step, i, "name"));
                outputField.setType(rep.getStepAttributeString(id_step, i, "type"));
                outputField.setNullString(rep.getStepAttributeString(id_step, i, "nullable"));
                outputField.setIfNullValue(rep.getStepAttributeString(id_step, i, "default"));
                avroOutputFields.add(outputField);
            }
            this.outputFields = avroOutputFields;
            this.compressionType = rep.getStepAttributeString(id_step, "compression");
            this.schemaFilename = rep.getStepAttributeString(id_step, "schemaFilename");
            this.namespace = rep.getStepAttributeString(id_step, "namespace");
            this.docValue = rep.getStepAttributeString(id_step, "docValue");
            this.recordName = rep.getStepAttributeString(id_step, "recordName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            for (int i = 0; i < this.outputFields.size(); ++i) {
                AvroFormatInputOutputField field = this.outputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getPath());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "nullable", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "default", field.getIfNullValue());
            }
            super.saveRep(rep, metaStore, id_transformation, id_step);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.compressionType);
            rep.saveStepAttribute(id_transformation, id_step, "schemaFilename", this.schemaFilename);
            rep.saveStepAttribute(id_transformation, id_step, "namespace", this.namespace);
            rep.saveStepAttribute(id_transformation, id_step, "docValue", this.docValue);
            rep.saveStepAttribute(id_transformation, id_step, "recordName", this.recordName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void resolve() {
        FileObject fileObject;
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.schemaFilename != null && !this.schemaFilename.isEmpty()) {
            try {
                String realSchemaFilename = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.schemaFilename);
                fileObject = KettleVFS.getFileObject((String)realSchemaFilename);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.schemaFilename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getSchemaFilename() {
        return this.schemaFilename;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getDocValue() {
        return this.docValue;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public String getCompressionType() {
        return StringUtil.isVariable((String)this.compressionType) ? this.compressionType : this.getCompressionType(null).toString();
    }

    public void setCompressionType(String value) {
        this.compressionType = StringUtil.isVariable((String)value) ? value : ((CompressionType)AvroOutputMetaBase.parseFromToString(value, CompressionType.values(), null)).name();
    }

    public CompressionType getCompressionType(VariableSpace vspace) {
        return this.parseReplace(this.compressionType, vspace, str -> CompressionType.valueOf(str), CompressionType.NONE);
    }

    public String[] getCompressionTypes() {
        return AvroOutputMetaBase.getStrings(CompressionType.values());
    }

    protected static <T> String[] getStrings(T[] objects) {
        String[] names = new String[objects.length];
        int i = 0;
        for (T obj : objects) {
            names[i++] = obj.toString();
        }
        return names;
    }

    protected static <T> T parseFromToString(String str, T[] values, T defaultValue) {
        if (!Utils.isEmpty((CharSequence)str)) {
            for (T type : values) {
                if (!str.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
        }
        return defaultValue;
    }

    private <T> T parseReplace(String value, VariableSpace vspace, Function<String, T> parser, T defaultValue) {
        String replaced;
        String string = replaced = vspace != null ? vspace.environmentSubstitute(value) : value;
        if (!Utils.isEmpty((CharSequence)replaced)) {
            try {
                return parser.apply(replaced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static String getMsg(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    static /* synthetic */ String access$000(String x0) {
        return AvroOutputMetaBase.getMsg(x0);
    }

    protected static class FieldNames {
        public static final String COMPRESSION = "compression";
        public static final String SCHEMA_FILENAME = "schemaFilename";
        public static final String RECORD_NAME = "recordName";
        public static final String DOC_VALUE = "docValue";
        public static final String NAMESPACE = "namespace";

        protected FieldNames() {
        }
    }

    public static enum CompressionType {
        NONE(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.NONE")),
        DEFLATE(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.DEFLATE")),
        SNAPPY(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.SNAPPY"));

        private final String name;

        private CompressionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

