/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.parquet.input;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class ParquetInputMetaBase
extends BaseFileInputMeta<BaseFileInputAdditionalField, FormatInputFile, FormatInputOutputField>
implements ResolvableResource {
    public ParquetInputMetaBase() {
        this.additionalOutputFields = new BaseFileInputAdditionalField();
        this.inputFiles = new FormatInputFile();
        this.inputFields = new FormatInputOutputField[0];
    }

    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(1500);
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < ((FormatInputFile)this.inputFiles).fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"environment", (String)((FormatInputFile)this.inputFiles).environment[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)((FormatInputFile)this.inputFiles).fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)((FormatInputFile)this.inputFiles).fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)((FormatInputFile)this.inputFiles).excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)((FormatInputFile)this.inputFiles).fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)((FormatInputFile)this.inputFiles).includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < ((FormatInputOutputField[])this.inputFields).length; ++i) {
            FormatInputOutputField field = ((FormatInputOutputField[])this.inputFields)[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getPath()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ifnull", (String)field.getIfNullValue()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"position", (int)field.getPosition()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)field.isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            for (i = 0; i < ((FormatInputFile)this.inputFiles).fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "environment", ((FormatInputFile)this.inputFiles).environment[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", ((FormatInputFile)this.inputFiles).fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", ((FormatInputFile)this.inputFiles).fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", ((FormatInputFile)this.inputFiles).excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", ((FormatInputFile)this.inputFiles).fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", ((FormatInputFile)this.inputFiles).includeSubFolders[i]);
            }
            for (i = 0; i < ((FormatInputOutputField[])this.inputFields).length; ++i) {
                FormatInputOutputField field = ((FormatInputOutputField[])this.inputFields)[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getPath());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ifnull", field.getIfNullValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_position", (long)field.getPosition());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", (long)field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", (long)field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        int i;
        Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
        int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
        this.allocateFiles(nrfiles);
        for (i = 0; i < nrfiles; ++i) {
            Node envnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"environment", (int)i);
            Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
            Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
            Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
            Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
            Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
            ((FormatInputFile)this.inputFiles).environment[i] = XMLHandler.getNodeValue((Node)envnode);
            ((FormatInputFile)this.inputFiles).fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
            ((FormatInputFile)this.inputFiles).fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
            ((FormatInputFile)this.inputFiles).excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
            ((FormatInputFile)this.inputFiles).fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
            ((FormatInputFile)this.inputFiles).includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
        }
        this.inputFields = new FormatInputOutputField[nrfields];
        for (i = 0; i < nrfields; ++i) {
            Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            FormatInputOutputField field = new FormatInputOutputField();
            field.setPath(XMLHandler.getTagValue((Node)fnode, (String)"path"));
            field.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
            field.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
            field.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
            field.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
            field.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
            field.setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullif"));
            field.setIfNullValue(XMLHandler.getTagValue((Node)fnode, (String)"ifnull"));
            field.setPosition(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"position"), (int)-1));
            field.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
            field.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
            field.setTrimType(ValueMetaString.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
            field.setRepeated("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
            ((FormatInputOutputField[])this.inputFields)[i] = field;
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            this.allocateFiles(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                ((FormatInputFile)this.inputFiles).environment[i] = rep.getStepAttributeString(id_step, i, "environment");
                ((FormatInputFile)this.inputFiles).fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                ((FormatInputFile)this.inputFiles).fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                ((FormatInputFile)this.inputFiles).excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                ((FormatInputFile)this.inputFiles).fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!"Y".equalsIgnoreCase(((FormatInputFile)this.inputFiles).fileRequired[i])) {
                    ((FormatInputFile)this.inputFiles).fileRequired[i] = "N";
                }
                ((FormatInputFile)this.inputFiles).includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if ("Y".equalsIgnoreCase(((FormatInputFile)this.inputFiles).includeSubFolders[i])) continue;
                ((FormatInputFile)this.inputFiles).includeSubFolders[i] = "N";
            }
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.inputFields = new FormatInputOutputField[nrfields];
            for (int i = 0; i < nrfields; ++i) {
                FormatInputOutputField field = new FormatInputOutputField();
                field.setPath(rep.getStepAttributeString(id_step, i, "path"));
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                field.setIfNullValue(rep.getStepAttributeString(id_step, i, "field_ifnull"));
                field.setPosition((int)rep.getStepAttributeInteger(id_step, i, "field_position"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(ValueMetaString.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                ((FormatInputOutputField[])this.inputFields)[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void allocateFiles(int nrFiles) {
        ((FormatInputFile)this.inputFiles).environment = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileName = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).excludeFileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileRequired = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).includeSubFolders = new String[nrFiles];
    }

    public String getEncoding() {
        return null;
    }

    public void setDefault() {
        this.allocateFiles(0);
        this.inputFields = new FormatInputOutputField[0];
    }

    public void resolve() {
        if (this.inputFiles != null && ((FormatInputFile)this.inputFiles).fileName != null) {
            for (int i = 0; i < ((FormatInputFile)this.inputFiles).fileName.length; ++i) {
                try {
                    String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(((FormatInputFile)this.inputFiles).fileName[i]);
                    FileObject fileObject = KettleVFS.getFileObject((String)realFileName);
                    if (!AliasedFileObject.isAliasedFile((FileObject)fileObject)) continue;
                    ((FormatInputFile)this.inputFiles).fileName[i] = ((AliasedFileObject)fileObject).getOriginalURIString();
                    continue;
                }
                catch (KettleFileException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

