/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.parquet.output;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class ParquetOutputMetaBase
extends BaseStepMeta
implements StepMetaInterface,
ResolvableResource {
    private static final Class<?> PKG = ParquetOutputMetaBase.class;
    @Injection(name="COMPRESSION")
    public String compressionType;
    @Injection(name="PARQUET_VERSION")
    public String parquetVersion;
    @Injection(name="ROW_GROUP_SIZE")
    public String rowGroupSize;
    @Injection(name="DATA_PAGE_SIZE")
    public String dataPageSize;
    @Injection(name="ENABLE_DICTIONARY")
    public boolean enableDictionary;
    @Injection(name="DICT_PAGE_SIZE")
    public String dictPageSize;
    @Injection(name="OVERRIDE_OUTPUT")
    public boolean overrideOutput;
    @Injection(name="INC_DATE_IN_FILENAME")
    private boolean dateInFilename;
    @Injection(name="INC_TIME_IN_FILENAME")
    private boolean timeInFilename;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;
    @Injection(name="EXTENSION")
    private String extension;
    @Injection(name="FILENAME", group="FILENAME_LINES")
    public String filename;
    @InjectionDeep
    public FormatInputOutputField[] outputFields = new FormatInputOutputField[0];

    public void setDefault() {
        this.outputFields = new FormatInputOutputField[0];
        this.dictPageSize = String.valueOf(1024);
        this.extension = "parquet";
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isEnableDictionary() {
        return this.enableDictionary;
    }

    public void setEnableDictionary(boolean enableDictionary) {
        this.enableDictionary = enableDictionary;
    }

    public boolean isOverrideOutput() {
        return this.overrideOutput;
    }

    public void setOverrideOutput(boolean overrideOutput) {
        this.overrideOutput = overrideOutput;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public FormatInputOutputField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(FormatInputOutputField[] outputFields) {
        this.outputFields = outputFields;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.overrideOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"overrideOutput"));
            this.enableDictionary = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"enableDictionary"));
            this.compressionType = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            this.parquetVersion = XMLHandler.getTagValue((Node)stepnode, (String)"parquetVersion");
            this.rowGroupSize = XMLHandler.getTagValue((Node)stepnode, (String)"rowGroupSize");
            this.dataPageSize = XMLHandler.getTagValue((Node)stepnode, (String)"dataPageSize");
            this.dictPageSize = XMLHandler.getTagValue((Node)stepnode, (String)"dictPageSize");
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"extension");
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dateInFilename"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"timeInFilename"));
            this.dateTimeFormat = XMLHandler.getTagValue((Node)stepnode, (String)"dateTimeFormat");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<FormatInputOutputField> parquetOutputFields = new ArrayList<FormatInputOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                FormatInputOutputField outputField = new FormatInputOutputField();
                outputField.setPath(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                outputField.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                outputField.setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                outputField.setNullable("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"nullable")));
                outputField.setIfNullValue(XMLHandler.getTagValue((Node)fnode, (String)"default"));
                parquetOutputFields.add(outputField);
            }
            this.outputFields = parquetOutputFields.toArray(new FormatInputOutputField[0]);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"overrideOutput", (boolean)this.overrideOutput));
        retval.append("    ").append(XMLHandler.addTagValue((String)"compression", (String)this.compressionType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"parquetVersion", (String)this.parquetVersion));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enableDictionary", (boolean)this.enableDictionary));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dictPageSize", (String)this.dictPageSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowGroupSize", (String)this.rowGroupSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dataPageSize", (String)this.dataPageSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extension", (String)this.extension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateInFilename", (boolean)this.dateInFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timeInFilename", (boolean)this.timeInFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateTimeFormat", (String)this.dateTimeFormat));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            FormatInputOutputField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getPath()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullable", (boolean)field.isNullable()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)field.getIfNullValue()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.overrideOutput = rep.getStepAttributeBoolean(id_step, "overrideOutput");
            this.compressionType = rep.getStepAttributeString(id_step, "compression");
            this.parquetVersion = rep.getStepAttributeString(id_step, "parquetVersion");
            this.enableDictionary = rep.getStepAttributeBoolean(id_step, "enableDictionary");
            this.dictPageSize = rep.getStepAttributeString(id_step, "dictPageSize");
            this.rowGroupSize = rep.getStepAttributeString(id_step, "rowGroupSize");
            this.dataPageSize = rep.getStepAttributeString(id_step, "dataPageSize");
            this.extension = rep.getStepAttributeString(id_step, "extension");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "dateInFilename");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "timeInFilename");
            this.dateTimeFormat = rep.getStepAttributeString(id_step, "dateTimeFormat");
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            ArrayList<FormatInputOutputField> parquetOutputFields = new ArrayList<FormatInputOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                FormatInputOutputField outputField = new FormatInputOutputField();
                outputField.setPath(rep.getStepAttributeString(id_step, i, "path"));
                outputField.setName(rep.getStepAttributeString(id_step, i, "name"));
                outputField.setType(rep.getStepAttributeString(id_step, i, "type"));
                outputField.setNullable(rep.getStepAttributeBoolean(id_step, i, "nullable"));
                outputField.setIfNullValue(rep.getStepAttributeString(id_step, i, "default"));
                parquetOutputFields.add(outputField);
            }
            this.outputFields = parquetOutputFields.toArray(new FormatInputOutputField[0]);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "overrideOutput", this.overrideOutput);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.compressionType);
            rep.saveStepAttribute(id_transformation, id_step, "parquetVersion", this.parquetVersion);
            rep.saveStepAttribute(id_transformation, id_step, "enableDictionary", this.enableDictionary);
            rep.saveStepAttribute(id_transformation, id_step, "dictPageSize", this.dictPageSize);
            rep.saveStepAttribute(id_transformation, id_step, "rowGroupSize", this.rowGroupSize);
            rep.saveStepAttribute(id_transformation, id_step, "dataPageSize", this.dataPageSize);
            rep.saveStepAttribute(id_transformation, id_step, "extension", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "dateInFilename", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "timeInFilename", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "dateTimeFormat", this.dateTimeFormat);
            for (int i = 0; i < this.outputFields.length; ++i) {
                FormatInputOutputField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getPath());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "nullable", field.isNullable());
                rep.saveStepAttribute(id_transformation, id_step, i, "default", field.getIfNullValue());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void resolve() {
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                FileObject fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String constructOutputFilename() {
        String outputFileName = this.filename;
        if (this.dateTimeFormat != null && !this.dateTimeFormat.isEmpty()) {
            String dateTimeFormatPattern = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.dateTimeFormat);
            outputFileName = outputFileName + new SimpleDateFormat(dateTimeFormatPattern).format(new Date());
        } else {
            if (this.dateInFilename) {
                outputFileName = outputFileName + '_' + new SimpleDateFormat("yyyyMMdd").format(new Date());
            }
            if (this.timeInFilename) {
                outputFileName = outputFileName + '_' + new SimpleDateFormat("HHmmss").format(new Date());
            }
        }
        if (this.extension != null && !this.extension.isEmpty()) {
            outputFileName = outputFileName + '.' + this.extension;
        }
        return outputFileName;
    }

    public int getRowGroupSize(VariableSpace vspace) {
        return this.parseReplace(this.rowGroupSize, vspace, str -> Integer.parseInt(str), 0);
    }

    protected <T> T parseReplace(String value, VariableSpace vspace, Function<String, T> parser, T defaultValue) {
        String replaced;
        String string = replaced = vspace != null ? vspace.environmentSubstitute(value) : value;
        if (!Utils.isEmpty((CharSequence)replaced)) {
            try {
                return parser.apply(replaced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getRowGroupSize() {
        return this.rowGroupSize;
    }

    public void setRowGroupSize(String value) {
        this.rowGroupSize = value;
    }

    public String getCompressionType() {
        return StringUtil.isVariable((String)this.compressionType) ? this.compressionType : this.getCompressionType(null).toString();
    }

    public void setCompressionType(String value) {
        this.compressionType = StringUtil.isVariable((String)value) ? value : ((CompressionType)ParquetOutputMetaBase.parseFromToString(value, CompressionType.values(), null)).name();
    }

    public CompressionType getCompressionType(VariableSpace vspace) {
        return this.parseReplace(this.compressionType, vspace, str -> CompressionType.valueOf(str), CompressionType.NONE);
    }

    public String getParquetVersion() {
        return StringUtil.isVariable((String)this.parquetVersion) ? this.parquetVersion : this.getParquetVersion(null).toString();
    }

    public void setParquetVersion(String value) {
        this.parquetVersion = StringUtil.isVariable((String)value) ? value : ((ParquetVersion)ParquetOutputMetaBase.parseFromToString(value, ParquetVersion.values(), null)).name();
    }

    public ParquetVersion getParquetVersion(VariableSpace vspace) {
        return this.parseReplace(this.parquetVersion, vspace, str -> ParquetVersion.valueOf(str), ParquetVersion.PARQUET_1);
    }

    public int getDataPageSize(VariableSpace vspace) {
        return this.parseReplace(this.dataPageSize, vspace, s -> Integer.parseInt(s), 0);
    }

    public String getDataPageSize() {
        return this.dataPageSize;
    }

    public void setDataPageSize(String dataPageSize) {
        this.dataPageSize = dataPageSize;
    }

    public int getDictPageSize(VariableSpace vspace) {
        return this.parseReplace(this.dictPageSize, vspace, s -> Integer.parseInt(s), 0);
    }

    public String getDictPageSize() {
        return this.dictPageSize;
    }

    public void setDictPageSize(String dictPageSize) {
        this.dictPageSize = dictPageSize;
    }

    public String[] getCompressionTypes() {
        return ParquetOutputMetaBase.getStrings(CompressionType.values());
    }

    public String[] getVersionTypes() {
        return ParquetOutputMetaBase.getStrings(ParquetVersion.values());
    }

    protected static <T> String[] getStrings(T[] objects) {
        String[] names = new String[objects.length];
        int i = 0;
        for (T obj : objects) {
            names[i++] = obj.toString();
        }
        return names;
    }

    protected static <T> T parseFromToString(String str, T[] values, T defaultValue) {
        if (!Utils.isEmpty((CharSequence)str)) {
            for (T type : values) {
                if (!str.equals(type.toString())) continue;
                return type;
            }
        }
        return defaultValue;
    }

    private static String getMsg(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    public static enum ParquetVersion {
        PARQUET_1("Parquet 1.0"),
        PARQUET_2("Parquet 2.0");

        private final String uiName;

        private ParquetVersion(String name) {
            this.uiName = name;
        }

        public String toString() {
            return this.uiName;
        }
    }

    public static enum CompressionType {
        NONE("None"),
        SNAPPY("Snappy"),
        GZIP("GZIP");

        private final String uiName;

        private CompressionType(String name) {
            this.uiName = name;
        }

        public String toString() {
            return this.uiName;
        }
    }
}

