/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra;

import com.datastax.driver.core.DataType;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.thrift.Compression;
import org.pentaho.cassandra.ConnectionFactory;
import org.pentaho.cassandra.spi.ColumnFamilyMetaData;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;

public class CassandraUtils {
    protected static final Class<?> PKG = CassandraUtils.class;

    public static String getCQLTypeForValueMeta(ValueMetaInterface vm) {
        switch (vm.getType()) {
            case 2: {
                return "varchar";
            }
            case 6: {
                return "decimal";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "bigint";
            }
            case 1: {
                return "double";
            }
            case 3: 
            case 9: {
                return "timestamp";
            }
            case 7: 
            case 8: {
                return "blob";
            }
        }
        return "blob";
    }

    public static DataType getCassandraDataTypeFromValueMeta(ValueMetaInterface vm) {
        switch (vm.getType()) {
            case 2: {
                return DataType.varchar();
            }
            case 6: {
                return DataType.decimal();
            }
            case 4: {
                return DataType.cboolean();
            }
            case 5: {
                return DataType.bigint();
            }
            case 1: {
                return DataType.cdouble();
            }
            case 3: 
            case 9: {
                return DataType.timestamp();
            }
        }
        return DataType.blob();
    }

    public static List<String> splitCQLStatements(String source) {
        String[] cqlStatements = source.split(";");
        ArrayList<String> individualStatements = new ArrayList<String>();
        if (cqlStatements.length > 0) {
            for (String cqlC : cqlStatements) {
                if (!(cqlC = cqlC.trim()).endsWith(";")) {
                    cqlC = cqlC + ";";
                }
                individualStatements.add(cqlC);
            }
        }
        return individualStatements;
    }

    public static byte[] compressCQLQuery(String queryStr, Compression compression) {
        byte[] data = queryStr.getBytes(Charset.forName("UTF-8"));
        if (compression != Compression.GZIP) {
            return data;
        }
        Deflater compressor = new Deflater();
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int size = compressor.deflate(buffer);
            byteArray.write(buffer, 0, size);
        }
        return byteArray.toByteArray();
    }

    public static String getColumnFamilyNameFromCQLSelectQuery(String subQ) {
        String result = null;
        if (Utils.isEmpty((CharSequence)subQ)) {
            return null;
        }
        if (!subQ.toLowerCase().startsWith("select")) {
            return null;
        }
        if (subQ.indexOf(59) < 0) {
            return null;
        }
        if (subQ.toLowerCase().lastIndexOf("where") > 0) {
            subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
        }
        int fromIndex = subQ.toLowerCase().indexOf("from");
        String tempS = subQ.toLowerCase();
        int offset = fromIndex;
        while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
            tempS = tempS.substring(fromIndex + 4, tempS.length());
            fromIndex = tempS.indexOf("from");
            offset += 4 + fromIndex;
        }
        fromIndex = offset;
        if (fromIndex < 0) {
            return null;
        }
        result = subQ.substring(fromIndex + 4, subQ.length()).trim();
        result = result.indexOf(32) > 0 ? result.substring(0, result.indexOf(32)) : result.replace(";", "");
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String rowToStringRepresentation(RowMetaInterface inputMeta, Object[] row) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < inputMeta.size(); ++i) {
            String sep;
            String string = sep = i > 0 ? "," : "";
            if (row[i] == null) {
                buff.append(sep).append("<null>");
                continue;
            }
            buff.append(sep).append(row[i].toString());
        }
        return buff.toString();
    }

    protected static boolean preAddChecks(RowMetaInterface inputMeta, List<String> keyColNames, Object[] row, LogChannelInterface log) throws KettleException {
        for (String string : keyColNames) {
            int keyIndex = inputMeta.indexOfValue(string);
            ValueMetaInterface keyMeta = inputMeta.getValueMeta(keyIndex);
            if (!keyMeta.isNull(row[keyIndex])) continue;
            log.logBasic(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.SkippingRowNullKey", (String[])new String[]{CassandraUtils.rowToStringRepresentation(inputMeta, row)}));
            return false;
        }
        StringBuilder fullKey = new StringBuilder();
        for (String keyN : keyColNames) {
            int keyIndex = inputMeta.indexOfValue(keyN);
            ValueMetaInterface keyMeta = inputMeta.getValueMeta(keyIndex);
            fullKey.append(keyMeta.getString(row[keyIndex])).append(" ");
        }
        if (keyColNames.size() == 1) {
            boolean bl;
            boolean bl2 = false;
            for (int i = 0; i < inputMeta.size(); ++i) {
                ValueMetaInterface v;
                String colName = inputMeta.getValueMeta(i).getName();
                if (keyColNames.contains(colName) || (v = inputMeta.getValueMeta(i)).isNull(row[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                log.logBasic(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.SkippingRowNoNonNullValues", (String[])new String[]{fullKey.toString()}));
            }
            return bl;
        }
        return true;
    }

    public static List<Object[]> newNonCQLBatch(int numRows) {
        ArrayList<Object[]> newBatch = new ArrayList<Object[]>(numRows);
        return newBatch;
    }

    public static boolean addRowToNonCQLBatch(List<Object[]> batch, Object[] row, RowMetaInterface inputMeta, ColumnFamilyMetaData familyMeta, boolean insertFieldsNotInMetaData, LogChannelInterface log) throws Exception {
        if (!CassandraUtils.preAddChecks(inputMeta, familyMeta.getKeyColumnNames(), row, log)) {
            return false;
        }
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta = inputMeta.getValueMeta(i);
            String colName = colMeta.getName();
            if (familyMeta.columnExistsInSchema(colName) || insertFieldsNotInMetaData) continue;
            row[i] = null;
        }
        batch.add(row);
        return true;
    }

    public static StringBuilder newCQLBatch(int numRows, String consistency, boolean cql3, boolean unloggedBatch) {
        StringBuilder batch = new StringBuilder(numRows * 80);
        if (unloggedBatch) {
            batch.append("BEGIN UNLOGGED BATCH");
        } else {
            batch.append("BEGIN BATCH");
        }
        if (!cql3 && !Utils.isEmpty((CharSequence)consistency)) {
            batch.append(" USING CONSISTENCY ").append(consistency);
        }
        batch.append("\n");
        return batch;
    }

    public static void completeCQLBatch(StringBuilder batch) {
        batch.append("APPLY BATCH");
    }

    public static String identifierQuoteChar(int cqlMajVersion) {
        if (cqlMajVersion >= 3) {
            return "\"";
        }
        return "'";
    }

    public static boolean addRowToCQLBatch(StringBuilder batch, String colFamilyName, RowMetaInterface inputMeta, Object[] row, ColumnFamilyMetaData familyMeta, boolean insertFieldsNotInMetaData, int cqlMajVersion, Map<String, String> additionalOpts, LogChannelInterface log) throws Exception {
        Set<Object> columnOrder;
        if (!CassandraUtils.preAddChecks(inputMeta, familyMeta.getKeyColumnNames(), row, log)) {
            return false;
        }
        String quoteChar = CassandraUtils.identifierQuoteChar(cqlMajVersion);
        List<String> keyColNames = familyMeta.getKeyColumnNames();
        HashMap<String, String> columnValues = new HashMap<String, String>();
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta = inputMeta.getValueMeta(i);
            String colName = colMeta.getName();
            if (cqlMajVersion < 3 && colName.equals("KEY") && keyColNames.get(0).equalsIgnoreCase("key")) {
                colName = "key";
            }
            if (!familyMeta.columnExistsInSchema(colName) && !insertFieldsNotInMetaData || colMeta.isNull(row[i])) continue;
            columnValues.put(colName, CassandraUtils.kettleValueToCQL(colMeta, row[i], cqlMajVersion));
        }
        if (cqlMajVersion >= 3) {
            colFamilyName = CassandraUtils.cql3MixedCaseQuote(colFamilyName);
            columnOrder = columnValues.keySet();
        } else {
            columnOrder = new LinkedHashSet();
            for (String keyColName : keyColNames) {
                if (!columnValues.containsKey(keyColName)) continue;
                columnOrder.add(keyColName);
            }
            columnOrder.addAll(columnValues.keySet());
        }
        ArrayList<String> columns = new ArrayList<String>(columnOrder.size());
        ArrayList values = new ArrayList(columnOrder.size());
        for (String string : columnOrder) {
            columns.add(quoteChar + string + quoteChar);
            values.add(columnValues.get(string));
        }
        Joiner joiner = Joiner.on((char)',').skipNulls();
        batch.append("INSERT INTO ").append(colFamilyName).append(" (");
        joiner.appendTo(batch, columns);
        batch.append(") VALUES (");
        joiner.appendTo(batch, values);
        batch.append(")");
        if (CassandraUtils.containsInsertOptions(additionalOpts)) {
            batch.append(" USING ");
            boolean bl = true;
            for (Map.Entry<String, String> o : additionalOpts.entrySet()) {
                boolean bl2;
                if (!CassandraUtils.validInsertOption(o.getKey())) continue;
                if (bl2) {
                    batch.append(o.getKey()).append(" ").append(o.getValue());
                    bl2 = false;
                    continue;
                }
                batch.append(" AND ").append(o.getKey()).append(" ").append(o.getValue());
            }
        }
        batch.append("\n");
        return true;
    }

    protected static boolean validInsertOption(String opt) {
        return opt.equalsIgnoreCase("ttl") || opt.equalsIgnoreCase("timestamp");
    }

    protected static boolean containsInsertOptions(Map<String, String> opts) {
        for (String opt : opts.keySet()) {
            if (!CassandraUtils.validInsertOption(opt)) continue;
            return true;
        }
        return false;
    }

    protected static String escapeSingleQuotes(String source) {
        return source.replace("'", "''");
    }

    public static String removeQuotes(String source) {
        String result = source;
        result = source.startsWith("\"") && source.endsWith("\"") ? result.substring(1, result.length() - 1) : result.toLowerCase();
        return result;
    }

    public static String cql3MixedCaseQuote(String source) {
        if (source.toLowerCase().equals(source) || source.startsWith("\"") && source.endsWith("\"")) {
            return source;
        }
        return "\"" + source + "\"";
    }

    public static String kettleValueToCQL(ValueMetaInterface vm, Object value, int cqlMajVersion) throws KettleValueException {
        String quote = cqlMajVersion == 2 ? "'" : "";
        switch (vm.getType()) {
            case 2: {
                UTF8Type u = UTF8Type.instance;
                String toConvert = vm.getString(value);
                ByteBuffer decomposed = u.decompose((Object)toConvert);
                String cassandraString = u.getString(decomposed);
                return "'" + CassandraUtils.escapeSingleQuotes(cassandraString) + "'";
            }
            case 6: {
                DecimalType dt = DecimalType.instance;
                BigDecimal toConvert = vm.getBigNumber(value);
                ByteBuffer decomposed = dt.decompose((Object)toConvert);
                String cassandraString = dt.getString(decomposed);
                return quote + cassandraString + quote;
            }
            case 4: {
                BooleanType bt = BooleanType.instance;
                Boolean toConvert = vm.getBoolean(value);
                ByteBuffer decomposed = bt.decompose((Object)toConvert);
                String cassandraString = bt.getString(decomposed);
                return quote + CassandraUtils.escapeSingleQuotes(cassandraString) + quote;
            }
            case 5: {
                LongType lt = LongType.instance;
                Long toConvert = vm.getInteger(value);
                ByteBuffer decomposed = lt.decompose((Object)toConvert);
                String cassandraString = lt.getString(decomposed);
                return quote + cassandraString + quote;
            }
            case 1: {
                DoubleType dt = DoubleType.instance;
                Double toConvert = vm.getNumber(value);
                ByteBuffer decomposed = dt.decompose((Object)toConvert);
                String cassandraString = dt.getString(decomposed);
                return quote + cassandraString + quote;
            }
            case 3: 
            case 9: {
                DateType d = DateType.instance;
                Date toConvert = vm.getDate(value);
                ByteBuffer decomposed = d.decompose((Object)toConvert);
                String cassandraFormattedDateString = d.getString(decomposed);
                return "'" + CassandraUtils.escapeSingleQuotes(cassandraFormattedDateString) + "'";
            }
            case 7: 
            case 8: {
                throw new KettleValueException(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.CantConvertBinaryToCQL", (String[])new String[0]));
            }
        }
        throw new KettleValueException(BaseMessages.getString(PKG, (String)"CassandraUtils.Error.CantConvertType", (String[])new String[]{vm.getName(), vm.getTypeDesc()}));
    }

    public static String optionsToString(Map<String, String> opts) {
        if (opts.size() == 0) {
            return "";
        }
        StringBuilder optsBuilder = new StringBuilder();
        for (Map.Entry<String, String> e : opts.entrySet()) {
            optsBuilder.append(e.getKey()).append("=").append(e.getValue()).append(" ");
        }
        return optsBuilder.toString();
    }

    public static int numFieldsToBeWritten(RowMetaInterface inputMeta, List<Integer> keyIndex, ColumnFamilyMetaData cassandraMeta, boolean insertFieldsNotInMetaData) {
        int count = keyIndex.size();
        for (int i = 0; i < inputMeta.size(); ++i) {
            ValueMetaInterface colMeta;
            String colName;
            if (keyIndex.contains(i) || !cassandraMeta.columnExistsInSchema(colName = (colMeta = inputMeta.getValueMeta(i)).getName()) && !insertFieldsNotInMetaData) continue;
            ++count;
        }
        return count;
    }

    public static Connection getCassandraConnection(String host, int port, String username, String password, ConnectionFactory.Driver driver, Map<String, String> opts) throws Exception {
        Connection conn = ConnectionFactory.getFactory().getConnection(driver);
        conn.setHosts(host);
        conn.setDefaultPort(port);
        conn.setUsername(username);
        conn.setPassword(password);
        conn.setAdditionalOptions(opts);
        return conn;
    }

    public static String[] getColumnNames(RowMetaInterface inputMeta) {
        String[] columns = new String[inputMeta.size()];
        for (int i = 0; i < inputMeta.size(); ++i) {
            columns[i] = inputMeta.getValueMeta(i).getName();
        }
        return columns;
    }

    public static class BatchOptions {
        public static final String BATCH_TIMEOUT = "batchTimeout";
        public static final String TTL = "TTL";
    }

    public static class CQLOptions {
        public static final String CQLVERSION_OPTION = "cqlVersion";
        public static final String CQL3_STRING = "3.0.1";
        public static final String CQL2_STRING = "2.0.0";
    }

    public static class ConnectionOptions {
        public static final String SOCKET_TIMEOUT = "socketTimeout";
        public static final String MAX_LENGTH = "maxLength";
        public static final String COMPRESSION = "compression";
    }
}

