/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cassandra.driverimpl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.pentaho.cassandra.CassandraUtils;
import org.pentaho.cassandra.driverimpl.DriverCQLRowHandler;
import org.pentaho.cassandra.driverimpl.DriverConnection;
import org.pentaho.cassandra.driverimpl.TableColumnFamilyMetaData;
import org.pentaho.cassandra.spi.CQLRowHandler;
import org.pentaho.cassandra.spi.ColumnFamilyMetaData;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.cassandra.spi.NonCQLRowHandler;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;

public class DriverKeyspace
implements Keyspace {
    protected DriverConnection conn;
    private KeyspaceMetadata meta;
    private String name;

    public DriverKeyspace(DriverConnection conn, KeyspaceMetadata keyspace) {
        this.meta = keyspace;
        this.conn = conn;
        this.name = keyspace.getName();
    }

    @Override
    public void setConnection(Connection conn) throws Exception {
        this.conn = (DriverConnection)conn;
    }

    @Override
    public DriverConnection getConnection() {
        return this.conn;
    }

    @Override
    public void setKeyspace(String keyspaceName) throws Exception {
        this.name = keyspaceName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.conn.setAdditionalOptions(options);
    }

    @Override
    public void executeCQL(String cql, String compresson, String consistencyLevel, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        this.conn.getSession(this.name).execute(cql);
    }

    @Override
    public void createKeyspace(String keyspaceName, Map<String, Object> options, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        SchemaBuilder.createKeyspace((String)keyspaceName);
    }

    @Override
    public List<String> getColumnFamilyNames() throws Exception {
        return this.meta.getTables().stream().map(tab -> tab.getName()).collect(Collectors.toList());
    }

    @Override
    public boolean columnFamilyExists(String colFamName) throws Exception {
        return this.meta.getTable(colFamName) != null;
    }

    @Override
    public ColumnFamilyMetaData getColumnFamilyMetaData(String familyName) throws Exception {
        TableMetadata tableMeta = this.meta.getTable(familyName);
        return new TableColumnFamilyMetaData(this, tableMeta);
    }

    @Override
    public boolean createColumnFamily(String colFamName, RowMetaInterface rowMeta, List<Integer> keyIndexes, String createTableWithClause, LogChannelInterface log) throws Exception {
        Create createTable = SchemaBuilder.createTable((String)colFamName);
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (!keyIndexes.contains(i)) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                createTable.addColumn(valueMeta.getName(), this.getDataType(valueMeta));
                continue;
            }
            ValueMetaInterface key = rowMeta.getValueMeta(i);
            createTable.addPartitionKey(key.getName(), CassandraUtils.getCassandraDataTypeFromValueMeta(key));
        }
        if (!Utils.isEmpty((CharSequence)createTableWithClause)) {
            StringBuilder cql = new StringBuilder(createTable.toString());
            if (!createTableWithClause.toLowerCase().trim().startsWith("with")) {
                cql.append(" WITH ");
            }
            cql.append(createTableWithClause);
            this.getSession().execute(cql.toString());
        } else {
            this.getSession().execute((Statement)createTable);
        }
        return true;
    }

    @Override
    public void updateColumnFamily(String colFamName, RowMetaInterface rowMeta, List<Integer> keyIndexes, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        Session session = this.getSession();
        ColumnFamilyMetaData colFamily = this.getColumnFamilyMetaData(colFamName);
        for (ValueMetaInterface valueMeta : rowMeta.getValueMetaList()) {
            if (colFamily.columnExistsInSchema(valueMeta.getName())) continue;
            session.execute((Statement)SchemaBuilder.alterTable((String)colFamName).alterColumn(valueMeta.getName()).type(this.getDataType(valueMeta)));
        }
    }

    @Override
    public void truncateColumnFamily(String colFamName, LogChannelInterface log) throws UnsupportedOperationException, Exception {
        this.getSession().execute((Statement)QueryBuilder.truncate((String)colFamName));
    }

    protected Session getSession() {
        return this.conn.getSession(this.name);
    }

    private DataType getDataType(ValueMetaInterface valueMeta) {
        return CassandraUtils.getCassandraDataTypeFromValueMeta(valueMeta);
    }

    @Override
    public CQLRowHandler getCQLRowHandler() {
        return new DriverCQLRowHandler(this, this.getSession(), this.getConnection().isExpandCollection());
    }

    @Override
    public NonCQLRowHandler getNonCQLRowHandler() {
        throw new UnsupportedOperationException();
    }
}

