/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.cassandra.CassandraUtils;
import org.pentaho.cassandra.ConnectionFactory;
import org.pentaho.cassandra.cql.CQLUtils;
import org.pentaho.cassandra.cql.Selector;
import org.pentaho.cassandra.spi.ColumnFamilyMetaData;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInput;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputData;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputDialog;
import org.w3c.dom.Node;

@Step(id="CassandraInput", image="Cassandrain.svg", name="Cassandra Input", description="Reads data from a Cassandra table", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/Cassandra_Input", categoryDescription="Big Data")
@InjectionSupported(localizationPrefix="CassandraInput.Injection.")
public class CassandraInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static final Class<?> PKG = CassandraInputMeta.class;
    @Injection(name="CASSANDRA_HOST")
    protected String m_cassandraHost = "localhost";
    @Injection(name="CASSANDRA_PORT")
    protected String m_cassandraPort = "9160";
    @Injection(name="USER_NAME")
    protected String m_username;
    @Injection(name="PASSWORD")
    protected String m_password;
    @Injection(name="CASSANDRA_KEYSPACE")
    protected String m_cassandraKeyspace;
    @Injection(name="USE_QUERY_COMPRESSION")
    protected boolean m_useCompression;
    @Injection(name="CQL_QUERY")
    protected String m_cqlSelectQuery = "SELECT <fields> FROM <column family> WHERE <condition>;";
    @Injection(name="OUTPUT_KEY_VALUE_TIMESTAMP_TUPLES")
    protected boolean m_outputKeyValueTimestampTuples;
    @Injection(name="USE_THRIFT_IO")
    protected boolean m_useThriftIO = false;
    @Injection(name="USE_CQL_VERSION_3")
    protected boolean m_useCQL3 = false;
    @Injection(name="EXECUTE_FOR_EACH_ROW")
    protected boolean m_executeForEachIncomingRow;
    @Injection(name="SOCKET_TIMEOUT")
    protected String m_socketTimeout = "";
    @Injection(name="TRANSPORT_MAX_LENGTH")
    protected String m_maxLength = "";
    protected boolean m_isSelectStarQuery = false;
    protected int m_rowLimit = -1;
    protected int m_colLimit = -1;
    protected int m_rowBatchSize = 100;
    protected int m_colBatchSize = 100;
    protected List<String> m_specificCols;
    private boolean useDriver = true;

    public String getMaxLength() {
        return this.m_maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.m_maxLength = maxLength;
    }

    public void setSocketTimeout(String t) {
        this.m_socketTimeout = t;
    }

    public String getSocketTimeout() {
        return this.m_socketTimeout;
    }

    public void setUseThriftIO(boolean useThrift) {
        this.m_useThriftIO = useThrift;
    }

    public boolean getUseThriftIO() {
        return this.m_useThriftIO;
    }

    public void setUseCQL3(boolean cql3) {
        this.m_useCQL3 = cql3;
    }

    public boolean getUseCQL3() {
        return this.m_useCQL3;
    }

    public void setCassandraHost(String host) {
        this.m_cassandraHost = host;
    }

    public String getCassandraHost() {
        return this.m_cassandraHost;
    }

    public void setCassandraPort(String port) {
        this.m_cassandraPort = port;
    }

    public String getCassandraPort() {
        return this.m_cassandraPort;
    }

    public void setCassandraKeyspace(String keyspace) {
        this.m_cassandraKeyspace = keyspace;
    }

    public String getCassandraKeyspace() {
        return this.m_cassandraKeyspace;
    }

    public void setUseCompression(boolean c) {
        this.m_useCompression = c;
    }

    public boolean getUseCompression() {
        return this.m_useCompression;
    }

    public void setCQLSelectQuery(String query) {
        this.m_cqlSelectQuery = query;
    }

    public String getCQLSelectQuery() {
        return this.m_cqlSelectQuery;
    }

    public void setUsername(String un) {
        this.m_username = un;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String pass) {
        this.m_password = pass;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setOutputKeyValueTimestampTuples(boolean o) {
        this.m_outputKeyValueTimestampTuples = o;
    }

    public boolean getOutputKeyValueTimestampTuples() {
        return this.m_outputKeyValueTimestampTuples;
    }

    public void setExecuteForEachIncomingRow(boolean e) {
        this.m_executeForEachIncomingRow = e;
    }

    public boolean getExecuteForEachIncomingRow() {
        return this.m_executeForEachIncomingRow;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Utils.isEmpty((CharSequence)this.m_cassandraHost)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_host", (String)this.m_cassandraHost));
        }
        if (!Utils.isEmpty((CharSequence)this.m_cassandraPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_port", (String)this.m_cassandraPort));
        }
        if (!Utils.isEmpty((CharSequence)this.m_username)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"username", (String)this.m_username));
        }
        if (!Utils.isEmpty((CharSequence)this.m_password)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.m_password)));
        }
        if (!Utils.isEmpty((CharSequence)this.m_cassandraKeyspace)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_keyspace", (String)this.m_cassandraKeyspace));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_compression", (boolean)this.m_useCompression));
        if (!Utils.isEmpty((CharSequence)this.m_cqlSelectQuery)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cql_select_query", (String)this.m_cqlSelectQuery));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"output_key_value_timestamp_tuples", (boolean)this.m_outputKeyValueTimestampTuples));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_thrift_io", (boolean)this.m_useThriftIO));
        if (!Utils.isEmpty((CharSequence)this.m_socketTimeout)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.m_socketTimeout));
        }
        if (!Utils.isEmpty((CharSequence)this.m_maxLength)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"max_length", (String)this.m_maxLength));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_cql3", (boolean)this.m_useCQL3));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execute_for_each_row", (boolean)this.m_executeForEachIncomingRow));
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        String executeForEachR;
        String useCQL3;
        String thrift;
        this.m_cassandraHost = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_host");
        this.m_cassandraPort = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_port");
        this.m_username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
        this.m_password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
        if (!Utils.isEmpty((CharSequence)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_cassandraKeyspace = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_keyspace");
        this.m_cqlSelectQuery = XMLHandler.getTagValue((Node)stepnode, (String)"cql_select_query");
        this.m_useCompression = XMLHandler.getTagValue((Node)stepnode, (String)"use_compression").equalsIgnoreCase("Y");
        String kV = XMLHandler.getTagValue((Node)stepnode, (String)"output_key_value_timestamp_tuples");
        if (kV != null) {
            this.m_outputKeyValueTimestampTuples = kV.equalsIgnoreCase("Y");
        }
        if ((thrift = XMLHandler.getTagValue((Node)stepnode, (String)"use_thrift_io")) != null) {
            this.m_useThriftIO = thrift.equalsIgnoreCase("Y");
        }
        if (!Utils.isEmpty((CharSequence)(useCQL3 = XMLHandler.getTagValue((Node)stepnode, (String)"use_cql3")))) {
            this.m_useCQL3 = useCQL3.equalsIgnoreCase("Y");
        }
        if (!Utils.isEmpty((CharSequence)(executeForEachR = XMLHandler.getTagValue((Node)stepnode, (String)"execute_for_each_row")))) {
            this.m_executeForEachIncomingRow = executeForEachR.equalsIgnoreCase("Y");
        }
        this.m_socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout");
        this.m_maxLength = XMLHandler.getTagValue((Node)stepnode, (String)"max_length");
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_cassandraHost = rep.getStepAttributeString(id_step, 0, "cassandra_host");
        this.m_cassandraPort = rep.getStepAttributeString(id_step, 0, "cassandra_port");
        this.m_username = rep.getStepAttributeString(id_step, 0, "username");
        this.m_password = rep.getStepAttributeString(id_step, 0, "password");
        if (!Utils.isEmpty((CharSequence)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_cassandraKeyspace = rep.getStepAttributeString(id_step, 0, "cassandra_keyspace");
        this.m_cqlSelectQuery = rep.getStepAttributeString(id_step, 0, "cql_select_query");
        this.m_useCompression = rep.getStepAttributeBoolean(id_step, 0, "use_compression");
        this.m_outputKeyValueTimestampTuples = rep.getStepAttributeBoolean(id_step, 0, "output_key_value_timestamp_tuples");
        this.m_useThriftIO = rep.getStepAttributeBoolean(id_step, 0, "use_thrift_io");
        this.m_useCQL3 = rep.getStepAttributeBoolean(id_step, 0, "use_cql3");
        this.m_executeForEachIncomingRow = rep.getStepAttributeBoolean(id_step, "execute_for_each_row");
        this.m_socketTimeout = rep.getStepAttributeString(id_step, 0, "socket_timeout");
        this.m_maxLength = rep.getStepAttributeString(id_step, 0, "max_length");
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (!Utils.isEmpty((CharSequence)this.m_cassandraHost)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_host", this.m_cassandraHost);
        }
        if (!Utils.isEmpty((CharSequence)this.m_cassandraPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_port", this.m_cassandraPort);
        }
        if (!Utils.isEmpty((CharSequence)this.m_username)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "username", this.m_username);
        }
        if (!Utils.isEmpty((CharSequence)this.m_password)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.m_password));
        }
        if (!Utils.isEmpty((CharSequence)this.m_cassandraKeyspace)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_keyspace", this.m_cassandraKeyspace);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_compression", this.m_useCompression);
        if (!Utils.isEmpty((CharSequence)this.m_cqlSelectQuery)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cql_select_query", this.m_cqlSelectQuery);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "output_key_value_timestamp_tuples", this.m_outputKeyValueTimestampTuples);
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_thrift_io", this.m_useThriftIO);
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_cql3", this.m_useCQL3);
        rep.saveStepAttribute(id_transformation, id_step, 0, "execute_for_each_row", this.m_executeForEachIncomingRow);
        if (!Utils.isEmpty((CharSequence)this.m_socketTimeout)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "socket_timeout", this.m_socketTimeout);
        }
        if (!Utils.isEmpty((CharSequence)this.m_maxLength)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "max_length", this.m_maxLength);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new CassandraInput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new CassandraInputData();
    }

    public void setDefault() {
        this.m_cassandraHost = "localhost";
        this.m_cassandraPort = "9042";
        this.m_cqlSelectQuery = "SELECT <fields> FROM <column family> WHERE <condition>;";
        this.m_useCompression = false;
        this.m_socketTimeout = "";
        this.m_maxLength = "";
        this.m_useCQL3 = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.m_specificCols = null;
        this.m_rowLimit = -1;
        this.m_colLimit = -1;
        rowMeta.clear();
        if (Utils.isEmpty((CharSequence)this.m_cassandraKeyspace)) {
            return;
        }
        String colFamName = null;
        if (!Utils.isEmpty((CharSequence)this.m_cqlSelectQuery)) {
            Keyspace kSpace;
            String subQ = space.environmentSubstitute(this.m_cqlSelectQuery);
            if (!subQ.toLowerCase().startsWith("select")) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NoSelectInQuery", (String[])new String[0]));
                return;
            }
            if (subQ.indexOf(59) < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.QueryTermination", (String[])new String[0]));
                return;
            }
            if (subQ.toLowerCase().indexOf("limit") > 0) {
                String limitS = subQ.toLowerCase().substring(subQ.toLowerCase().indexOf("limit") + 5, subQ.length()).trim();
                limitS = limitS.replaceAll(";", "");
                try {
                    this.m_rowLimit = Integer.parseInt(limitS);
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseLimitClause", (String[])new String[]{this.m_cqlSelectQuery}));
                    this.m_rowLimit = 10000;
                }
            }
            if (subQ.toLowerCase().lastIndexOf("where") > 0) {
                subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
            }
            int fromIndex = subQ.toLowerCase().indexOf("from");
            String tempS = subQ.toLowerCase();
            int offset = fromIndex;
            while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
                tempS = tempS.substring(fromIndex + 4, tempS.length());
                fromIndex = tempS.indexOf("from");
                offset += 4 + fromIndex;
            }
            fromIndex = offset;
            if (fromIndex < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.MustSpecifyAColumnFamily", (String[])new String[0]));
                return;
            }
            colFamName = subQ.substring(fromIndex + 4, subQ.length()).trim();
            colFamName = colFamName.indexOf(32) > 0 ? colFamName.substring(0, colFamName.indexOf(32)) : colFamName.replace(";", "");
            if (colFamName.length() == 0) {
                return;
            }
            if (subQ.toLowerCase().indexOf("first ") > 0) {
                String firstS = subQ.substring(subQ.toLowerCase().indexOf("first") + 5, subQ.length()).trim();
                subQ = firstS.substring(firstS.indexOf(32) + 1, firstS.length());
                firstS = firstS.substring(0, firstS.indexOf(32));
                try {
                    this.m_colLimit = Integer.parseInt(firstS);
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseFirstClause", (String[])new String[]{this.m_cqlSelectQuery}));
                    return;
                }
            } else {
                subQ = subQ.substring(subQ.toLowerCase().indexOf("select") + 6, subQ.length());
            }
            fromIndex = subQ.toLowerCase().indexOf("from");
            Selector[] cols = null;
            if (subQ.indexOf("*") >= 0 && subQ.toLowerCase().indexOf("count(*)") == -1) {
                this.m_isSelectStarQuery = true;
            } else {
                this.m_isSelectStarQuery = false;
                String colsS = subQ.substring(0, fromIndex);
                cols = CQLUtils.getColumnsInSelect(colsS, this.getUseCQL3());
            }
            String hostS = space.environmentSubstitute(this.m_cassandraHost);
            String portS = space.environmentSubstitute(this.m_cassandraPort);
            String userS = this.m_username;
            String passS = this.m_password;
            if (!Utils.isEmpty((CharSequence)userS) && !Utils.isEmpty((CharSequence)passS)) {
                userS = space.environmentSubstitute(this.m_username);
                passS = space.environmentSubstitute(this.m_password);
            }
            String keyspaceS = space.environmentSubstitute(this.m_cassandraKeyspace);
            Connection conn = null;
            try {
                HashMap<String, String> opts = new HashMap<String, String>();
                if (this.m_useCQL3) {
                    opts.put("cqlVersion", "3.0.1");
                }
                conn = CassandraUtils.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS, this.isUseDriver() ? ConnectionFactory.Driver.BINARY_CQL3_PROTOCOL : ConnectionFactory.Driver.LEGACY_THRIFT, opts);
                kSpace = conn.getKeyspace(keyspaceS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logError(ex.getMessage(), ex);
                return;
            }
            try {
                ColumnFamilyMetaData colMeta = kSpace.getColumnFamilyMetaData(colFamName);
                if (this.getOutputKeyValueTimestampTuples()) {
                    ValueMetaInterface km = colMeta.getValueMetaForKey();
                    rowMeta.addValueMeta(km);
                    ValueMetaString vm = new ValueMetaString("ColumnName");
                    rowMeta.addValueMeta((ValueMetaInterface)vm);
                    vm = new ValueMetaString("ColumnValue");
                    rowMeta.addValueMeta((ValueMetaInterface)vm);
                    vm = new ValueMetaInteger("Timestamp");
                    rowMeta.addValueMeta((ValueMetaInterface)vm);
                    conn.closeConnection();
                    if (cols != null) {
                        this.m_specificCols = new ArrayList<String>();
                        for (Selector col : cols) {
                            this.m_specificCols.add(col.getColumnName());
                        }
                    }
                    return;
                }
                if (cols == null) {
                    List<ValueMetaInterface> vms = colMeta.getValueMetasForSchema();
                    for (ValueMetaInterface vm : vms) {
                        rowMeta.addValueMeta(vm);
                    }
                } else {
                    this.m_specificCols = new ArrayList<String>();
                    for (Selector col : cols) {
                        if (!col.isFunction() && !colMeta.columnExistsInSchema(col.getColumnName())) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.DefaultColumnValidator", (Object[])new Object[]{col}));
                        }
                        ValueMetaInterface vm = colMeta.getValueMeta(col);
                        rowMeta.addValueMeta(vm);
                    }
                }
            }
            catch (Exception ex) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.UnableToRetrieveColumnMetaData", (String[])new String[]{colFamName}), new Object[]{ex});
                return;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.closeConnection();
                    }
                    catch (Exception e) {
                        throw new KettleStepException((Throwable)e);
                    }
                }
            }
        }
    }

    public boolean isUseDriver() {
        return this.useDriver && !this.m_useThriftIO && this.m_useCQL3;
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new CassandraInputDialog(shell, meta, transMeta, name);
    }
}

