/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput.writer;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.cassandrasstableoutput.writer.AbstractSSTableWriter;

class CQL2SSTableWriter
extends AbstractSSTableWriter {
    private String keyField;
    private String partitionerClassName;
    private SSTableSimpleUnsortedWriter writer;
    protected static final Class<?> PKG = CQL2SSTableWriter.class;

    CQL2SSTableWriter() {
    }

    @Override
    public void init() throws Exception {
        try {
            Class partitionerClass = Murmur3Partitioner.class;
            if (!Const.isEmpty((String)this.partitionerClassName)) {
                try {
                    partitionerClass = Class.forName(this.partitionerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.writer = this.getSsTableSimpleUnsortedWriter(new File(this.getDirectory()), partitionerClass, this.getKeyspace(), this.getColumnFamily(), this.getBufferSize());
        }
        catch (Throwable t) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SSTableOutput.Error.WriterCreation", (String[])new String[0]), t);
        }
    }

    SSTableSimpleUnsortedWriter getSsTableSimpleUnsortedWriter(File file, Class partitionerClass, String keyspace, String columnFamily, int bufferSize) throws InstantiationException, IllegalAccessException {
        return new SSTableSimpleUnsortedWriter(file, (IPartitioner)partitionerClass.newInstance(), keyspace, columnFamily, (AbstractType)AsciiType.instance, null, bufferSize);
    }

    @Override
    public void processRow(Map<String, Object> record) throws Exception {
        ByteBuffer uuid = CQL2SSTableWriter.valueToBytes(record.get(this.keyField));
        this.writer.newRow(uuid);
        long timestamp = System.currentTimeMillis() * 1000L;
        for (Map.Entry<String, Object> entry : record.entrySet()) {
            if (entry.getKey().equals(this.keyField)) continue;
            this.writer.addColumn(ByteBufferUtil.bytes((String)entry.getKey()), CQL2SSTableWriter.valueToBytes(entry.getValue()), timestamp);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public void setPartitionerClassName(String partitionerClassName) {
        this.partitionerClassName = partitionerClassName;
    }

    static ByteBuffer valueToBytes(Object val) throws Exception {
        if (val == null) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (val instanceof String) {
            return ByteBufferUtil.bytes((String)((String)val));
        }
        if (val instanceof Integer) {
            return ByteBufferUtil.bytes((int)((Integer)val));
        }
        if (val instanceof Float) {
            return ByteBufferUtil.bytes((float)((Float)val).floatValue());
        }
        if (val instanceof Boolean) {
            return ByteBufferUtil.bytes((String)val.toString());
        }
        if (val instanceof Date) {
            return ByteBufferUtil.bytes((long)((Date)val).getTime());
        }
        if (val instanceof Long) {
            return ByteBufferUtil.bytes((long)((Long)val));
        }
        if (val instanceof Double) {
            return ByteBufferUtil.bytes((double)((Double)val));
        }
        if (val instanceof byte[]) {
            return ByteBuffer.wrap((byte[])val);
        }
        return ByteBufferUtil.bytes((String)val.toString());
    }
}

